/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import tools.Tools;

public class BlockData {
    private TreeSet<ModuleInformation> ModuleRatios = new TreeSet();
    private Iterator<ModuleInformation> ExternalIterator;
    private ModuleInformation ExternalModuleInformation;

    public int getNumberOfBlocks() {
        return this.ModuleRatios.size();
    }

    public boolean defaultValues() {
        return this.ModuleRatios.size() == 0;
    }

    public void destroyFactors() {
        this.ModuleRatios.clear();
        System.gc();
    }

    private String splitLine(String object, RandomAccessFile randomAccessFile) throws IOException {
        while (!((String)object).endsWith("};;") && randomAccessFile.getFilePointer() != randomAccessFile.length()) {
            object = (String)object + randomAccessFile.readLine();
        }
        return object;
    }

    public boolean loadData(String string, int n) throws Exception {
        ModuleInformation moduleInformation = new ModuleInformation();
        int n2 = string.indexOf("{") + 1;
        int n3 = string.indexOf(",", n2);
        String string2 = Tools.blanks(string.substring(n2, n3));
        n2 = n3 + 1;
        if ((n3 = string.indexOf(",", n2)) == -1) {
            Tools.showInformationMessage("Old configuration file, modules information will not be extracted.");
            return true;
        }
        String string3 = Tools.blanks(string.substring(n2, n3));
        n2 = n3 + 1;
        n3 = string.indexOf("}", n2);
        String string4 = Tools.blanks(string.substring(n2, n3));
        moduleInformation.setType(string2);
        moduleInformation.setValue(string3);
        moduleInformation.setRatio(string4);
        if (!this.ModuleRatios.contains(moduleInformation)) {
            this.ModuleRatios.add(moduleInformation);
        } else {
            Tools.showInformationMessage("Duplicated block " + moduleInformation + " not updated");
        }
        return true;
    }

    public void saveData(RandomAccessFile randomAccessFile) throws IOException {
        for (ModuleInformation moduleInformation : this.ModuleRatios) {
            randomAccessFile.writeBytes("\"modules information\" {");
            randomAccessFile.writeBytes(" " + moduleInformation.getType() + ", ");
            randomAccessFile.writeBytes(moduleInformation.getValue() + ", ");
            randomAccessFile.writeBytes(moduleInformation.getRatio() + " };;\n");
        }
    }

    public void addModuleRatio(String string, String string2, String string3) {
        ModuleInformation moduleInformation = new ModuleInformation();
        moduleInformation.setType(string);
        moduleInformation.setValue(string2);
        moduleInformation.setRatio(string3);
        if (this.ModuleRatios.contains(moduleInformation)) {
            Tools.showInformationMessage("Duplicated block " + moduleInformation + " not updated");
            return;
        }
        this.ModuleRatios.add(moduleInformation);
    }

    public void startIterator() {
        this.ExternalIterator = this.ModuleRatios.iterator();
    }

    public boolean hasNext() {
        boolean bl = this.ExternalIterator.hasNext();
        this.ExternalModuleInformation = bl ? this.ExternalIterator.next() : null;
        return bl;
    }

    public String getType() {
        if (this.ExternalModuleInformation != null) {
            return this.ExternalModuleInformation.getType();
        }
        throw new NoSuchElementException();
    }

    public String getValue() {
        if (this.ExternalModuleInformation != null) {
            return this.ExternalModuleInformation.getValue();
        }
        throw new NoSuchElementException();
    }

    public String getRatio() {
        if (this.ExternalModuleInformation != null) {
            return this.ExternalModuleInformation.getRatio();
        }
        throw new NoSuchElementException();
    }

    public class ModuleInformation
    implements Comparable<ModuleInformation> {
        private int type = 0;
        private int value = 0;
        private double ratio = 0.0;

        public void setType(String string) {
            try {
                this.type = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showInformationMessage("Wrong format of 'Type' field (" + numberFormatException.toString() + ")");
            }
        }

        public void setValue(String string) {
            try {
                this.value = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showInformationMessage("Wrong format of 'Value' field (" + numberFormatException.toString() + ")");
            }
        }

        public void setRatio(String string) {
            try {
                this.ratio = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showInformationMessage("Wrong format of 'Ratio' field (" + numberFormatException.toString() + ")");
            }
        }

        public int hashCode() {
            return (this.type + this.value) * this.value + this.type;
        }

        public boolean equals(Object object) {
            if (object instanceof ModuleInformation) {
                ModuleInformation moduleInformation = (ModuleInformation)object;
                return this.type == moduleInformation.type && this.value == moduleInformation.value;
            }
            return false;
        }

        @Override
        public int compareTo(ModuleInformation moduleInformation) {
            if (this.type > Integer.parseInt(moduleInformation.getType())) {
                return 1;
            }
            if (this.type == Integer.parseInt(moduleInformation.getType())) {
                if (this.value == Integer.parseInt(moduleInformation.getValue())) {
                    return 0;
                }
                if (this.value > Integer.parseInt(moduleInformation.getValue())) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }

        public String toString() {
            return "(" + this.type + ", " + this.value + ", " + this.ratio + ")";
        }

        public String getType() {
            return Integer.toString(this.type);
        }

        public String getValue() {
            return Integer.toString(this.value);
        }

        public String getRatio() {
            return Double.toString(this.ratio);
        }
    }
}

