/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.BlockData;
import data.ConfigurationData;
import data.DedicatedConnectionData;
import data.EnvironmentData;
import data.FileSystemData;
import data.MappingData;
import data.NodeData;
import data.SimulatorCallData;
import data.Version;
import data.WideAreaNetworkData;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Objects;
import javax.swing.JTextField;
import tools.Tools;

public class Data
implements Version {
    private JTextField currentConfigurationFile;
    public String instrumentedArchitecture = "";
    public static final String ICON_IMAGE = "resources/dimemas_icon.png";
    public static final String BSC_LOGO = "resources/bsc_logo.jpg";
    public static final String RECORDS_DEFINITION_FILE = "resources/records_definition.txt";
    public static final String SDDFA_MAGIC = "SDDFA";
    public static final String DIMEMAS_CFG_MAGIC = "#DIMEMAS_CONFIGURATION";
    public static final int NO_CFG_LOADED = -1;
    public static final int SDDFA = 0;
    public static final int DIMEMAS_CFG = 1;
    int ConfigurationFileType = -1;
    public static final int NO_MAP = -1;
    public static final int UNKNOWN_MAP = 0;
    public static final int FILL_NODE_MAP = 1;
    public static final int N_TASKS_PER_NODE_MAP = 2;
    public static final int INTERLEAVE_MAP = 3;
    public static final int NO_TASKS_DETECTED = -1;
    public static final String FILL_NODE_MAP_STR = "FILL_NODES";
    public static final String N_TASKS_PER_NODE_MAP_STR = "TASKS_PER_NODE";
    public static final String INTERLEAVE_MAP_STR = "INTERLEAVED";
    public static final int DEFAULT_MPI_ITEMS = 15;
    public static final String WAN = "\"wide area network information\" {";
    public static final String CONNECTION = "\"dedicated connection information\" {";
    public static final String ENVIRONMENT = "\"environment information\" {";
    public static final String NODE = "\"node information\" {";
    public static final String MULTINODE = "\"multi node information\" {";
    public static final String MAPPING = "\"mapping information\" {";
    public static final String PREDEF_MAP = "\"predefined mapping information\" {";
    public static final String CONFIG = "\"configuration files\" {";
    public static final String MODULE = "\"modules information\" {";
    public static final String FILE_SYS = "\"file system parameters\" {";
    public static final String ACC_NODE = "\"accelerator node information\" {";
    public WideAreaNetworkData wan = new WideAreaNetworkData();
    public DedicatedConnectionData dedicated = new DedicatedConnectionData();
    public EnvironmentData environment = new EnvironmentData();
    public NodeData nodes_information = new NodeData();
    public MappingData map = new MappingData(this.nodes_information);
    public ConfigurationData config = new ConfigurationData();
    public FileSystemData fileSys = new FileSystemData();
    public SimulatorCallData simOptions = new SimulatorCallData();
    public BlockData block = new BlockData();
    int MapsOnDisk = 0;
    boolean wan_defined = false;

    public Data(JTextField jTextField) {
        this.currentConfigurationFile = jTextField;
        this.currentConfigurationFile.setBorder(null);
        this.currentConfigurationFile.setEditable(false);
    }

    public static boolean checkConfigurationFiles() {
        return true;
    }

    public String getCurrentConfigurationFileLabel() {
        return this.currentConfigurationFile.getText();
    }

    public void setCurrentConfigurationFileLabel(String string) {
        this.currentConfigurationFile.setText(string);
    }

    private String splitLine(String object, RandomAccessFile randomAccessFile) throws IOException {
        while (!((String)object).endsWith("};;") && randomAccessFile.getFilePointer() != randomAccessFile.length()) {
            object = (String)object + randomAccessFile.readLine();
        }
        return object;
    }

    public boolean loadCommunicationData(String string) throws Exception {
        String string2 = null;
        int n = 0;
        RandomAccessFile randomAccessFile = new RandomAccessFile(new File(string), "r");
        while (randomAccessFile.getFilePointer() != randomAccessFile.length()) {
            string2 = randomAccessFile.readLine();
            if (!string2.startsWith("Machine globalop:")) continue;
            ++n;
        }
        if (n / 15 != this.environment.getNumberOfMachines()) {
            Tools.showInformationMessage("Number of machines mismatch.\nSelected file: " + n / 15 + "\nConfiguration: " + this.environment.getNumberOfMachines());
            randomAccessFile.close();
            return false;
        }
        string2 = null;
        randomAccessFile.seek(0L);
        block1: while (randomAccessFile.getFilePointer() != randomAccessFile.length()) {
            string2 = randomAccessFile.readLine();
            if (string2.startsWith("Flight time:")) {
                string2 = Tools.blanks(string2.substring(string2.lastIndexOf(":") + 1, string2.length()));
                this.environment.ftLoad(string2);
                continue;
            }
            if (string2.startsWith("Machine globalop:")) {
                string2 = Tools.blanks(string2.substring(string2.indexOf(":") + 1, string2.length()));
                int n2 = Integer.parseInt(string2.substring(0, string2.indexOf(" ")));
                string2 = Tools.blanks(string2.substring(string2.indexOf(" "), string2.length()));
                if (n2 < this.environment.getNumberOfMachines() && n2 == Integer.parseInt(this.environment.machine[n2].getId())) {
                    this.environment.machine[n2].mpiLoad(string2);
                    continue;
                }
                for (int i = 0; i < this.environment.getNumberOfMachines(); ++i) {
                    if (n2 != Integer.parseInt(this.environment.machine[i].getId())) continue;
                    this.environment.machine[i].mpiLoad(string2);
                    continue block1;
                }
                continue;
            }
            if (!string2.startsWith("External globalop:")) continue;
            this.wan.mpiLoad(Tools.blanks(string2.substring(string2.lastIndexOf(":") + 1, string2.length())));
        }
        randomAccessFile.close();
        return true;
    }

    public void loadFromDisk(String string) {
        int n;
        int n2;
        RandomAccessFile randomAccessFile;
        int n3 = 0;
        int n4 = 0;
        long l = 0L;
        Object object = "";
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            randomAccessFile = new RandomAccessFile(new File(string), "r");
        }
        catch (Throwable throwable) {
            String string2 = "Unable to open configuration file \"" + string + "\"\n";
            string2 = string2 + throwable.getMessage();
            Tools.showInformationMessage(string2);
            return;
        }
        try {
            if (randomAccessFile.length() == 0L) {
                Tools.showInformationMessage("The configuration file selected is empty");
                return;
            }
            object = randomAccessFile.readLine();
            l = randomAccessFile.getFilePointer();
            n4 = ++n3;
            if (!bl2) {
                if (((String)object).equalsIgnoreCase(SDDFA_MAGIC) || ((String)object).equalsIgnoreCase(DIMEMAS_CFG_MAGIC)) {
                    bl2 = true;
                    this.MapsOnDisk = 0;
                    this.wan.initialValues();
                    this.dedicated.destroyConnections();
                    this.environment.destroyMachines();
                    this.nodes_information.destroyNodes();
                    this.map.initialValues();
                    this.config.initialValues();
                    this.fileSys.initialValues();
                    this.block.destroyFactors();
                    this.ConfigurationFileType = ((String)object).equalsIgnoreCase(SDDFA_MAGIC) ? 0 : 1;
                } else {
                    Tools.showInformationMessage("The file you selected is not a valid Dimemas configuration file");
                    return;
                }
            }
            object = randomAccessFile.readLine().trim();
            while (randomAccessFile.getFilePointer() != randomAccessFile.length()) {
                if (this.ConfigurationFileType == 0) {
                    if (((String)object).startsWith("#")) {
                        if (((String)object).endsWith("};;")) {
                            if (bl && (((String)object).startsWith("#0") || ((String)object).startsWith("#7"))) {
                                bl = false;
                            }
                            l = randomAccessFile.getFilePointer();
                            n4 = n3++;
                            object = randomAccessFile.readLine().trim();
                            continue;
                        }
                        object = (String)object + randomAccessFile.readLine().trim();
                        ++n3;
                        continue;
                    }
                    object = randomAccessFile.readLine().trim();
                    ++n3;
                    continue;
                }
                if (((String)object).startsWith("/*")) {
                    if (((String)object).endsWith("*/")) {
                        l = randomAccessFile.getFilePointer();
                        n4 = n3++;
                        object = randomAccessFile.readLine().trim();
                        continue;
                    }
                    object = (String)object + randomAccessFile.readLine().trim();
                    ++n3;
                    continue;
                }
                object = randomAccessFile.readLine().trim();
                ++n3;
            }
            randomAccessFile.seek(l);
            n3 = n4;
            this.wan_defined = false;
            bl3 = false;
            block5: while (!bl3 && randomAccessFile.getFilePointer() != randomAccessFile.length()) {
                object = randomAccessFile.readLine().trim();
                ++n3;
                if (((String)object).startsWith(WAN)) {
                    if (!this.wan_defined) {
                        if (!this.wan.loadData(this.splitLine((String)object, randomAccessFile), n3)) {
                            bl3 = true;
                        }
                        this.wan_defined = true;
                        continue;
                    }
                    Tools.showErrorMessage("Multiple 'wide area network information' records on file");
                    bl3 = true;
                    continue;
                }
                if (((String)object).startsWith(CONNECTION)) {
                    this.dedicated.setNumberOfConnections(Integer.parseInt(this.wan.getDedicated()));
                    this.dedicated.createConnections();
                    for (n2 = 0; n2 < this.dedicated.getNumberOfConnections(); ++n2) {
                        if (!this.dedicated.connection[n2].loadData(this.splitLine((String)object, randomAccessFile), bl, n3)) {
                            bl3 = true;
                            continue block5;
                        }
                        object = randomAccessFile.readLine();
                    }
                    continue;
                }
                if (((String)object).startsWith(ENVIRONMENT)) {
                    this.environment.setNumberOfMachines(Integer.parseInt(this.wan.getMachines()));
                    if (this.instrumentedArchitecture.equalsIgnoreCase("")) {
                        this.environment.createMachines(this.instrumentedArchitecture, this.environment.DEFAULT_BUSES);
                    } else {
                        n2 = 0;
                        if (n2 == 0) {
                            this.environment.createMachines(this.instrumentedArchitecture, this.environment.DEFAULT_BUSES);
                        }
                    }
                    n2 = 0;
                    for (n = 0; n < this.environment.getNumberOfMachines(); ++n) {
                        if (!this.environment.machine[n].loadData(this.splitLine((String)object, randomAccessFile), bl, n3)) {
                            bl3 = true;
                            break;
                        }
                        n2 += Integer.parseInt(this.environment.machine[n].getNodes());
                        object = randomAccessFile.readLine().trim();
                        ++n3;
                    }
                    if (bl3) continue;
                    this.nodes_information.setNumberOfNodes(n2);
                    this.instrumentedArchitecture = this.environment.machine[0].getArchitecture(false);
                    continue;
                }
                if (((String)object).startsWith(NODE)) {
                    this.nodes_information.createNodes(this.environment);
                    if (this.nodes_information.loadSingleNodeData(this.splitLine((String)object, randomAccessFile), bl, n3)) continue;
                    bl3 = true;
                    break;
                }
                if (((String)object).startsWith(MULTINODE)) {
                    this.nodes_information.createNodes(this.environment);
                    if (this.nodes_information.loadMultiNodeData((String)object, n3)) continue;
                    bl3 = true;
                    break;
                }
                if (((String)object).startsWith(MAPPING)) {
                    if (this.MapsOnDisk == 0 && !this.map.loadTaskMapping(this.splitLine((String)object, randomAccessFile), n3)) {
                        bl3 = true;
                    }
                    ++this.MapsOnDisk;
                    continue;
                }
                if (((String)object).startsWith(PREDEF_MAP)) {
                    if (this.MapsOnDisk == 0 && !this.map.loadPredefinedMapping(this.splitLine((String)object, randomAccessFile), n3)) {
                        bl3 = true;
                    }
                    ++this.MapsOnDisk;
                    continue;
                }
                if (((String)object).startsWith(CONFIG)) {
                    if (!this.config.loadData(this.splitLine((String)object, randomAccessFile), n3)) {
                        bl3 = true;
                        continue;
                    }
                    if (this.config.getCommunication(false).equalsIgnoreCase("")) continue;
                    this.loadCommunicationData(this.config.getCommunication(false));
                    continue;
                }
                if (((String)object).startsWith(MODULE)) {
                    if (this.block.loadData(this.splitLine((String)object, randomAccessFile), n3)) continue;
                    bl3 = true;
                    continue;
                }
                if (((String)object).startsWith(FILE_SYS)) {
                    if (this.fileSys.loadData(this.splitLine((String)object, randomAccessFile), n3)) continue;
                    bl3 = true;
                    continue;
                }
                if (!((String)object).startsWith(ACC_NODE) || this.nodes_information.loadAccNodeData(this.splitLine((String)object, randomAccessFile), bl, n3)) continue;
                bl3 = true;
            }
        }
        catch (Exception exception) {
            String string3 = "Unable to open configuration file \"" + string + "\"\n";
            string3 = string3 + exception.getMessage();
            Tools.showInformationMessage(string3);
            return;
        }
        if (bl3) {
            this.wan.initialValues();
            this.dedicated.destroyConnections();
            this.environment.destroyMachines();
            this.nodes_information.destroyNodes();
            this.map.initialValues();
            this.config.initialValues();
            this.fileSys.initialValues();
            this.block.destroyFactors();
            this.currentConfigurationFile.setText("");
            Tools.showInformationMessage("Malformed configuration file. It won't be loaded");
        } else {
            if (this.MapsOnDisk > 1) {
                Tools.showInformationMessage("Current configuration file has multiple applications defined.\n\nOnly first application will be loaded");
            }
            block8: for (n2 = this.environment.getNumberOfMachines() - 1; n2 >= 0; --n2) {
                for (n = 0; n < this.nodes_information.getNumberOfNodes(); ++n) {
                    if (!this.nodes_information.node[n].getMachine_id().equalsIgnoreCase(this.environment.machine[n2].getId())) continue;
                    this.environment.machine[n2].setNodeArchitecture(this.nodes_information.node[n].getArchitecture(false));
                    continue block8;
                }
            }
            this.currentConfigurationFile.setText(string);
        }
    }

    public boolean saveToDisk(String string) {
        String string2 = this.checkCorrectConfiguration();
        if (string2 != null) {
            Tools.showErrorDialog(string2 + "\n\nConfiguration file won't be saved");
            return false;
        }
        try {
            int n;
            RandomAccessFile randomAccessFile = new RandomAccessFile(new File(string), "rw");
            randomAccessFile.setLength(0L);
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(RECORDS_DEFINITION_FILE);
            randomAccessFile.writeBytes("#DIMEMAS_CONFIGURATION\n\n");
            if (inputStream == null) {
                Tools.showInformationMessage("Unable to open record description file, it won't be included in configuration file\nPlease report this error to tools@bsc.es");
            } else {
                String string3;
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string3 = bufferedReader.readLine()) != null) {
                    randomAccessFile.writeBytes(string3 + "\n");
                }
                bufferedReader.close();
                inputStreamReader.close();
                inputStream.close();
                randomAccessFile.writeBytes("\n");
            }
            this.wan.saveData(randomAccessFile);
            randomAccessFile.writeBytes("\n");
            for (n = 0; n < this.dedicated.getNumberOfConnections(); ++n) {
                this.dedicated.connection[n].saveData(randomAccessFile);
            }
            randomAccessFile.writeBytes("\n");
            if (this.environment.getNumberOfMachines() == 0) {
                this.environment.setNumberOfMachines(1);
                Objects.requireNonNull(this.environment);
                this.environment.createMachines("", this.environment.DEFAULT_BUSES);
            }
            for (n = 0; n < this.environment.getNumberOfMachines(); ++n) {
                this.environment.machine[n].saveData(randomAccessFile);
            }
            randomAccessFile.writeBytes("\n");
            this.nodes_information.saveData(randomAccessFile);
            randomAccessFile.writeBytes("\n");
            this.map.saveData(randomAccessFile);
            randomAccessFile.writeBytes("\n");
            this.config.saveData(randomAccessFile);
            randomAccessFile.writeBytes("\n");
            this.block.saveData(randomAccessFile);
            randomAccessFile.writeBytes("\n");
            this.fileSys.saveData(randomAccessFile);
            randomAccessFile.close();
            System.out.println("Configuration file saved: " + string);
        }
        catch (IOException iOException) {
            Tools.showErrorDialog("Error writing configuration file\n" + iOException.toString());
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorDialog("Error creating default values, configuration file not written\n" + numberFormatException.toString());
            return false;
        }
        return true;
    }

    private String checkCorrectConfiguration() {
        if (this.nodes_information.getNumberOfNodes() == 0) {
            return "No nodes defined in current machine!";
        }
        if (this.map.getMapInfo() == -1) {
            return "No tasks mapping defined!";
        }
        return null;
    }
}

