/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.io.IOException;
import java.io.RandomAccessFile;
import tools.Tools;

public class DedicatedConnectionData {
    public static final String DEFAULT_SOURCE = "";
    public static final String DEFAULT_TARGET = "";
    public static final String DEFAULT_BANDWIDTH = "0.0";
    public static final String DEFAULT_TAGS = "0";
    public static final String DEFAULT_FIRST_SIZE = "0";
    public static final String DEFAULT_FIRST_COND = "";
    public static final String DEFAULT_OPERATION = "";
    public static final String DEFAULT_SECOND_SIZE = "0";
    public static final String DEFAULT_SECOND_COND = "";
    public static final String DEFAULT_COMMUNICATORS = "1";
    public static final String DEFAULT_STARTUP = "0.0";
    public static final String DEFAULT_FLIGHT = "0.0";
    private int nConnections = 0;
    public Connection[] connection;

    public int getNumberOfConnections() {
        return this.nConnections;
    }

    public void setNumberOfConnections(int n) {
        this.nConnections = n;
    }

    public boolean defaultValues() {
        for (int i = 0; i < this.nConnections; ++i) {
            if (this.connection[i].defaultValues()) continue;
            return false;
        }
        return true;
    }

    public void createConnections() {
        this.connection = new Connection[this.nConnections];
        for (int i = this.nConnections - 1; i >= 0; --i) {
            this.connection[i] = new Connection(String.valueOf(i));
        }
    }

    public void eraseConnectionInfo() {
        for (int i = this.nConnections - 1; i >= 0; --i) {
            this.connection[i].initialValues();
        }
    }

    public void destroyConnections() {
        for (int i = this.nConnections - 1; i >= 0; --i) {
            this.connection[i] = null;
        }
        this.connection = null;
        this.nConnections = 0;
        System.gc();
    }

    public void changeAtConnections() {
        Connection[] connectionArray = new Connection[this.nConnections];
        if (this.connection == null) {
            this.createConnections();
        } else {
            if (this.nConnections >= this.connection.length) {
                for (int i = this.nConnections - 1; i >= this.connection.length; --i) {
                    connectionArray[i] = new Connection(Integer.toString(i));
                }
                for (int i = i; i >= 0; --i) {
                    connectionArray[i] = this.connection[i];
                    this.connection[i] = null;
                }
            } else {
                for (int i = this.connection.length - 1; i >= this.nConnections; --i) {
                    this.connection[i] = null;
                }
                for (int i = this.nConnections - 1; i >= 0; --i) {
                    connectionArray[i] = this.connection[i];
                    this.connection[i] = null;
                }
            }
            this.connection = null;
            this.connection = connectionArray;
            connectionArray = null;
            System.gc();
        }
    }

    public class Connection {
        public final String DEFAULT_ID;
        private int nTags;
        private int nComm;
        private String id;
        private String source;
        private String target;
        private String bandwidth;
        private String tags;
        private String firstSize;
        private String firstCond;
        private String operation;
        private String secondSize;
        private String secondCond;
        private String communicators;
        private String startup;
        private String flightTime;

        public Connection(String string) {
            this.DEFAULT_ID = string;
            this.initialValues();
        }

        public void initialValues() {
            this.nTags = 0;
            this.nComm = 0;
            this.id = this.DEFAULT_ID;
            this.source = "";
            this.target = "";
            this.bandwidth = "0.0";
            this.tags = "0";
            this.firstSize = "0";
            this.firstCond = "";
            this.operation = "";
            this.secondSize = "0";
            this.secondCond = "";
            this.communicators = DedicatedConnectionData.DEFAULT_COMMUNICATORS;
            this.startup = "0.0";
            this.flightTime = "0.0";
        }

        public boolean defaultValues() {
            return this.id.equalsIgnoreCase(this.DEFAULT_ID) && this.source.equalsIgnoreCase("") && this.target.equalsIgnoreCase("") && this.bandwidth.equalsIgnoreCase("0.0") && this.tags.equalsIgnoreCase("0") && this.firstSize.equalsIgnoreCase("0") && this.firstCond.equalsIgnoreCase("") && this.operation.equalsIgnoreCase("") && this.secondSize.equalsIgnoreCase("0") && this.secondCond.equalsIgnoreCase("") && this.communicators.equalsIgnoreCase(DedicatedConnectionData.DEFAULT_COMMUNICATORS) && this.startup.equalsIgnoreCase("0.0") && this.flightTime.equalsIgnoreCase("0.0");
        }

        public boolean loadData(String string, boolean bl, int n) throws Exception {
            int n2 = "\"dedicated connection information\" {".length();
            int n3 = string.indexOf(",", n2);
            this.setId(Tools.blanks(string.substring(n2, n3)));
            n2 = n3 + 1;
            n3 = string.indexOf(",", n2);
            this.setSource(Tools.blanks(string.substring(n2, n3)));
            n2 = n3 + 1;
            n3 = string.indexOf(",", n2);
            this.setTarget(Tools.blanks(string.substring(n2, n3)));
            n2 = n3 + 1;
            n3 = string.indexOf(",", n2);
            this.setBandwidth(Tools.blanks(string.substring(n2, n3)));
            n2 = string.indexOf("{", n3) + 1;
            n3 = string.indexOf("}", n2);
            this.setTags(Tools.blanks(string.substring(n2, n3)));
            n2 = string.indexOf(",", n3) + 1;
            n3 = string.indexOf(",", n2);
            this.setFirstSize(Tools.blanks(string.substring(n2, n3)));
            n2 = n3 + 1;
            n3 = string.indexOf(",", n2);
            this.setFirstCond(Tools.blanks(string.substring(n2, n3)));
            n2 = n3 + 1;
            n3 = string.indexOf(",", n2);
            this.setOperation(Tools.blanks(string.substring(n2, n3)));
            n2 = n3 + 1;
            n3 = string.indexOf(",", n2);
            this.setSecondSize(Tools.blanks(string.substring(n2, n3)));
            n2 = n3 + 1;
            n3 = string.indexOf(",", n2);
            this.setSecondCond(Tools.blanks(string.substring(n2, n3)));
            n2 = string.indexOf("{", n3) + 1;
            n3 = string.indexOf("}", n2);
            this.setCommunicators(Tools.blanks(string.substring(n2, n3)));
            n2 = string.indexOf(",", n3) + 1;
            if (bl) {
                n3 = string.indexOf("}", n2);
                this.setStartup(Tools.blanks(string.substring(n2, n3)));
            } else {
                n3 = string.indexOf(",", n2);
                this.setStartup(Tools.blanks(string.substring(n2, n3)));
                n2 = n3 + 1;
                n3 = string.indexOf("}", n2);
                this.setFlightTime(Tools.blanks(string.substring(n2, n3)));
            }
            return true;
        }

        public void saveData(RandomAccessFile randomAccessFile) throws IOException {
            randomAccessFile.writeBytes("\"dedicated connection information\" {");
            randomAccessFile.writeBytes(this.getId() + ", ");
            randomAccessFile.writeBytes(this.getSource() + ", ");
            randomAccessFile.writeBytes(this.getTarget() + ", ");
            randomAccessFile.writeBytes(this.getBandwidth() + ", ");
            randomAccessFile.writeBytes(this.getTags(true) + ", ");
            randomAccessFile.writeBytes(this.getFirstSize() + ", ");
            randomAccessFile.writeBytes(this.getFirstCond(true) + ", ");
            randomAccessFile.writeBytes(this.getOperation(true) + ", ");
            randomAccessFile.writeBytes(this.getSecondSize() + ", ");
            randomAccessFile.writeBytes(this.getSecondCond(true) + ", ");
            randomAccessFile.writeBytes(this.getCommunicators(true) + ", ");
            randomAccessFile.writeBytes(this.getStartup() + ",");
            randomAccessFile.writeBytes(this.getFlightTime() + "};;\n");
        }

        public String getId() {
            return this.id;
        }

        public String getSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }

        public String getBandwidth() {
            return this.bandwidth;
        }

        public String getTags(boolean bl) {
            if (bl) {
                return "[" + this.nTags + "] {" + this.tags + "}";
            }
            return this.tags;
        }

        public String getFirstSize() {
            return this.firstSize;
        }

        public String getFirstCond(boolean bl) {
            if (bl) {
                return "\"" + this.firstCond + "\"";
            }
            return this.firstCond;
        }

        public String getOperation(boolean bl) {
            if (bl) {
                return "\"" + this.operation + "\"";
            }
            return this.operation;
        }

        public String getSecondSize() {
            return this.secondSize;
        }

        public String getSecondCond(boolean bl) {
            if (bl) {
                return "\"" + this.secondCond + "\"";
            }
            return this.secondCond;
        }

        public String getCommunicators(boolean bl) {
            if (bl) {
                return "[" + this.nComm + "] {" + this.communicators + "}";
            }
            return this.communicators;
        }

        public String getStartup() {
            return this.startup;
        }

        public String getFlightTime() {
            return this.flightTime;
        }

        public void setId(String string) throws Exception {
            try {
                Integer.parseInt(string);
                this.id = string;
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorMessage("DEDICATED CONNECTION ID");
                throw numberFormatException;
            }
        }

        public void setSource(String string) throws Exception {
            try {
                Integer.parseInt(string);
                this.source = string;
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorMessage("SOURCE MACHINE");
                throw numberFormatException;
            }
        }

        public void setTarget(String string) throws Exception {
            try {
                Integer.parseInt(string);
                this.target = string;
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorMessage("TARGET MACHINE");
                throw numberFormatException;
            }
        }

        public void setBandwidth(String string) throws Exception {
            try {
                Double.parseDouble(string);
                this.bandwidth = Tools.filterForDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorMessage("CONNECTION BANDWIDTH");
                throw numberFormatException;
            }
        }

        public void setTags(String string) throws Exception {
            this.nTags = Tools.verifyData(string, "LIST OF TAGS");
            if (this.nTags == -1) {
                throw new Exception();
            }
            this.tags = string;
        }

        public void setFirstSize(String string) throws Exception {
            try {
                Integer.parseInt(string);
                this.firstSize = string;
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorMessage("FIRST MESSAGE CONDITION");
                throw numberFormatException;
            }
        }

        public void setFirstCond(String string) {
            this.firstCond = string.startsWith("\"") && string.endsWith("\"") ? Tools.blanks(string.substring(1, string.length() - 1)) : string;
        }

        public void setOperation(String string) {
            this.operation = string.startsWith("\"") && string.endsWith("\"") ? Tools.blanks(string.substring(1, string.length() - 1)) : string;
        }

        public void setSecondSize(String string) throws Exception {
            try {
                Integer.parseInt(string);
                this.secondSize = string;
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorMessage("SECOND MESSAGE CONDITION");
                throw numberFormatException;
            }
        }

        public void setSecondCond(String string) {
            this.secondCond = string.startsWith("\"") && string.endsWith("\"") ? Tools.blanks(string.substring(1, string.length() - 1)) : string;
        }

        public void setCommunicators(String string) throws Exception {
            this.nComm = Tools.verifyData(string, "LIST OF COMMUNICATORS");
            if (this.nComm == -1) {
                throw new Exception();
            }
            this.communicators = string;
        }

        public void setStartup(String string) throws Exception {
            try {
                Double.parseDouble(string);
                this.startup = Tools.filterForDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorMessage("CONNECTION STARTUP");
                throw numberFormatException;
            }
        }

        public void setFlightTime(String string) throws Exception {
            try {
                Double.parseDouble(string);
                this.flightTime = Tools.filterForDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorMessage("FLIGHT TIME");
                throw numberFormatException;
            }
        }
    }
}

