/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tools.Tools;

public class EnvironmentData {
    public final String COMM_CT = "1";
    public final String COMM_LIN = "2";
    public final String COMM_LOG = "3";
    public final String DEFAULT_NODE_ARCHITECTURE = "";
    public final String DEFAULT_NAME = "";
    public final String DEFAULT_ARCHITECTURE = "";
    public final String DEFAULT_NODES = "1";
    public final String DEFAULT_BANDWIDTH = "0.0";
    public final String DEFAULT_BUSES = "0";
    public final String DEFAULT_COMMUNICATION = "1";
    private double[][] ft;
    private int nMachines = 0;
    public Machine[] machine;

    public int getNumberOfMachines() {
        return this.nMachines;
    }

    public void setNumberOfMachines(int n) {
        this.nMachines = n;
        if (this.nMachines == 1) {
            this.ft = new double[1][1];
        } else if (this.ft == null) {
            this.ft = new double[this.nMachines][this.nMachines - 1];
        } else {
            double[][] dArray = this.ft;
            this.ft = null;
            this.ft = new double[this.nMachines][this.nMachines - 1];
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[i].length; ++j) {
                    if (i >= this.nMachines || j >= this.nMachines - 1) continue;
                    this.ft[i][j] = dArray[i][j];
                }
            }
        }
    }

    public void ftSetValue(int n, int n2, double d) {
        this.ft[n][n2] = d;
    }

    public String ftGetValue(int n, int n2) {
        return Double.toString(this.ft[n][n2]);
    }

    public void ftLoad(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.indexOf(" ", n2);
        int n4 = -1;
        String string2 = Tools.blanks(string.substring(n2, n3));
        for (int i = 0; i < this.nMachines; ++i) {
            if (!string2.equalsIgnoreCase(this.machine[i].getId())) continue;
            n4 = i;
            break;
        }
        while (n4 != -1 && n3 != string.length() && n < this.nMachines) {
            n2 = n3 + 1;
            if ((n3 = string.indexOf(" ", n2)) == -1) {
                n3 = string.length();
            }
            if (n < n4) {
                this.ft[n4][n] = Double.parseDouble(Tools.blanks(string.substring(n2, n3)));
            } else if (n > n4) {
                this.ft[n4][n - 1] = Double.parseDouble(Tools.blanks(string.substring(n2, n3)));
            }
            ++n;
        }
    }

    public void ftSave(RandomAccessFile randomAccessFile) throws IOException {
        for (int i = 0; i < this.nMachines; ++i) {
            randomAccessFile.writeBytes("Flight time: " + this.machine[i].getId() + " ");
            for (int j = 0; j < this.nMachines - 1; ++j) {
                if (i == j) {
                    randomAccessFile.writeBytes("0.0 ");
                }
                randomAccessFile.writeBytes(this.ft[i][j] + " ");
            }
            if (i == this.nMachines - 1) {
                randomAccessFile.writeBytes("0.0 ");
            }
            randomAccessFile.writeBytes("\n");
        }
    }

    public void mpiBackup() {
        for (int i = this.nMachines - 1; i >= 0; --i) {
            this.machine[i].mpiBackupData();
        }
    }

    public void mpiRestore() {
        for (int i = this.nMachines - 1; i >= 0; --i) {
            this.machine[i].mpiRestoreData();
        }
    }

    public boolean defaultValues() {
        for (int i = 0; i < this.nMachines; ++i) {
            if (this.machine[i].defaultValues()) continue;
            return false;
        }
        return true;
    }

    public void createMachines(String string, String string2) throws NumberFormatException {
        this.machine = new Machine[this.nMachines];
        for (int i = this.nMachines - 1; i >= 0; --i) {
            this.machine[i] = new Machine(String.valueOf(i));
            this.machine[i].setArchitecture(string);
            this.machine[i].setBuses(string2);
        }
    }

    public void eraseMachineInfo() {
        for (int i = this.nMachines - 1; i >= 0; --i) {
            this.machine[i].initialValues();
        }
    }

    public void destroyMachines() {
        for (int i = this.nMachines - 1; i >= 0; --i) {
            this.machine[i] = null;
        }
        this.machine = null;
        this.nMachines = 0;
        System.gc();
    }

    public void changeAtMachines() throws Exception {
        Machine[] machineArray = new Machine[this.nMachines];
        if (this.machine == null) {
            this.createMachines("", "0");
        } else {
            if (this.nMachines >= this.machine.length) {
                for (int i = this.nMachines - 1; i >= this.machine.length; --i) {
                    machineArray[i] = new Machine(Integer.toString(i));
                }
                for (int i = i; i >= 0; --i) {
                    machineArray[i] = this.machine[i];
                    this.machine[i] = null;
                }
            } else {
                for (int i = this.machine.length - 1; i >= this.nMachines; --i) {
                    this.machine[i] = null;
                }
                for (int i = this.nMachines - 1; i >= 0; --i) {
                    machineArray[i] = this.machine[i];
                    this.machine[i] = null;
                }
            }
            this.machine = null;
            this.machine = machineArray;
            machineArray = null;
            System.gc();
        }
    }

    public class Machine {
        private String DEFAULT_ID;
        private String nodeArchitecture;
        private String name;
        private String id;
        private String architecture;
        private String nodes;
        private String bandwidth;
        private String buses;
        private String communication;
        private int[][] mpi = new int[5][15];
        private int[][] temp_mpi = new int[5][15];

        public Machine(String string) {
            this.DEFAULT_ID = string;
            this.initialValues();
        }

        private void initialValues() {
            this.nodeArchitecture = "";
            this.name = "";
            this.id = this.DEFAULT_ID;
            this.architecture = "";
            this.nodes = "1";
            this.bandwidth = "0.0";
            this.buses = "0";
            this.communication = "1";
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 15; ++j) {
                    this.mpi[i][j] = 0;
                    this.temp_mpi[i][j] = 0;
                }
            }
        }

        private void mpiBackupData() {
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 15; ++j) {
                    this.temp_mpi[i][j] = this.mpi[i][j];
                }
            }
        }

        private void mpiRestoreData() {
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 15; ++j) {
                    this.mpi[i][j] = this.temp_mpi[i][j];
                }
            }
        }

        public boolean mpiConfigured() {
            return this.temp_mpi[0][0] != 0;
        }

        public int mpiGetValue(int n, int n2) {
            return this.mpi[n - 1][n2];
        }

        public void mpiSetValue(int n, int n2, int n3) {
            this.mpi[n - 1][n2] = n3;
        }

        public void mpiLoad(String string) {
            int n = 0;
            int n2 = string.indexOf(" ", n);
            int n3 = Integer.parseInt(Tools.blanks(string.substring(n, n2)));
            n = n2 + 1;
            n2 = string.indexOf(" ", n);
            this.mpi[0][n3] = Tools.mpiValue(0, Tools.blanks(string.substring(n, n2)));
            n = n2 + 1;
            n2 = string.indexOf(" ", n);
            this.mpi[1][n3] = Tools.mpiValue(1, Tools.blanks(string.substring(n, n2)));
            n = n2 + 1;
            n2 = string.indexOf(" ", n);
            this.mpi[2][n3] = Tools.mpiValue(2, Tools.blanks(string.substring(n, n2)));
            n = n2 + 1;
            n2 = string.length();
            this.mpi[3][n3] = Tools.mpiValue(3, Tools.blanks(string.substring(n, n2)));
        }

        public void mpiSave(RandomAccessFile randomAccessFile) throws IOException {
            for (int i = 0; i < 15; ++i) {
                if (this.mpi[0][i] == 0) {
                    if (this.communication.equalsIgnoreCase("1")) {
                        this.mpi[0][i] = 4;
                    } else if (this.communication.equalsIgnoreCase("2")) {
                        this.mpi[0][i] = 3;
                    } else if (this.communication.equalsIgnoreCase("3")) {
                        this.mpi[0][i] = 2;
                    }
                    this.mpi[1][i] = Tools.mpiValue(1, "MAX");
                    this.mpi[2][i] = Tools.mpiValue(1, "0");
                    this.mpi[3][i] = Tools.mpiValue(1, "MAX");
                    this.mpi[4][i] = 1;
                }
                randomAccessFile.writeBytes("Machine globalop: " + this.id + " " + i + " " + Tools.mpiString(0, this.mpi[0][i]) + " " + Tools.mpiString(1, this.mpi[1][i]) + " " + Tools.mpiString(2, this.mpi[2][i]) + " " + Tools.mpiString(3, this.mpi[3][i]) + " \n");
            }
        }

        public boolean defaultValues() {
            return this.nodeArchitecture.equalsIgnoreCase("") && this.name.equalsIgnoreCase("") && this.id.equalsIgnoreCase(this.DEFAULT_ID) && this.architecture.equalsIgnoreCase("") && this.nodes.equalsIgnoreCase("1") && this.bandwidth.equalsIgnoreCase("0.0") && this.buses.equalsIgnoreCase("0") && this.communication.equalsIgnoreCase("1");
        }

        public boolean loadData(String string, boolean bl, int n) throws Exception {
            Pattern pattern = Pattern.compile("\"environment information\" \\{(.*)\\};;$");
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) {
                Tools.showErrorDialog("Wrong node information record structure");
                return false;
            }
            String string2 = matcher.group(1);
            String[] stringArray = string2.split(",");
            if (stringArray.length != 7) {
                Tools.showErrorDialog("Wrong node information record fields");
                return false;
            }
            this.setName(Tools.blanks(stringArray[0]));
            this.setId(Tools.blanks(stringArray[1]));
            this.setArchitecture(Tools.blanks(stringArray[2]));
            this.setNodes(Tools.blanks(stringArray[3]));
            this.setBandwidth(Tools.blanks(stringArray[4]));
            this.setBuses(Tools.blanks(stringArray[5]));
            this.setCommunication(Tools.blanks(stringArray[6]));
            return true;
        }

        public void saveData(RandomAccessFile randomAccessFile) throws IOException {
            randomAccessFile.writeBytes("\"environment information\" {");
            randomAccessFile.writeBytes(this.getName(true) + ", ");
            randomAccessFile.writeBytes(this.getId() + ", ");
            randomAccessFile.writeBytes(this.getArchitecture(true) + ", ");
            randomAccessFile.writeBytes(this.getNodes() + ", ");
            randomAccessFile.writeBytes(this.getBandwidth() + ", ");
            randomAccessFile.writeBytes(this.getBuses() + ", ");
            randomAccessFile.writeBytes(this.getCommunication() + "};;\n");
        }

        public String getNodeArchitecture() {
            return this.nodeArchitecture;
        }

        public void setNodeArchitecture(String string) {
            this.nodeArchitecture = string;
        }

        public String getName(boolean bl) {
            if (bl) {
                return "\"" + this.name + "\"";
            }
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public String getArchitecture(boolean bl) {
            if (bl) {
                return "\"" + this.architecture + "\"";
            }
            return this.architecture;
        }

        public String getNodes() {
            return this.nodes;
        }

        public String getBandwidth() {
            return this.bandwidth;
        }

        public String getBuses() {
            return this.buses;
        }

        public String getCommunication() {
            return this.communication;
        }

        public void setName(String string) {
            this.name = string.startsWith("\"") && string.endsWith("\"") ? string.substring(1, string.length() - 1) : string;
        }

        public void setId(String string) throws NumberFormatException {
            try {
                Integer.parseInt(string);
                this.id = string;
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorMessage("MACHINE ID");
                throw numberFormatException;
            }
        }

        public void setArchitecture(String string) {
            this.architecture = string.startsWith("\"") && string.endsWith("\"") ? string.substring(1, string.length() - 1) : string;
        }

        public void setNodes(String string) throws NumberFormatException {
            try {
                Integer.parseInt(string);
                this.nodes = string;
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorMessage("NUMBER OF NODES");
                throw numberFormatException;
            }
        }

        public void setBandwidth(String string) throws NumberFormatException {
            try {
                Double.parseDouble(string);
                this.bandwidth = Tools.filterForDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorMessage("NETWORK BANDWIDTH");
                throw numberFormatException;
            }
        }

        public void setBuses(String string) throws NumberFormatException {
            try {
                Integer.parseInt(string);
                this.buses = string;
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorMessage("NUMBER OF BUSES");
                throw numberFormatException;
            }
        }

        public void setCommunication(String string) throws NumberFormatException {
            try {
                Integer.parseInt(string);
                this.communication = string;
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorMessage("COMMUNICATION MODEL");
                throw numberFormatException;
            }
        }
    }
}

