/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.io.IOException;
import java.io.RandomAccessFile;
import tools.Tools;

public class FileSystemData {
    public final String DEFAULT_LATENCY = "0.0";
    public final String DEFAULT_BANDWIDTH = "0.0";
    public final String DEFAULT_SIZE = "8.0";
    public final String DEFAULT_REQ = "0";
    public final String DEFAULT_HIT = "1.0";
    private String latency;
    private String bandwidth;
    private String size;
    private String req;
    private String hit;

    public boolean loadData(String string, int n) throws Exception {
        int n2 = "\"file system parameters\" {".length();
        int n3 = string.indexOf(",", n2);
        this.setLatency(Tools.blanks(string.substring(n2, n3)));
        n2 = n3 + 1;
        n3 = string.indexOf(",", n2);
        this.setBandwidth(Tools.blanks(string.substring(n2, n3)));
        n2 = n3 + 1;
        n3 = string.indexOf(",", n2);
        this.setSize(Tools.blanks(string.substring(n2, n3)));
        n2 = n3 + 1;
        n3 = string.indexOf(",", n2);
        this.setReq(Tools.blanks(string.substring(n2, n3)));
        n2 = n3 + 1;
        n3 = string.indexOf("}", n2);
        this.setHit(Tools.blanks(string.substring(n2, n3)));
        return true;
    }

    public void saveData(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeBytes("\"file system parameters\" {");
        randomAccessFile.writeBytes(this.getLatency() + ", ");
        randomAccessFile.writeBytes(this.getBandwidth() + ", ");
        randomAccessFile.writeBytes(this.getSize() + ", ");
        randomAccessFile.writeBytes(this.getReq() + ", ");
        randomAccessFile.writeBytes(this.getHit() + "};;\n");
    }

    public FileSystemData() {
        this.initialValues();
    }

    public void initialValues() {
        this.latency = "0.0";
        this.bandwidth = "0.0";
        this.size = "8.0";
        this.req = "0";
        this.hit = "1.0";
    }

    public boolean defaultValues() {
        return this.latency.equalsIgnoreCase("0.0") && this.bandwidth.equalsIgnoreCase("0.0") && this.size.equalsIgnoreCase("8.0") && this.req.equalsIgnoreCase("0") && this.hit.equalsIgnoreCase("1.0");
    }

    public String getLatency() {
        return this.latency;
    }

    public String getBandwidth() {
        return this.bandwidth;
    }

    public String getSize() {
        return this.size;
    }

    public String getReq() {
        return this.req;
    }

    public String getHit() {
        return this.hit;
    }

    public void setLatency(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.latency = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("DISK LATENCY");
            throw numberFormatException;
        }
    }

    public void setBandwidth(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.bandwidth = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("DISK BANDWIDTH");
            throw numberFormatException;
        }
    }

    public void setSize(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.size = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("BLOCK SIZE");
            throw numberFormatException;
        }
    }

    public void setReq(String string) throws Exception {
        try {
            Integer.parseInt(string);
            this.req = string;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("CONCURRENT REQUESTS");
            throw numberFormatException;
        }
    }

    public void setHit(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.hit = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("HIT RATIO");
            throw numberFormatException;
        }
    }
}

