/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.NodeData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tools.Tools;

public class MappingData {
    public final int DEFAULT_TASKS = -1;
    public final String DEFAULT_TRACEFILE = "";
    public final int[] DEFAULT_MAP = new int[0];
    NodeData nodesInformation;
    private String tracefile;
    private int nTasks;
    private int[] map;
    int mapInfo;
    int nTasksPerNode;
    boolean modified = false;

    public MappingData(NodeData nodeData) {
        this.nodesInformation = nodeData;
        this.initialValues();
    }

    public boolean loadTaskMapping(String string, int n) throws Exception {
        Pattern pattern = Pattern.compile("^\"mapping information\" \\{\"(.*)\", (\\d+), \\[(\\d+)\\]\\s*\\{(.*)\\}\\};;$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            this.tracefile = matcher.group(1);
            if (!this.checkNumberOfTasks(this.tracefile)) {
                Tools.showInformationMessage("Unable to access to tracefile '" + this.tracefile + "'. The number of tasks read from may be incorrect");
            }
            this.nTasks = Integer.parseInt(matcher.group(2));
            int n2 = Integer.parseInt(matcher.group(3));
            String[] stringArray = matcher.group(4).split(",");
            if (this.nTasks != n2 || this.nTasks != stringArray.length) {
                Tools.showErrorDialog("Incorrect length of the map array in current file");
                return false;
            }
            this.map = new int[this.nTasks];
            for (int i = 0; i < this.nTasks; ++i) {
                try {
                    this.map[i] = Integer.parseInt(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    Tools.showErrorDialog("Incorrect node value in the map array present in current file");
                    return true;
                }
            }
        } else {
            Tools.showErrorDialog("Unable to read the mapping information");
            return false;
        }
        MapTest mapTest = this.detectMap(this.map);
        this.mapInfo = mapTest.mapInfo;
        this.nTasksPerNode = mapTest.nTasksPerNode;
        return true;
    }

    public boolean loadPredefinedMapping(String string, int n) throws Exception {
        String string2;
        Pattern pattern = Pattern.compile("^\"predefined mapping information\" \\{(.*)\\};;$");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            Tools.showErrorDialog("Unable to read the predefined mapping information (line " + n + ")");
            return false;
        }
        String string3 = matcher.group(1);
        String[] stringArray = string3.split(",");
        if (stringArray.length == 2) {
            stringArray[0] = stringArray[0].trim();
            stringArray[1] = stringArray[1].trim();
            this.tracefile = stringArray[0].substring(1, stringArray[0].length() - 1);
            string2 = stringArray[1].substring(1, stringArray[1].length() - 1);
            if (!this.checkNumberOfTasks(this.tracefile)) {
                Tools.showInformationMessage("Unable to access to tracefile '" + this.tracefile + "'. The number of taks remains unknown to compute the mappings");
                this.nTasks = -1;
            }
        } else {
            string3 = string3.trim();
            string2 = string3.substring(1, string3.length() - 1);
            string2 = string2.trim();
            this.tracefile = "";
            this.nTasks = -1;
        }
        return this.checkPredefinedMapString(string2);
    }

    public void saveData(RandomAccessFile randomAccessFile) throws IOException {
        if (this.mapInfo == -1) {
            Tools.showErrorMessage("No task mapping information available to be saved");
        } else if (this.mapInfo == 0) {
            randomAccessFile.writeBytes("\"mapping information\" {");
            randomAccessFile.writeBytes(this.getTracefile(true) + ", ");
            randomAccessFile.writeBytes(this.getTasks() + ", ");
            randomAccessFile.writeBytes(this.getMap(true) + "};;\n");
        } else {
            randomAccessFile.writeBytes("\"predefined mapping information\" {");
            if (!this.tracefile.isEmpty()) {
                randomAccessFile.writeBytes(this.getTracefile(true));
                randomAccessFile.writeBytes(", ");
            }
            randomAccessFile.writeBytes(this.getPredefinedMapLabel() + "};;\n");
        }
    }

    public void initialValues() {
        this.tracefile = "";
        this.nTasks = -1;
        this.map = this.DEFAULT_MAP;
        this.mapInfo = -1;
        this.nTasksPerNode = 1;
    }

    public boolean defaultValues() {
        return this.mapInfo == -1;
    }

    public boolean clearMap() {
        if (this.mapInfo == -1) {
            return false;
        }
        this.nTasks = -1;
        this.map = new int[0];
        this.mapInfo = -1;
        return true;
    }

    public String getTracefile(boolean bl) {
        if (bl) {
            return "\"" + this.tracefile + "\"";
        }
        return this.tracefile;
    }

    public int getTasks() {
        return this.nTasks;
    }

    public String getMap(boolean bl) {
        Object object = "";
        if (bl) {
            object = this.nTasks == 0 || this.map.length == 0 ? (String)object + "[0];" : (String)object + "[" + this.nTasks + "]";
        }
        if (this.map.length > 0) {
            object = (String)object + " {" + this.map[0];
            for (int i = 1; i < this.map.length; ++i) {
                object = (String)object + "," + this.map[i];
            }
            object = (String)object + "}";
        }
        return object;
    }

    public int[] getMap() {
        return this.map;
    }

    public int getMapInfo() {
        return this.mapInfo;
    }

    public int getNTasksPerNode() {
        return this.nTasksPerNode;
    }

    public void setTracefile(String string) {
        this.tracefile = string.startsWith("\"") && string.endsWith("\"") ? string.substring(1, string.length() - 1) : string;
        if (this.checkNumberOfTasks(this.tracefile)) {
            if (this.mapInfo != -1) {
                this.generateMap();
            }
        } else {
            Tools.showInformationMessage("Unable to access to tracefile '" + this.tracefile + "'. The number of taks remains unknown to compute the mappings");
            this.nTasks = -1;
        }
    }

    public void setTasks(int n) {
        this.nTasks = n;
    }

    public void setMap(int[] nArray) {
        this.map = nArray;
    }

    public String setMapInfo(int n) {
        this.mapInfo = n;
        return this.generateMap();
    }

    public void setNTasksPerNode(int n) {
        this.nTasksPerNode = n;
    }

    public String changeAtNodes() {
        return this.generateMap();
    }

    private String generateMap() {
        return switch (this.mapInfo) {
            case -1 -> null;
            case 1 -> {
                MapResult var2_2 = this.mapFillingNodes();
                this.map = var2_2.generatedMap;
                yield var2_2.errorMessage;
            }
            case 2 -> {
                MapResult var2_3 = this.mapNTasksPerNode(this.nTasksPerNode);
                this.map = var2_3.generatedMap;
                yield var2_3.errorMessage;
            }
            case 3 -> {
                MapResult var2_4 = this.mapInterleaved();
                this.map = var2_4.generatedMap;
                yield var2_4.errorMessage;
            }
            case 0 -> "Unable to generate an irregular map";
            default -> "Wrong map value";
        };
    }

    private boolean checkNumberOfTasks(String string) {
        Matcher matcher;
        String string2;
        RandomAccessFile randomAccessFile;
        File file = new File(string);
        if (!file.exists() || !file.isFile()) {
            return false;
        }
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        do {
            try {
                string2 = randomAccessFile.readLine();
            }
            catch (IOException iOException) {
                return false;
            }
        } while (string2.equals(""));
        if (string2.startsWith("#DIMEMAS")) {
            Pattern pattern = Pattern.compile("#DIMEMAS:\"(.*)\":(.*):(\\d+)\\((.*)$");
            matcher = pattern.matcher(string2);
            if (!matcher.matches()) {
                return false;
            }
        } else {
            if (string2.startsWith("SDDFA;;")) {
                return false;
            }
            return false;
        }
        String string3 = matcher.group(3);
        this.nTasks = Integer.parseInt(string3);
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private boolean checkPredefinedMapString(String string) {
        if (string.indexOf("FILL_NODES") != -1) {
            this.mapInfo = 1;
        } else if (string.indexOf("TASKS_PER_NODE") != -1) {
            String[] stringArray = string.split(" ");
            if (stringArray.length != 2) {
                Tools.showErrorMessage("Error in 'n' tasks per node mapping definition (" + string + ")");
                return false;
            }
            try {
                this.nTasksPerNode = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorMessage("Wrong number of tasks in 'n' tasks per node definition (" + string + ")");
                return false;
            }
            this.mapInfo = 2;
        } else if (string.indexOf("INTERLEAVED") != -1) {
            this.mapInfo = 3;
        } else {
            Tools.showErrorMessage("Unknown map defined (" + string + ")");
        }
        return true;
    }

    public MapTest detectMap(int[] nArray) {
        int n;
        MapTest mapTest = new MapTest();
        int n2 = this.nodesInformation.getNumberOfNodes();
        int[] nArray2 = this.nodesInformation.getCpusPerNode();
        if (nArray.length == 0) {
            mapTest.mapInfo = -1;
            mapTest.nTasksPerNode = 0;
            return mapTest;
        }
        boolean bl = true;
        boolean bl2 = true;
        int n3 = 0;
        int n4 = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int[] nArray3 = new int[n2];
        for (n = 0; n < nArray.length; ++n) {
            int n5 = nArray[n];
            nArray3[n5] = nArray3[n5] + 1;
        }
        for (n = 0; n < nArray3.length; ++n) {
            if (nArray3[n] > nArray2[n]) {
                bl = false;
                break;
            }
            if (nArray3[n] >= nArray2[n] || nArray3[n] <= 0) continue;
            ++n3;
        }
        if (bl && n3 <= 1) {
            mapTest.mapInfo = 1;
            mapTest.nTasksPerNode = 0;
            return mapTest;
        }
        for (n = 0; n < nArray3.length; ++n) {
            if (nArray3[n] == 0) continue;
            hashSet.add(nArray3[n]);
        }
        if (hashSet.size() == 1) {
            Integer[] integerArray = hashSet.toArray(new Integer[0]);
            mapTest.mapInfo = 2;
            mapTest.nTasksPerNode = integerArray[0];
            return mapTest;
        }
        for (n = 0; n < nArray.length; ++n) {
            if (n == 0) {
                n4 = nArray[0];
                continue;
            }
            if (nArray[n] != n4 + 1 % n2) {
                bl2 = false;
                break;
            }
            n4 = nArray[n];
        }
        if (bl2) {
            mapTest.mapInfo = 3;
            mapTest.nTasksPerNode = 0;
            return mapTest;
        }
        mapTest.mapInfo = 0;
        mapTest.nTasksPerNode = 0;
        return mapTest;
    }

    public MapResult mapFillingNodes() {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = this.nodesInformation.getNumberOfNodes();
        int[] nArray = this.nodesInformation.getCpusPerNode();
        int n3 = 0;
        MapResult mapResult = new MapResult();
        if (this.nTasks > 0) {
            mapResult.generatedMap = new int[this.nTasks];
            for (int i = 0; i < nArray.length && !bl; ++i) {
                for (int j = 0; j < nArray[i] && !bl; ++j) {
                    mapResult.generatedMap[n] = i;
                    if (++n == this.nTasks) {
                        bl = true;
                    }
                    ++n3;
                }
            }
            while (n < this.nTasks) {
                mapResult.generatedMap[n] = n2 - 1;
                bl2 = true;
                ++n;
            }
            if (bl2) {
                mapResult.errorMessage = "Total available CPUs (" + n3 + ") less than the number of tasks\nLast node in the machine will be saturated";
            }
        }
        return mapResult;
    }

    public MapResult mapNTasksPerNode(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.nodesInformation.getNumberOfNodes();
        MapResult mapResult = new MapResult();
        if (this.nTasks > 0) {
            mapResult.generatedMap = new int[this.nTasks];
            if (n * n4 < this.nTasks) {
                mapResult.errorMessage = n + " tasks per node on " + n4 + " nodes is less than the total application tasks (" + this.nTasks + ")";
            }
            for (int i = 0; i < this.nTasks; ++i) {
                if (n3 < n) {
                    mapResult.generatedMap[i] = n2;
                    ++n3;
                    continue;
                }
                mapResult.generatedMap[i] = ++n2;
                n3 = 1;
            }
        }
        return mapResult;
    }

    public MapResult mapInterleaved() {
        int n = this.nodesInformation.getNumberOfNodes();
        MapResult mapResult = new MapResult();
        if (this.nTasks > 0) {
            mapResult.generatedMap = new int[this.nTasks];
            for (int i = 0; i < this.nTasks; ++i) {
                mapResult.generatedMap[i] = i % n;
            }
            mapResult.errorMessage = null;
        }
        return mapResult;
    }

    private String getPredefinedMapLabel() {
        switch (this.mapInfo) {
            case 1: {
                return "\"FILL_NODES\"";
            }
            case 2: {
                return "\"" + String.valueOf(this.nTasksPerNode) + " TASKS_PER_NODE\"";
            }
            case 3: {
                return "\"INTERLEAVED\"";
            }
        }
        return "";
    }

    public class MapTest {
        public int mapInfo;
        public int nTasksPerNode;

        public void MapTest() {
            this.mapInfo = -1;
            this.nTasksPerNode = 1;
        }
    }

    public class MapResult {
        public int[] generatedMap;
        public String errorMessage;

        public void MapResult() {
            this.generatedMap = new int[0];
            this.errorMessage = null;
        }
    }
}

