/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.io.IOException;
import java.io.RandomAccessFile;
import tools.Tools;

public class Node {
    private String DEFAULT_MACHINE_ID;
    private String DEFAULT_NODE_ID;
    public static final String DEFAULT_ARCHITECTURE = "";
    public static final String DEFAULT_PROCESSORS = "1";
    public static final String DEFAULT_CPU_RATIO = "1.0";
    public static final String DEFAULT_INTRA_NODE_STARTUP = "0.0";
    public static final String DEFAULT_INTRA_NODE_BANDWIDTH = "0.0";
    public static final String DEFAULT_INTRA_NODE_BUSES = "1";
    public static final String DEFAULT_INTRA_NODE_IN_LINKS = "1";
    public static final String DEFAULT_INTRA_NODE_OUT_LINKS = "0";
    public static final String DEFAULT_INTER_NODE_STARTUP = "0.0";
    public static final String DEFAULT_INTER_NODE_IN_LINKS = "1";
    public static final String DEFAULT_INTER_NODE_OUT_LINKS = "1";
    public static final String DEFAULT_WAN_STARTUP = "0.0";
    public static final String DEFAULT_ACC_NUMBER = "1";
    public static final String DEFAULT_ACC_STARTUP = "0.0";
    public static final String DEFAULT_ACC_MEM_STARTUP = "0.0";
    public static final String DEFAULT_ACC_BANDWIDTH = "0.0";
    public static final String DEFAULT_ACC_BUSES = "1";
    public static final String DEFAULT_ACC_RATIO = "1.0";
    public static final Boolean DEFAULT_ACC = false;
    public static final int NODE_RECORD_NO_INTRA_NODE_FIELD_COUNT = 11;
    public static final int NODE_RECORD_WITH_NODE_ID_FIELD_COUNT = 14;
    public static final int NODE_RECORD_FIELD_COUNT = 13;
    public static final int ACC_NODE_RECORD_FIELD_COUNT = 7;
    private String machine_id;
    private String node_id;
    private String architecture;
    private String processors;
    private String cpu_ratio;
    private String intra_node_startup;
    private String intra_node_bandwidth;
    private String intra_node_buses;
    private String intra_node_in_links;
    private String intra_node_out_links;
    private String inter_node_startup;
    private String inter_node_in_links;
    private String inter_node_out_links;
    private String wan_startup;
    private Boolean acc;
    private String acc_number;
    private String acc_startup;
    private String acc_mem_startup;
    private String acc_bandwidth;
    private String acc_buses;
    private String acc_ratio;

    public Node(String string, String string2) {
        this.DEFAULT_NODE_ID = string;
        this.DEFAULT_MACHINE_ID = string2;
        this.initialValues();
    }

    public void initialValues() {
        this.machine_id = this.DEFAULT_MACHINE_ID;
        this.node_id = this.DEFAULT_NODE_ID;
        this.architecture = DEFAULT_ARCHITECTURE;
        this.processors = "1";
        this.cpu_ratio = "1.0";
        this.intra_node_startup = "0.0";
        this.intra_node_bandwidth = "0.0";
        this.intra_node_buses = "1";
        this.intra_node_in_links = "1";
        this.intra_node_out_links = DEFAULT_INTRA_NODE_OUT_LINKS;
        this.inter_node_startup = "0.0";
        this.inter_node_in_links = "1";
        this.inter_node_out_links = "1";
        this.wan_startup = "0.0";
        this.acc = DEFAULT_ACC;
        this.acc_number = "1";
        this.acc_startup = "0.0";
        this.acc_mem_startup = "0.0";
        this.acc_bandwidth = "0.0";
        this.acc_buses = "1";
        this.acc_ratio = "1.0";
    }

    public boolean defaultValues() {
        return this.machine_id.equalsIgnoreCase(this.DEFAULT_MACHINE_ID) && this.node_id.equalsIgnoreCase(this.DEFAULT_NODE_ID) && this.architecture.equalsIgnoreCase(DEFAULT_ARCHITECTURE) && this.processors.equalsIgnoreCase("1") && this.cpu_ratio.equalsIgnoreCase("1.0") && this.intra_node_startup.equalsIgnoreCase("0.0") && this.intra_node_bandwidth.equalsIgnoreCase("0.0") && this.intra_node_buses.equalsIgnoreCase("1") && this.intra_node_in_links.equalsIgnoreCase("1") && this.intra_node_out_links.equalsIgnoreCase(DEFAULT_INTRA_NODE_OUT_LINKS) && this.inter_node_startup.equalsIgnoreCase("0.0") && this.inter_node_in_links.equalsIgnoreCase("1") && this.inter_node_out_links.equalsIgnoreCase("1") && this.wan_startup.equalsIgnoreCase("0.0") && this.acc.equals(DEFAULT_ACC) && this.acc_number.equalsIgnoreCase("1") && this.acc_startup.equalsIgnoreCase("0.0") && this.acc_mem_startup.equalsIgnoreCase("0.0") && this.acc_bandwidth.equalsIgnoreCase("0.0") && this.acc_buses.equalsIgnoreCase("1") && this.acc_ratio.equalsIgnoreCase("1.0");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            return this.machine_id.equals(node.getMachine_id()) && this.architecture.equals(node.getArchitecture(false)) && this.processors.equals(node.getProcessors()) && this.cpu_ratio.equals(node.getCPURatio()) && this.intra_node_startup.equals(node.getIntraNodeStartup()) && this.intra_node_buses.equals(node.getIntraNodeBuses()) && this.intra_node_in_links.equals(node.getIntraNodeInLinks()) && this.intra_node_out_links.equals(node.getIntraNodeOutLinks()) && this.inter_node_startup.equals(node.getInterNodeStartup()) && this.inter_node_in_links.equals(node.getInterNodeInLinks()) && this.inter_node_out_links.equals(node.getInterNodeOutLinks()) && this.wan_startup.equals(node.getWANStartup()) && this.acc.equals(node.getAcc()) && this.acc_number.equals(node.getAccNumber()) && this.acc_startup.equals(node.getAccStartup()) && this.acc_mem_startup.equals(node.getAccMemStartup()) && this.acc_bandwidth.equals(node.getAccBandwidth()) && this.acc_buses.equals(node.getAccBuses()) && this.acc_ratio.equals(node.getAccRatio());
        }
        return false;
    }

    public void saveData(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeBytes("\"node information\" {");
        randomAccessFile.writeBytes(this.getMachine_id() + ", ");
        randomAccessFile.writeBytes(this.getArchitecture(true) + ", ");
        randomAccessFile.writeBytes(this.getProcessors() + ", ");
        randomAccessFile.writeBytes(this.getCPURatio() + ", ");
        randomAccessFile.writeBytes(this.getIntraNodeStartup() + ", ");
        randomAccessFile.writeBytes(this.getIntraNodeBandwidth() + ", ");
        randomAccessFile.writeBytes(this.getIntraNodeBuses() + ", ");
        randomAccessFile.writeBytes(this.getIntraNodeInLinks() + ", ");
        randomAccessFile.writeBytes(this.getIntraNodeOutLinks() + ", ");
        randomAccessFile.writeBytes(this.getInterNodeStartup() + ", ");
        randomAccessFile.writeBytes(this.getInterNodeInLinks() + ", ");
        randomAccessFile.writeBytes(this.getInterNodeOutLinks() + ", ");
        randomAccessFile.writeBytes(this.getWANStartup() + "};;\n");
    }

    public void saveAccData(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeBytes("\"accelerator node information\" {");
        randomAccessFile.writeBytes(this.getNode_id() + ", ");
        randomAccessFile.writeBytes(this.getAccNumber() + ", ");
        randomAccessFile.writeBytes(this.getAccStartup() + ", ");
        randomAccessFile.writeBytes(this.getAccMemStartup() + ", ");
        randomAccessFile.writeBytes(this.getAccBandwidth() + ", ");
        randomAccessFile.writeBytes(this.getAccBuses() + ", ");
        randomAccessFile.writeBytes(this.getAccRatio() + "};;\n");
    }

    public String getMachine_id() {
        return this.machine_id;
    }

    public String getNode_id() {
        return this.node_id;
    }

    public String getArchitecture(boolean bl) {
        if (bl) {
            return "\"" + this.architecture + "\"";
        }
        return this.architecture;
    }

    public String getProcessors() {
        return this.processors;
    }

    public String getCPURatio() {
        return this.cpu_ratio;
    }

    public String getIntraNodeStartup() {
        return this.intra_node_startup;
    }

    public String getIntraNodeBandwidth() {
        return this.intra_node_bandwidth;
    }

    public String getIntraNodeBuses() {
        return this.intra_node_buses;
    }

    public String getIntraNodeInLinks() {
        return this.intra_node_in_links;
    }

    public String getIntraNodeOutLinks() {
        return this.intra_node_out_links;
    }

    public String getInterNodeStartup() {
        return this.inter_node_startup;
    }

    public String getInterNodeInLinks() {
        return this.inter_node_in_links;
    }

    public String getInterNodeOutLinks() {
        return this.inter_node_out_links;
    }

    public String getWANStartup() {
        return this.wan_startup;
    }

    public Boolean getAcc() {
        return this.acc;
    }

    public String getAccNumber() {
        return this.acc_number;
    }

    public String getAccStartup() {
        return this.acc_startup;
    }

    public String getAccMemStartup() {
        return this.acc_mem_startup;
    }

    public String getAccBandwidth() {
        return this.acc_bandwidth;
    }

    public String getAccBuses() {
        return this.acc_buses;
    }

    public String getAccRatio() {
        return this.acc_ratio;
    }

    public void setMachine_id(String string) throws Exception {
        try {
            Integer.parseInt(string);
            this.machine_id = string;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("MACHINE ID");
            throw numberFormatException;
        }
    }

    public void setNode_id(String string) throws Exception {
        try {
            Integer.parseInt(string);
            this.node_id = string;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("NODE ID");
            throw numberFormatException;
        }
    }

    public void setArchitecture(String string) {
        this.architecture = string.startsWith("\"") && string.endsWith("\"") ? string.substring(1, string.length() - 1) : string;
    }

    public void setProcessors(String string) throws Exception {
        try {
            Integer.parseInt(string);
            this.processors = string;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("NUMBER OF PROCESSORS");
            throw numberFormatException;
        }
    }

    public void setCPURatio(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.cpu_ratio = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("RELATIVE PROCESSOR SPEED");
            throw numberFormatException;
        }
    }

    public void setIntraNodeStartup(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.intra_node_startup = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("WRONG INTRA-NODE COMMUNICATIONS STARTUP VALUE");
            throw numberFormatException;
        }
    }

    public void setIntraNodeBandwidth(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.intra_node_bandwidth = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("WRONG INTRA-NODE COMMUNICATIONS BANDWIDTH VALUE");
            throw numberFormatException;
        }
    }

    public void setIntraNodeBuses(String string) throws Exception {
        try {
            Integer.parseInt(string);
            this.intra_node_buses = string;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("WRONG INTRA-NODE COMMUNICATIONS BUSES VALUE");
            throw numberFormatException;
        }
    }

    public void setIntraNodeInLinks(String string) throws Exception {
        try {
            Integer.parseInt(string);
            this.intra_node_in_links = string;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("WRONG INTRA-NODE COMMUNICATIONS INPUT LINKS VALUE");
            throw numberFormatException;
        }
    }

    public void setIntraNodeOutLinks(String string) throws Exception {
        try {
            Integer.parseInt(string);
            this.intra_node_out_links = string;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("WRONG INTRA-NODE COMMUNICATIONS OUTPUT LINKS VALUE");
            throw numberFormatException;
        }
    }

    public void setInterNodeStartup(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.inter_node_startup = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("WRONG INTER-NODE COMMUNICATIONS STARTUP VALUE");
            throw numberFormatException;
        }
    }

    public void setInterNodeInLinks(String string) throws Exception {
        try {
            Integer.parseInt(string);
            this.inter_node_in_links = string;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("WRONG INTER-NODE COMMUNICATIONS INPUT LINKS VALUE");
            throw numberFormatException;
        }
    }

    public void setInterNodeOutLinks(String string) throws Exception {
        try {
            Integer.parseInt(string);
            this.inter_node_out_links = string;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("WRONG INTER-NODE COMMUNICATIONS OUTPUT LINKS VALUE");
            throw numberFormatException;
        }
    }

    public void setWANStartup(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.wan_startup = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("WRONG INTER-MACHINES (WAN) COMMUNICATIONS STARTUP VALUE");
            throw numberFormatException;
        }
    }

    public void setAcc(Boolean bl) throws Exception {
        try {
            this.acc = bl;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("WRONG ACCELERATOR NODE");
            throw numberFormatException;
        }
    }

    public void setAccNumber(String string) throws Exception {
        try {
            Integer.parseInt(string);
            this.acc_number = string;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("WRONG NUMBER OF GPU'S");
            throw numberFormatException;
        }
    }

    public void setAccStartup(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.acc_startup = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("WRONG ACCELERATOR STARTUP VALUE");
            throw numberFormatException;
        }
    }

    public void setAccMemStartup(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.acc_mem_startup = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("WRONG ACCELERATOR MEMORY STARTUP VALUE");
            throw numberFormatException;
        }
    }

    public void setAccBandwidth(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.acc_bandwidth = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("WRONG ACCELERATOR BANDWIDTH VALUE");
            throw numberFormatException;
        }
    }

    public void setAccBuses(String string) throws Exception {
        try {
            Integer.parseInt(string);
            this.acc_buses = string;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("WRONG ACCELERATOR BUSES VALUE");
            throw numberFormatException;
        }
    }

    public void setAccRatio(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.acc_ratio = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("WRONG ACCELERATOR SPEED RATIO");
            throw numberFormatException;
        }
    }
}

