/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.EnvironmentData;
import data.Node;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tools.Tools;

public class NodeData {
    private int nNodes = 0;
    public Node[] node;
    private boolean nodesCreated = false;
    private int lastNodeIdAssigned = 0;

    public boolean loadSingleNodeData(String string, boolean bl, int n) throws Exception {
        int n2;
        String[] stringArray;
        block11: {
            Pattern pattern = Pattern.compile("\"node information\" \\{(.*)\\};;$");
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) {
                Tools.showErrorDialog("Wrong node information record");
                return false;
            }
            String string2 = matcher.group(1);
            stringArray = string2.split(",");
            if (stringArray.length != 11 && stringArray.length != 14 && stringArray.length != 13) {
                Tools.showErrorDialog("Wrong number of fields of node information record (line " + n + ").\nTry to update the CFG file");
                return false;
            }
            if (stringArray.length == 11 || stringArray.length == 14) {
                try {
                    n2 = Integer.parseInt(Tools.blanks(stringArray[1]));
                    if (n2 != this.lastNodeIdAssigned) {
                        Tools.showErrorDialog("Wrong node identifier in node information record. Expected: '" + this.lastNodeIdAssigned + "' Read: '" + n2 + "' (line " + n + ")");
                        return false;
                    }
                    break block11;
                }
                catch (NumberFormatException numberFormatException) {
                    Tools.showErrorDialog("Wrong node identifier in node information record (line " + n + ")");
                    return false;
                }
            }
            n2 = this.lastNodeIdAssigned;
        }
        if (n2 >= this.node.length) {
            Tools.showErrorDialog("More nodes defined than actual machines nodes (line " + n + ")");
            return false;
        }
        if (stringArray.length == 13) {
            this.node[n2].setMachine_id(Tools.blanks(stringArray[0]));
            this.node[n2].setNode_id(String.valueOf(n2));
            this.node[n2].setArchitecture(Tools.blanks(stringArray[1]));
            this.node[n2].setProcessors(Tools.blanks(stringArray[2]));
            this.node[n2].setCPURatio(Tools.blanks(stringArray[3]));
            this.node[n2].setIntraNodeStartup(Tools.blanks(stringArray[4]));
            this.node[n2].setIntraNodeBandwidth(Tools.blanks(stringArray[5]));
            this.node[n2].setIntraNodeBuses(Tools.blanks(stringArray[6]));
            this.node[n2].setIntraNodeInLinks(Tools.blanks(stringArray[7]));
            this.node[n2].setIntraNodeOutLinks(Tools.blanks(stringArray[8]));
            this.node[n2].setInterNodeStartup(Tools.blanks(stringArray[9]));
            this.node[n2].setInterNodeInLinks(Tools.blanks(stringArray[10]));
            this.node[n2].setInterNodeOutLinks(Tools.blanks(stringArray[11]));
            this.node[n2].setWANStartup(Tools.blanks(stringArray[12]));
        } else if (stringArray.length == 14) {
            this.node[n2].setMachine_id(Tools.blanks(stringArray[0]));
            this.node[n2].setNode_id(Tools.blanks(stringArray[1]));
            this.node[n2].setArchitecture(Tools.blanks(stringArray[2]));
            this.node[n2].setProcessors(Tools.blanks(stringArray[3]));
            this.node[n2].setCPURatio(Tools.blanks(stringArray[4]));
            this.node[n2].setIntraNodeStartup(Tools.blanks(stringArray[5]));
            this.node[n2].setIntraNodeBandwidth(Tools.blanks(stringArray[6]));
            this.node[n2].setIntraNodeBuses(Tools.blanks(stringArray[7]));
            this.node[n2].setIntraNodeInLinks(Tools.blanks(stringArray[8]));
            this.node[n2].setIntraNodeOutLinks(Tools.blanks(stringArray[9]));
            this.node[n2].setInterNodeStartup(Tools.blanks(stringArray[10]));
            this.node[n2].setInterNodeInLinks(Tools.blanks(stringArray[11]));
            this.node[n2].setInterNodeOutLinks(Tools.blanks(stringArray[12]));
            this.node[n2].setWANStartup(Tools.blanks(stringArray[13]));
        } else {
            this.node[n2].setMachine_id(Tools.blanks(stringArray[0]));
            this.node[n2].setNode_id(Tools.blanks(stringArray[1]));
            this.node[n2].setArchitecture(Tools.blanks(stringArray[2]));
            this.node[n2].setProcessors(Tools.blanks(stringArray[3]));
            this.node[n2].setInterNodeInLinks(Tools.blanks(stringArray[4]));
            this.node[n2].setInterNodeOutLinks(Tools.blanks(stringArray[5]));
            this.node[n2].setIntraNodeStartup(Tools.blanks(stringArray[6]));
            this.node[n2].setInterNodeStartup(Tools.blanks(stringArray[7]));
            this.node[n2].setCPURatio(Tools.blanks(stringArray[8]));
            this.node[n2].setIntraNodeBandwidth(Tools.blanks(stringArray[9]));
            this.node[n2].setWANStartup(Tools.blanks(stringArray[10]));
            this.node[n2].setIntraNodeBuses(Tools.blanks(stringArray[3]));
            this.node[n2].setIntraNodeInLinks("1");
            this.node[n2].setIntraNodeOutLinks("0");
            this.node[n2].setAcc(false);
        }
        ++this.lastNodeIdAssigned;
        return true;
    }

    public boolean loadMultiNodeData(String string, int n) throws Exception {
        Pattern pattern = Pattern.compile("\"multi node information\" \\{(.*)\\};;$");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            Tools.showErrorDialog("Wrong multi node information record");
            return false;
        }
        String string2 = matcher.group(1);
        String[] stringArray = string2.split(",");
        if (stringArray.length == 14) {
            int n2;
            try {
                n2 = Integer.parseInt(Tools.blanks(stringArray[1]));
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorDialog("Incorrect number of nodes in multi node definition record");
                return false;
            }
            if (this.lastNodeIdAssigned + n2 > this.node.length) {
                Tools.showErrorDialog("Wrong number of nodes defined");
                return false;
            }
            for (int i = 0; i < n2; ++i) {
                this.node[this.lastNodeIdAssigned].setMachine_id(Tools.blanks(stringArray[0]));
                this.node[this.lastNodeIdAssigned].setNode_id(String.valueOf(this.lastNodeIdAssigned));
                this.node[this.lastNodeIdAssigned].setArchitecture(Tools.blanks(stringArray[2]));
                this.node[this.lastNodeIdAssigned].setProcessors(Tools.blanks(stringArray[3]));
                this.node[this.lastNodeIdAssigned].setCPURatio(Tools.blanks(stringArray[4]));
                this.node[this.lastNodeIdAssigned].setIntraNodeStartup(Tools.blanks(stringArray[5]));
                this.node[this.lastNodeIdAssigned].setIntraNodeBandwidth(Tools.blanks(stringArray[6]));
                this.node[this.lastNodeIdAssigned].setIntraNodeBuses(Tools.blanks(stringArray[7]));
                this.node[this.lastNodeIdAssigned].setIntraNodeInLinks(Tools.blanks(stringArray[8]));
                this.node[this.lastNodeIdAssigned].setIntraNodeOutLinks(Tools.blanks(stringArray[9]));
                this.node[this.lastNodeIdAssigned].setInterNodeStartup(Tools.blanks(stringArray[10]));
                this.node[this.lastNodeIdAssigned].setInterNodeInLinks(Tools.blanks(stringArray[11]));
                this.node[this.lastNodeIdAssigned].setInterNodeOutLinks(Tools.blanks(stringArray[12]));
                this.node[this.lastNodeIdAssigned].setWANStartup(Tools.blanks(stringArray[13]));
                this.node[this.lastNodeIdAssigned].setAcc(false);
                ++this.lastNodeIdAssigned;
            }
        } else {
            Tools.showErrorDialog("Wrong multi node information record");
            return false;
        }
        return true;
    }

    public boolean loadAccNodeData(String string, boolean bl, int n) throws Exception {
        Pattern pattern = Pattern.compile("\"accelerator node information\" \\{(.*)\\};;$");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            Tools.showErrorDialog("Wrong accelerator node information record");
            return false;
        }
        String string2 = matcher.group(1);
        String[] stringArray = string2.split(",");
        if (stringArray.length != 7) {
            Tools.showErrorDialog("Wrong number of fields of accelerator node information record (line " + n + ").\nTry to update the CFG file");
            return false;
        }
        try {
            int n2 = Integer.parseInt(Tools.blanks(stringArray[0]));
            if (n2 >= this.node.length) {
                Tools.showErrorDialog("The accelerator node does not exist");
                return false;
            }
            this.node[n2].setAcc(true);
            this.node[n2].setAccNumber(Tools.blanks(stringArray[1]));
            this.node[n2].setAccStartup(Tools.blanks(stringArray[2]));
            this.node[n2].setAccMemStartup(Tools.blanks(stringArray[3]));
            this.node[n2].setAccBandwidth(Tools.blanks(stringArray[4]));
            this.node[n2].setAccBuses(Tools.blanks(stringArray[5]));
            this.node[n2].setAccRatio(Tools.blanks(stringArray[6]));
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorDialog("Wrong accelerator node information record (line " + n + ")");
            return false;
        }
        return true;
    }

    public void saveData(RandomAccessFile randomAccessFile) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < this.node.length) {
            if (this.node[n].equals(this.node[n2])) {
                ++n3;
                ++n;
                continue;
            }
            if (n3 == 1) {
                this.node[n2].saveData(randomAccessFile);
            } else {
                randomAccessFile.writeBytes("\"multi node information\" {");
                randomAccessFile.writeBytes(this.node[n2].getMachine_id() + ", ");
                randomAccessFile.writeBytes(String.valueOf(n3) + ", ");
                randomAccessFile.writeBytes(this.node[n2].getArchitecture(true) + ", ");
                randomAccessFile.writeBytes(this.node[n2].getProcessors() + ", ");
                randomAccessFile.writeBytes(this.node[n2].getCPURatio() + ", ");
                randomAccessFile.writeBytes(this.node[n2].getIntraNodeStartup() + ", ");
                randomAccessFile.writeBytes(this.node[n2].getIntraNodeBandwidth() + ", ");
                randomAccessFile.writeBytes(this.node[n2].getIntraNodeBuses() + ", ");
                randomAccessFile.writeBytes(this.node[n2].getIntraNodeInLinks() + ", ");
                randomAccessFile.writeBytes(this.node[n2].getIntraNodeOutLinks() + ", ");
                randomAccessFile.writeBytes(this.node[n2].getInterNodeStartup() + ", ");
                randomAccessFile.writeBytes(this.node[n2].getInterNodeInLinks() + ", ");
                randomAccessFile.writeBytes(this.node[n2].getInterNodeOutLinks() + ", ");
                randomAccessFile.writeBytes(this.node[n2].getWANStartup() + "};;\n");
            }
            n2 = n;
            n3 = 0;
        }
        if (n3 == 1) {
            this.node[n2].saveData(randomAccessFile);
        } else {
            randomAccessFile.writeBytes("\"multi node information\" {");
            randomAccessFile.writeBytes(this.node[n2].getMachine_id() + ", ");
            randomAccessFile.writeBytes(String.valueOf(n3) + ", ");
            randomAccessFile.writeBytes(this.node[n2].getArchitecture(true) + ", ");
            randomAccessFile.writeBytes(this.node[n2].getProcessors() + ", ");
            randomAccessFile.writeBytes(this.node[n2].getCPURatio() + ", ");
            randomAccessFile.writeBytes(this.node[n2].getIntraNodeStartup() + ", ");
            randomAccessFile.writeBytes(this.node[n2].getIntraNodeBandwidth() + ", ");
            randomAccessFile.writeBytes(this.node[n2].getIntraNodeBuses() + ", ");
            randomAccessFile.writeBytes(this.node[n2].getIntraNodeInLinks() + ", ");
            randomAccessFile.writeBytes(this.node[n2].getIntraNodeOutLinks() + ", ");
            randomAccessFile.writeBytes(this.node[n2].getInterNodeStartup() + ", ");
            randomAccessFile.writeBytes(this.node[n2].getInterNodeInLinks() + ", ");
            randomAccessFile.writeBytes(this.node[n2].getInterNodeOutLinks() + ", ");
            randomAccessFile.writeBytes(this.node[n2].getWANStartup() + "};;\n");
        }
        randomAccessFile.writeBytes("\n");
        for (n = 0; n < this.node.length; ++n) {
            if (!this.node[n].getAcc().booleanValue()) continue;
            this.node[n].saveAccData(randomAccessFile);
        }
    }

    public int getNumberOfNodes() {
        return this.nNodes;
    }

    public int[] getCpusPerNode() {
        int[] nArray = new int[this.nNodes];
        for (int i = 0; i < this.nNodes; ++i) {
            nArray[i] = Integer.parseInt(this.node[i].getProcessors());
        }
        return nArray;
    }

    public void setNumberOfNodes(int n) {
        this.nNodes = n;
    }

    public boolean defaultValues() {
        for (int i = 0; i < this.nNodes; ++i) {
            if (this.node[i].defaultValues()) continue;
            return false;
        }
        this.lastNodeIdAssigned = 0;
        return true;
    }

    public void verifyArchitecture(String string, String string2, EnvironmentData environmentData, int n) throws Exception {
        for (int i = this.nNodes - 1; i >= 0; --i) {
            if (!this.node[i].getMachine_id().equalsIgnoreCase(string)) continue;
            this.node[i].setMachine_id(string2);
        }
    }

    public void createNodes(EnvironmentData environmentData) throws Exception {
        if (!this.nodesCreated) {
            this.node = new Node[this.nNodes];
            int n = this.nNodes - 1;
            for (int i = environmentData.getNumberOfMachines() - 1; i >= 0; --i) {
                for (int j = Integer.parseInt(environmentData.machine[i].getNodes()) - 1; j >= 0; --j) {
                    this.node[n] = new Node(String.valueOf(n), environmentData.machine[i].getId());
                    --n;
                }
            }
            this.nodesCreated = true;
        }
    }

    public void eraseNodeInfo() {
        for (int i = this.nNodes - 1; i >= 0; --i) {
            this.node[i].initialValues();
        }
    }

    public void destroyNodes() {
        for (int i = this.nNodes - 1; i >= 0; --i) {
            this.node[i] = null;
        }
        this.nNodes = 0;
        this.node = null;
        this.nodesCreated = false;
        this.lastNodeIdAssigned = 0;
        System.gc();
    }

    public void changeAtNodes(EnvironmentData environmentData) throws Exception {
        int n;
        int n2;
        int n3 = this.nNodes - 1;
        Node[] nodeArray = new Node[this.nNodes];
        for (n2 = environmentData.getNumberOfMachines() - 1; n2 >= 0; --n2) {
            for (n = Integer.parseInt(environmentData.machine[n2].getNodes()) - 1; n >= 0; --n) {
                nodeArray[n3] = new Node(Integer.toString(n3), environmentData.machine[n2].getId());
                --n3;
            }
        }
        n2 = 0;
        if (this.nNodes >= this.node.length) {
            for (n = 0; n < this.nNodes; ++n) {
                if (n2 < this.node.length && nodeArray[n].getMachine_id().equalsIgnoreCase(this.node[n2].getMachine_id())) {
                    nodeArray[n].setArchitecture(this.node[n2].getArchitecture(false));
                    nodeArray[n].setProcessors(this.node[n2].getProcessors());
                    nodeArray[n].setCPURatio(this.node[n2].getCPURatio());
                    nodeArray[n].setIntraNodeStartup(this.node[n2].getIntraNodeStartup());
                    nodeArray[n].setIntraNodeBandwidth(this.node[n2].getIntraNodeBandwidth());
                    nodeArray[n].setIntraNodeInLinks(this.node[n2].getIntraNodeInLinks());
                    nodeArray[n].setIntraNodeOutLinks(this.node[n2].getIntraNodeOutLinks());
                    nodeArray[n].setInterNodeStartup(this.node[n2].getInterNodeStartup());
                    nodeArray[n].setInterNodeInLinks(this.node[n2].getInterNodeInLinks());
                    nodeArray[n].setInterNodeOutLinks(this.node[n2].getInterNodeOutLinks());
                    nodeArray[n].setWANStartup(this.node[n2].getWANStartup());
                    nodeArray[n].setAcc(this.node[n2].getAcc());
                    nodeArray[n].setAccNumber(this.node[n2].getAccNumber());
                    nodeArray[n].setAccStartup(this.node[n2].getAccStartup());
                    nodeArray[n].setAccMemStartup(this.node[n2].getAccMemStartup());
                    nodeArray[n].setAccBandwidth(this.node[n2].getAccBandwidth());
                    nodeArray[n].setAccBuses(this.node[n2].getAccBuses());
                    nodeArray[n].setAccRatio(this.node[n2].getAccRatio());
                    ++n2;
                    continue;
                }
                for (int i = environmentData.getNumberOfMachines() - 1; i >= 0; --i) {
                }
            }
        } else {
            for (n = 0; n < this.nNodes; ++n) {
                if (!this.node[n].getMachine_id().equalsIgnoreCase(nodeArray[n2].getMachine_id())) continue;
                nodeArray[n2].setArchitecture(this.node[n].getArchitecture(false));
                nodeArray[n2].setProcessors(this.node[n].getProcessors());
                nodeArray[n2].setCPURatio(this.node[n].getCPURatio());
                nodeArray[n2].setIntraNodeStartup(this.node[n].getIntraNodeStartup());
                nodeArray[n2].setIntraNodeBandwidth(this.node[n].getIntraNodeBandwidth());
                nodeArray[n2].setIntraNodeInLinks(this.node[n].getIntraNodeInLinks());
                nodeArray[n2].setIntraNodeOutLinks(this.node[n].getIntraNodeOutLinks());
                nodeArray[n2].setInterNodeStartup(this.node[n].getInterNodeStartup());
                nodeArray[n2].setInterNodeInLinks(this.node[n].getInterNodeInLinks());
                nodeArray[n2].setInterNodeOutLinks(this.node[n].getInterNodeOutLinks());
                nodeArray[n2].setWANStartup(this.node[n].getWANStartup());
                nodeArray[n2].setAcc(this.node[n].getAcc());
                nodeArray[n2].setAccNumber(this.node[n].getAccNumber());
                nodeArray[n2].setAccStartup(this.node[n].getAccStartup());
                nodeArray[n2].setAccMemStartup(this.node[n].getAccMemStartup());
                nodeArray[n2].setAccBandwidth(this.node[n].getAccBandwidth());
                nodeArray[n2].setAccBuses(this.node[n].getAccBuses());
                nodeArray[n2].setAccRatio(this.node[n].getAccRatio());
                ++n2;
            }
        }
        this.node = null;
        this.node = nodeArray;
        nodeArray = null;
        System.gc();
    }
}

