/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.io.File;
import java.io.RandomAccessFile;
import tools.Tools;

public class SimulatorCallData {
    private final String DIMEMAS_PATH = System.getProperty("DIMEMAS_HOME") + "/bin/Dimemas";
    private final int OUTPUT_NONE = 0;
    private final int OUTPUT_PARAVER = 1;
    private final int OUTPUT_VAMPIR = 2;
    private final String FIELD_LOAD = "[LOAD TRACE] = ";
    private final String FIELD_BREAK = "[BREAK TIME] = ";
    private final String FIELD_SYNC = "[IGNORE SYNC] = ";
    private final String FIELD_SIZE = "[MESSAGE SIZE] = ";
    private final String FIELD_OUTPUT = "[OUTPUT TRACE] = ";
    private final String FIELD_NAME = "[OUTPUT NAME] = ";
    private final String FIELD_TYPE = "[OUTPUT TYPE] = ";
    private final String FIELD_START = "[OUTPUT START] = ";
    private final String FIELD_STOP = "[OUTPUT STOP] = ";
    public final boolean DEFAULT_LOAD_TRACE = false;
    public final String DEFAULT_SIM_TIME = "0.0";
    public final int DEFAULT_OUTPUT = 0;
    public final String DEFAULT_FILENAME = "";
    public final boolean DEFAULT_TYPE_ASCII = true;
    public final String DEFAULT_TRACE_START = "0.0";
    public final String DEFAULT_TRACE_STOP = "0.0";
    public final boolean DEFAULT_IGNORE_SEND = false;
    public final String DEFAULT_SIZE = "0";
    private boolean load;
    private String simTime;
    private int out;
    private String filename;
    private boolean typeAscii;
    private String traceStart;
    private String traceStop;
    private boolean ignoreSend;
    private String size;

    private void initialValues() {
        this.load = false;
        this.simTime = "0.0";
        this.out = 0;
        this.filename = "";
        this.typeAscii = true;
        this.traceStart = "0.0";
        this.traceStop = "0.0";
        this.ignoreSend = false;
        this.size = "0";
    }

    private boolean trueOrFalse(String string) {
        return string.equalsIgnoreCase("true");
    }

    public void loadFromDisk(File file) {
        this.initialValues();
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            while (randomAccessFile.getFilePointer() != randomAccessFile.length()) {
                String string;
                String string2 = randomAccessFile.readLine();
                if (string2.startsWith("[LOAD TRACE] = ")) {
                    string = Tools.blanks(string2.substring(string2.indexOf("=") + 1));
                    this.setLoadInMemory(this.trueOrFalse(string));
                    continue;
                }
                if (string2.startsWith("[BREAK TIME] = ")) {
                    string = Tools.blanks(string2.substring(string2.indexOf("=") + 1));
                    this.setSimTime(string);
                    continue;
                }
                if (string2.startsWith("[IGNORE SYNC] = ")) {
                    string = Tools.blanks(string2.substring(string2.indexOf("=") + 1));
                    this.setIgnoreSend(this.trueOrFalse(string));
                    continue;
                }
                if (string2.startsWith("[MESSAGE SIZE] = ")) {
                    string = Tools.blanks(string2.substring(string2.indexOf("=") + 1));
                    this.setMinSize(string);
                    continue;
                }
                if (string2.startsWith("[OUTPUT TRACE] = ")) {
                    string = Tools.blanks(string2.substring(string2.indexOf("=") + 1));
                    this.setOutputFile(Integer.parseInt(string));
                    continue;
                }
                if (string2.startsWith("[OUTPUT NAME] = ")) {
                    string = Tools.blanks(string2.substring(string2.indexOf("=") + 1));
                    this.setFilename(string);
                    continue;
                }
                if (string2.startsWith("[OUTPUT TYPE] = ")) {
                    string = Tools.blanks(string2.substring(string2.indexOf("=") + 1));
                    this.setIsTypeAscii(this.trueOrFalse(string));
                    continue;
                }
                if (string2.startsWith("[OUTPUT START] = ")) {
                    string = Tools.blanks(string2.substring(string2.indexOf("=") + 1));
                    this.setStartTime(string);
                    continue;
                }
                if (!string2.startsWith("[OUTPUT STOP] = ")) continue;
                string = Tools.blanks(string2.substring(string2.indexOf("=") + 1));
                this.setStopTime(string);
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            Tools.showInformationMessage(exception.toString());
        }
    }

    public void saveToDisk(String string) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(new File(string), "rw");
            randomAccessFile.writeBytes("[LOAD TRACE] = " + this.getLoadInMemory() + "\n");
            randomAccessFile.writeBytes("[BREAK TIME] = " + this.getSimTime() + "\n");
            randomAccessFile.writeBytes("[IGNORE SYNC] = " + this.getIgnoreSend() + "\n");
            randomAccessFile.writeBytes("[MESSAGE SIZE] = " + this.getMinSize() + "\n");
            randomAccessFile.writeBytes("[OUTPUT TRACE] = " + this.getOutputFile() + "\n");
            randomAccessFile.writeBytes("[OUTPUT NAME] = " + this.getFilename() + "\n");
            randomAccessFile.writeBytes("[OUTPUT TYPE] = " + this.getIsTypeAscii() + "\n");
            randomAccessFile.writeBytes("[OUTPUT START] = " + this.getStartTime() + "\n");
            randomAccessFile.writeBytes("[OUTPUT STOP] = " + this.getStopTime() + "\n");
            randomAccessFile.close();
        }
        catch (Exception exception) {
            Tools.showInformationMessage(exception.toString());
        }
    }

    public SimulatorCallData() {
        this.initialValues();
    }

    public String generateCommand(String string) {
        String string2 = this.DIMEMAS_PATH + " ";
        if (!this.simTime.equalsIgnoreCase("0.0")) {
            string2 = string2 + "-T " + this.simTime + " ";
        }
        if (!this.load) {
            string2 = string2 + "-l ";
        }
        if (this.out == 1) {
            string2 = this.typeAscii ? string2 + "-pa " + this.filename + " " : string2 + "-pb " + this.filename + " ";
            if (!this.traceStart.equalsIgnoreCase("0.0")) {
                string2 = string2 + "-y " + this.traceStart + " ";
            }
            if (!this.traceStop.equalsIgnoreCase("0.0")) {
                string2 = string2 + "-z " + this.traceStop + " ";
            }
        } else if (this.out == 2) {
            string2 = this.typeAscii ? string2 + "-Va " + this.filename + " " : string2 + "-Vb " + this.filename + " ";
            if (!this.traceStart.equalsIgnoreCase("0.0")) {
                string2 = string2 + "-Vy " + this.traceStart + " ";
            }
            if (!this.traceStop.equalsIgnoreCase("0.0")) {
                string2 = string2 + "-Vz " + this.traceStop + " ";
            }
        }
        if (this.ignoreSend) {
            string2 = string2 + "-F ";
        }
        if (!this.size.equalsIgnoreCase("0")) {
            string2 = string2 + "-S " + this.size + " ";
        }
        string2 = string2 + string;
        return string2;
    }

    public boolean getLoadInMemory() {
        return this.load;
    }

    public String getSimTime() {
        return this.simTime;
    }

    public int getOutputFile() {
        return this.out;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean getIsTypeAscii() {
        return this.typeAscii;
    }

    public String getStartTime() {
        return this.traceStart;
    }

    public String getStopTime() {
        return this.traceStop;
    }

    public boolean getIgnoreSend() {
        return this.ignoreSend;
    }

    public String getMinSize() {
        return this.size;
    }

    public void setLoadInMemory(boolean bl) {
        this.load = bl;
    }

    public void setSimTime(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.simTime = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("SIMULATION BREAK TIME");
            throw numberFormatException;
        }
    }

    public void setOutputFile(int n) {
        this.out = n;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public void setIsTypeAscii(boolean bl) {
        this.typeAscii = bl;
    }

    public void setStartTime(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.traceStart = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("SIMULATION START TIME");
            throw numberFormatException;
        }
    }

    public void setStopTime(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.traceStop = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("SIMULATION STOP TIME");
            throw numberFormatException;
        }
    }

    public void setIgnoreSend(boolean bl) {
        this.ignoreSend = bl;
    }

    public void setMinSize(String string) throws Exception {
        try {
            Integer.parseInt(string);
            this.size = string;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("MINIMUM SIZE");
            throw numberFormatException;
        }
    }
}

