/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.io.IOException;
import java.io.RandomAccessFile;
import tools.Tools;

public class WideAreaNetworkData {
    public final String COMM_GROUP_LOG = "3";
    public final String COMM_GROUP_LIN = "2";
    public final String COMM_GROUP_CT = "1";
    public final String TRAFFIC_FUNCTION_EXP = "1";
    public final String TRAFFIC_FUNCTION_LOG = "2";
    public final String TRAFFIC_FUNCTION_LIN = "3";
    public final String TRAFFIC_FUNCTION_CT = "4";
    public final String DEFAULT_NAME = "";
    public final String DEFAULT_MACHINES = "1";
    public final String DEFAULT_DEDICATED = "0";
    public final String DEFAULT_TRAFFIC = "4";
    public final String DEFAULT_MAX = "0.0";
    public final String DEFAULT_BANDWIDTH = "0.0";
    public final String DEFAULT_COMMUNICATION = "1";
    private String name;
    private String machines;
    private String dedicated;
    private String traffic;
    private String max;
    private String bandwidth;
    private String communication;
    private int[][] mpi = new int[5][15];

    public boolean loadData(String string, int n) throws Exception {
        int n2 = "\"wide area network information\" {".length();
        int n3 = string.indexOf(",", n2);
        this.setName(Tools.blanks(string.substring(n2, n3)));
        n2 = n3 + 1;
        n3 = string.indexOf(",", n2);
        this.setMachines(Tools.blanks(string.substring(n2, n3)));
        n2 = n3 + 1;
        n3 = string.indexOf(",", n2);
        this.setDedicated(Tools.blanks(string.substring(n2, n3)));
        n2 = n3 + 1;
        n3 = string.indexOf(",", n2);
        this.setTraffic(Tools.blanks(string.substring(n2, n3)));
        n2 = n3 + 1;
        n3 = string.indexOf(",", n2);
        this.setMax(Tools.blanks(string.substring(n2, n3)));
        n2 = n3 + 1;
        n3 = string.indexOf(",", n2);
        this.setBandwidth(Tools.blanks(string.substring(n2, n3)));
        n2 = n3 + 1;
        n3 = string.indexOf("}", n2);
        this.setCommunication(Tools.blanks(string.substring(n2, n3)));
        return true;
    }

    public void saveData(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeBytes("\"wide area network information\" {");
        randomAccessFile.writeBytes(this.getName(true) + ", ");
        randomAccessFile.writeBytes(this.getMachines() + ", ");
        randomAccessFile.writeBytes(this.getDedicated() + ", ");
        randomAccessFile.writeBytes(this.getTraffic() + ", ");
        randomAccessFile.writeBytes(this.getMax() + ", ");
        randomAccessFile.writeBytes(this.getBandwidth() + ", ");
        randomAccessFile.writeBytes(this.getCommunication() + "};;\n");
    }

    public WideAreaNetworkData() {
        this.initialValues();
    }

    public void initialValues() {
        this.name = "";
        this.machines = "1";
        this.dedicated = "0";
        this.traffic = "4";
        this.max = "0.0";
        this.bandwidth = "0.0";
        this.communication = "1";
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 15; ++j) {
                this.mpi[i][j] = 0;
            }
        }
    }

    public int mpiGetValue(int n, int n2) {
        return this.mpi[n - 1][n2];
    }

    public void mpiSetValue(int n, int n2, int n3) {
        this.mpi[n - 1][n2] = n3;
    }

    public void mpiLoad(String string) {
        int n = 0;
        int n2 = string.indexOf(" ", n);
        int n3 = Integer.parseInt(Tools.blanks(string.substring(n, n2)));
        n = n2 + 1;
        n2 = string.indexOf(" ", n);
        this.mpi[0][n3] = Tools.mpiValue(0, Tools.blanks(string.substring(n, n2)));
        n = n2 + 1;
        n2 = string.indexOf(" ", n);
        this.mpi[1][n3] = Tools.mpiValue(1, Tools.blanks(string.substring(n, n2)));
        n = n2 + 1;
        n2 = string.indexOf(" ", n);
        this.mpi[2][n3] = Tools.mpiValue(2, Tools.blanks(string.substring(n, n2)));
        n = n2 + 1;
        n2 = string.length();
        this.mpi[3][n3] = Tools.mpiValue(3, Tools.blanks(string.substring(n, n2)));
    }

    public void mpiSave(RandomAccessFile randomAccessFile) throws IOException {
        for (int i = 0; i < 15; ++i) {
            if (this.mpi[0][i] == 0) {
                if (this.communication.equalsIgnoreCase("1")) {
                    this.mpi[0][i] = 4;
                } else if (this.communication.equalsIgnoreCase("2")) {
                    this.mpi[0][i] = 3;
                } else if (this.communication.equalsIgnoreCase("3")) {
                    this.mpi[0][i] = 2;
                }
                this.mpi[1][i] = Tools.mpiValue(1, "MAX");
                this.mpi[2][i] = Tools.mpiValue(1, "0");
                this.mpi[3][i] = Tools.mpiValue(1, "MAX");
                this.mpi[4][i] = 1;
            }
            randomAccessFile.writeBytes("External globalop: " + i + " " + Tools.mpiString(0, this.mpi[0][i]) + " " + Tools.mpiString(1, this.mpi[1][i]) + " " + Tools.mpiString(2, this.mpi[2][i]) + " " + Tools.mpiString(3, this.mpi[3][i]) + " \n");
        }
    }

    public boolean defaultValues() {
        return this.name.equalsIgnoreCase("") && this.machines.equalsIgnoreCase("1") && this.dedicated.equalsIgnoreCase("0") && this.traffic.equalsIgnoreCase("4") && this.max.equalsIgnoreCase("0.0") && this.bandwidth.equalsIgnoreCase("0.0") && this.communication.equalsIgnoreCase("1");
    }

    public String getName(boolean bl) {
        if (bl) {
            return "\"" + this.name + "\"";
        }
        return this.name;
    }

    public String getMachines() {
        return this.machines;
    }

    public String getDedicated() {
        return this.dedicated;
    }

    public String getTraffic() {
        return this.traffic;
    }

    public String getMax() {
        return this.max;
    }

    public String getBandwidth() {
        return this.bandwidth;
    }

    public String getCommunication() {
        return this.communication;
    }

    public void setName(String string) {
        this.name = string.startsWith("\"") && string.endsWith("\"") ? string.substring(1, string.length() - 1) : string;
    }

    public void setMachines(String string) throws Exception {
        try {
            Integer.parseInt(string);
            this.machines = string;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("NUMBER OF MACHINES");
            throw numberFormatException;
        }
    }

    public void setDedicated(String string) throws Exception {
        try {
            Integer.parseInt(string);
            this.dedicated = string;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("DEDICATED CONNECTIONS");
            throw numberFormatException;
        }
    }

    public void setTraffic(String string) {
        this.traffic = string;
    }

    public void setMax(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.max = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("MAX TRAFFIC VALUE");
            throw numberFormatException;
        }
    }

    public void setBandwidth(String string) throws Exception {
        try {
            Double.parseDouble(string);
            this.bandwidth = Tools.filterForDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("EXTERNAL NET BANDWIDTH");
            throw numberFormatException;
        }
    }

    public void setCommunication(String string) {
        this.communication = string;
    }
}

