/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import gui.GUIWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import tools.Tools;

public class BlockFactorsWindow
extends GUIWindow {
    public static final long serialVersionUID = 2L;
    JButton b_add = this.createButton("Add Module");
    JButton b_save = this.createButton("Save");
    JButton b_close = this.createButton("Close");
    JPanel buttonPanel;
    JScrollPane infoPanel;
    int DefinedModules = 0;
    ArrayList<JTextField> ModuleTypes = new ArrayList();
    ArrayList<JTextField> ModuleValues = new ArrayList();
    ArrayList<JTextField> ModuleRatios = new ArrayList();
    ArrayList<JButton> DeleteButtons = new ArrayList();

    private void createPanels() {
        this.buttonPanel = new JPanel(new FlowLayout());
        this.buttonPanel.add(this.b_add);
        this.buttonPanel.add(this.b_save);
        this.buttonPanel.add(this.b_close);
        JPanel jPanel = new JPanel(new GridLayout(0, 4));
        jPanel.add(new JLabel("Event Type"));
        jPanel.add(new JLabel("Event Value"));
        jPanel.add(new JLabel("Ratio"));
        jPanel.add(new JLabel(""));
        if (this.data.block.getNumberOfBlocks() != 0) {
            this.data.block.startIterator();
            while (this.data.block.hasNext()) {
                this.ModuleTypes.add(new JTextField(10));
                this.ModuleTypes.get(this.DefinedModules).setText(this.data.block.getType());
                jPanel.add(this.ModuleTypes.get(this.DefinedModules));
                this.ModuleValues.add(new JTextField(4));
                this.ModuleValues.get(this.DefinedModules).setText(this.data.block.getValue());
                jPanel.add(this.ModuleValues.get(this.DefinedModules));
                this.ModuleRatios.add(new JTextField(4));
                this.ModuleRatios.get(this.DefinedModules).setText(this.data.block.getRatio());
                jPanel.add(this.ModuleRatios.get(this.DefinedModules));
                this.DeleteButtons.add(this.createButton("Delete"));
                jPanel.add(this.DeleteButtons.get(this.DefinedModules));
                ++this.DefinedModules;
            }
        }
        if (this.DefinedModules == 0) {
            this.ModuleTypes.add(new JTextField(10));
            jPanel.add(this.ModuleTypes.get(this.DefinedModules));
            this.ModuleValues.add(new JTextField(4));
            jPanel.add(this.ModuleValues.get(this.DefinedModules));
            this.ModuleRatios.add(new JTextField(4));
            jPanel.add(this.ModuleRatios.get(this.DefinedModules));
            this.DeleteButtons.add(this.createButton("Delete"));
            jPanel.add(this.DeleteButtons.get(this.DefinedModules));
            ++this.DefinedModules;
        }
        this.infoPanel = new JScrollPane(jPanel, 20, 30);
    }

    public BlockFactorsWindow(Data data) {
        super(data);
        this.windowPanel.setLayout(new BorderLayout());
        this.setTitle("Modules ratio window");
        this.createPanels();
        this.windowPanel.add((Component)this.infoPanel, "Center");
        this.windowPanel.add((Component)this.buttonPanel, "South");
        this.setBounds(25, 150, this.getWidth() + 25, 500);
        this.pack();
        this.setVisible(true);
    }

    public void addNewBlock() {
        if (this.ModuleTypes.get(this.DefinedModules - 1).getText().equals("") && this.ModuleValues.get(this.DefinedModules - 1).getText().equals("") && this.ModuleRatios.get(this.DefinedModules - 1).getText().equals("")) {
            return;
        }
        JPanel jPanel = new JPanel(new GridLayout(0, 4));
        jPanel.add(new JLabel("Event Type"));
        jPanel.add(new JLabel("Event Value"));
        jPanel.add(new JLabel("Ratio"));
        jPanel.add(new JLabel(""));
        for (int i = 0; i < this.DefinedModules; ++i) {
            jPanel.add(this.ModuleTypes.get(i));
            jPanel.add(this.ModuleValues.get(i));
            jPanel.add(this.ModuleRatios.get(i));
            jPanel.add(this.DeleteButtons.get(i));
            this.DeleteButtons.get(i).setEnabled(true);
        }
        this.ModuleTypes.add(new JTextField(10));
        jPanel.add(this.ModuleTypes.get(this.DefinedModules));
        this.ModuleValues.add(new JTextField(4));
        jPanel.add(this.ModuleValues.get(this.DefinedModules));
        this.ModuleRatios.add(new JTextField(4));
        jPanel.add(this.ModuleRatios.get(this.DefinedModules));
        this.DeleteButtons.add(this.createButton("Delete"));
        this.DeleteButtons.get(this.DefinedModules).setEnabled(false);
        jPanel.add(this.DeleteButtons.get(this.DefinedModules));
        ++this.DefinedModules;
        this.infoPanel.setViewportView(jPanel);
        this.setBounds(25, 150, this.getWidth() + 25, 500);
        this.pack();
    }

    public void deleteBlock(int n) {
        this.ModuleTypes.remove(n);
        this.ModuleValues.remove(n);
        this.ModuleRatios.remove(n);
        this.DeleteButtons.remove(n);
        --this.DefinedModules;
        JPanel jPanel = new JPanel(new GridLayout(0, 4));
        jPanel.add(new JLabel("Event Type"));
        jPanel.add(new JLabel("Event Value"));
        jPanel.add(new JLabel("Ratio"));
        jPanel.add(new JLabel(""));
        for (int i = 0; i < this.DefinedModules; ++i) {
            jPanel.add(this.ModuleTypes.get(i));
            jPanel.add(this.ModuleValues.get(i));
            jPanel.add(this.ModuleRatios.get(i));
            jPanel.add(this.DeleteButtons.get(i));
        }
        if (this.DefinedModules == 0) {
            this.ModuleTypes.add(new JTextField(10));
            jPanel.add(this.ModuleTypes.get(this.DefinedModules));
            this.ModuleValues.add(new JTextField(4));
            jPanel.add(this.ModuleValues.get(this.DefinedModules));
            this.ModuleRatios.add(new JTextField(4));
            jPanel.add(this.ModuleRatios.get(this.DefinedModules));
            this.DeleteButtons.add(this.createButton("Delete"));
            jPanel.add(this.DeleteButtons.get(this.DefinedModules));
            ++this.DefinedModules;
        }
        this.infoPanel.setViewportView(jPanel);
        this.setBounds(25, 150, this.getWidth() + 25, 500);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.b_add) {
            this.addNewBlock();
        }
        if (actionEvent.getSource() == this.b_close) {
            this.dispose();
        } else if (actionEvent.getSource() == this.b_save) {
            try {
                this.data.block.destroyFactors();
                for (int i = 0; i < this.DefinedModules; ++i) {
                    if (this.ModuleTypes.get(i).getText().equals("") || this.ModuleValues.get(i).getText().equals("") || this.ModuleRatios.get(i).getText().equals("")) {
                        Tools.showErrorDialog("Incomplete module definition. It won't be saved");
                        continue;
                    }
                    this.data.block.addModuleRatio(this.ModuleTypes.get(i).getText(), this.ModuleValues.get(i).getText(), this.ModuleRatios.get(i).getText());
                }
                this.dispose();
            }
            catch (Exception exception) {}
        } else {
            for (int i = 0; i < this.DefinedModules; ++i) {
                if (actionEvent.getSource() != this.DeleteButtons.get(i)) continue;
                this.deleteBlock(i);
            }
        }
    }
}

