/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import gui.GUIWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tools.Tools;

public class CollectiveOpWindow
extends GUIWindow {
    public static final long serialVersionUID = 3L;
    public static final int MPI_REDUCE_POS = 11;
    private JTextField tf_number = this.createTextField(2);
    private boolean internalOperations;
    private JButton b_same = this.createButton("Do all the same");
    private JButton b_save = this.createButton("Save");
    private JButton b_close = this.createButton("Close");
    private JButton b_left = this.createButton("<<<");
    private JButton b_right = this.createButton(">>>");
    private JComboBox[] col1 = this.createComboBox(true, 15);
    private JComboBox[] col2 = this.createComboBox(false, 15);
    private JComboBox[] col3 = this.createComboBox(true, 15);
    private JComboBox[] col4 = this.createComboBox(false, 15);
    private JComboBox[] cb_equals1 = this.createComboBox(true, 1);
    private JComboBox[] cb_equals2 = this.createComboBox(false, 1);
    private JComboBox[] cb_equals3 = this.createComboBox(true, 1);
    private JComboBox[] cb_equals4 = this.createComboBox(false, 1);
    private JPanel colModelIn;
    private JPanel colSizeIn;
    private JPanel colModelOut;
    private JPanel colSizeOut;
    private JPanel colSync;
    private JPanel buttonPanelTop;
    private JPanel MPI_panel;
    private JPanel items;
    private JPanel buttonPanelBottom;

    private JComboBox[] createComboBox(boolean bl, int n) {
        JComboBox[] jComboBoxArray = new JComboBox[n];
        for (int i = 0; i < n; ++i) {
            jComboBoxArray[i] = new JComboBox();
            jComboBoxArray[i].addItem("Select");
            if (bl) {
                jComboBoxArray[i].addItem("0");
                jComboBoxArray[i].addItem("LOG");
                jComboBoxArray[i].addItem("LIN");
                jComboBoxArray[i].addItem("CT");
            } else {
                jComboBoxArray[i].addItem("MIN");
                jComboBoxArray[i].addItem("MAX");
                jComboBoxArray[i].addItem("MEAN");
                jComboBoxArray[i].addItem("2MAX");
                jComboBoxArray[i].addItem("S+R");
            }
            if (i != 11) continue;
            jComboBoxArray[i].setEnabled(false);
        }
        if (n == 1) {
            jComboBoxArray[0].addActionListener(this);
        }
        return jComboBoxArray;
    }

    private JCheckBox[] createCheckBox(boolean bl, int n) {
        JCheckBox[] jCheckBoxArray = new JCheckBox[n];
        for (int i = 0; i < n; ++i) {
            jCheckBoxArray[i] = new JCheckBox();
            jCheckBoxArray[i].setText("synchronize");
            if (bl) {
                jCheckBoxArray[i].setSelected(true);
            }
            if (i != 11) continue;
            jCheckBoxArray[i].setEnabled(false);
        }
        if (n == 1) {
            jCheckBoxArray[0].addActionListener(this);
            jCheckBoxArray[0].setText("ENABLE ALL");
        }
        return jCheckBoxArray;
    }

    private JTextField createTextField(int n) {
        JTextField jTextField = new JTextField(n);
        jTextField.setText("1");
        jTextField.setBorder(null);
        jTextField.setEditable(false);
        return jTextField;
    }

    private void createPanels() {
        this.buttonPanelTop = new JPanel(new FlowLayout());
        this.buttonPanelTop.add(new JLabel("Machine number"));
        this.buttonPanelTop.add(this.b_left);
        this.buttonPanelTop.add(this.tf_number);
        this.buttonPanelTop.add(this.b_right);
        this.buttonPanelBottom = new JPanel(new FlowLayout());
        this.buttonPanelBottom.add(this.b_save);
        if (this.internalOperations) {
            this.buttonPanelBottom.add(this.b_same);
        }
        this.buttonPanelBottom.add(this.b_close);
        this.MPI_panel = new JPanel(new GridLayout(1, 1));
        JPanel jPanel = new JPanel(new GridLayout(17, 1));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        this.colModelIn = new JPanel(new GridLayout(17, 1));
        this.colSizeIn = new JPanel(new GridLayout(17, 1));
        this.colModelOut = new JPanel(new GridLayout(17, 1));
        this.colSizeOut = new JPanel(new GridLayout(17, 1));
        this.colSync = new JPanel(new GridLayout(17, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "FAN IN"));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "FAN OUT"));
        this.colModelIn.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Model"));
        this.colSizeIn.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Size"));
        this.colModelOut.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Model"));
        this.colSizeOut.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Size"));
        this.colSync.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Enable"));
        int n = 0;
        while (true) {
            if (n >= 15) break;
            this.colModelIn.add(this.col1[n]);
            this.colSizeIn.add(this.col2[n]);
            this.colModelOut.add(this.col3[n]);
            this.colSizeOut.add(this.col4[n]);
            ++n;
        }
        this.colModelIn.add(new JLabel("-------", 0));
        this.colSizeIn.add(new JLabel("-------", 0));
        this.colModelOut.add(new JLabel("-------", 0));
        this.colSizeOut.add(new JLabel("-------", 0));
        this.colSync.add(new JLabel("----------", 0));
        this.colModelIn.add(this.cb_equals1[0]);
        this.colSizeIn.add(this.cb_equals2[0]);
        this.colModelOut.add(this.cb_equals3[0]);
        this.colSizeOut.add(this.cb_equals4[0]);
        jPanel2.add(this.colModelIn);
        jPanel2.add(this.colSizeIn);
        jPanel3.add(this.colModelOut);
        jPanel3.add(this.colSizeOut);
        jPanel.add(new JLabel("  MPI_Barrier", 2));
        jPanel.add(new JLabel("  MPI_Bcast", 2));
        jPanel.add(new JLabel("  MPI_Gather", 2));
        jPanel.add(new JLabel("  MPI_Gatherv", 2));
        jPanel.add(new JLabel("  MPI_Scatter", 2));
        jPanel.add(new JLabel("  MPI_Scatterv", 2));
        jPanel.add(new JLabel("  MPI_Allgather", 2));
        jPanel.add(new JLabel("  MPI_Allgatherv", 2));
        jPanel.add(new JLabel("  MPI_Alltoall", 2));
        jPanel.add(new JLabel("  MPI_Alltoallv", 2));
        jPanel.add(new JLabel("  MPI_Alltoallw", 2));
        JLabel jLabel = new JLabel("  MPI_Reduce", 2);
        jLabel.setEnabled(false);
        jPanel.add(jLabel);
        jPanel.add(new JLabel("  MPI_Allreduce", 2));
        jPanel.add(new JLabel("  MPI_Reduce_Scatter", 2));
        jPanel.add(new JLabel("  MPI_Scan", 2));
        jPanel.add(new JLabel("--------------------", 0));
        jPanel.add(new JLabel("Apply to all:", 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Name"));
        this.MPI_panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "COLLECTIVE OP."));
        this.MPI_panel.add(jPanel);
        this.items = new JPanel(new GridLayout(1, 2));
        this.items.add((Component)jPanel2, "Center");
        this.items.add((Component)jPanel3, "Center");
    }

    public CollectiveOpWindow(Data data, boolean bl) {
        super(data);
        this.setResizable(true);
        this.windowPanel.setLayout(new BorderLayout());
        this.internalOperations = bl;
        this.createPanels();
        if (this.internalOperations) {
            this.setTitle("Internal collective operations");
            this.windowPanel.add((Component)this.buttonPanelTop, "North");
            this.data.environment.mpiBackup();
        } else {
            this.setTitle("External collective operations");
        }
        this.windowPanel.add((Component)this.MPI_panel, "West");
        this.windowPanel.add((Component)this.items, "Center");
        this.windowPanel.add((Component)this.buttonPanelBottom, "South");
        this.fillInfo(0);
        this.setBounds(25, 150, this.getWidth() + 25, this.getHeight());
        this.pack();
        this.setVisible(true);
    }

    private String increase(String string) {
        int n = Integer.parseInt(string);
        if (n == this.data.environment.getNumberOfMachines()) {
            return "1";
        }
        return String.valueOf(++n);
    }

    private String decrease(String string) {
        int n = Integer.parseInt(string);
        if (n == 1) {
            return this.data.wan.getMachines();
        }
        return String.valueOf(--n);
    }

    private void fillInfo(int n) {
        this.cb_equals1[0].setSelectedIndex(0);
        this.cb_equals2[0].setSelectedIndex(0);
        this.cb_equals3[0].setSelectedIndex(0);
        this.cb_equals4[0].setSelectedIndex(0);
        for (int i = 14; i >= 0; --i) {
            if (this.internalOperations) {
                if (this.data.environment.machine[n].mpiConfigured()) {
                    this.col1[i].setSelectedIndex(this.data.environment.machine[n].mpiGetValue(1, i));
                    this.col2[i].setSelectedIndex(this.data.environment.machine[n].mpiGetValue(2, i));
                    this.col3[i].setSelectedIndex(this.data.environment.machine[n].mpiGetValue(3, i));
                    this.col4[i].setSelectedIndex(this.data.environment.machine[n].mpiGetValue(4, i));
                    continue;
                }
                String string = this.data.environment.machine[n].getCommunication();
                Objects.requireNonNull(this.data.environment);
                if (string.equalsIgnoreCase("1")) {
                    this.col1[i].setSelectedIndex(4);
                } else if (this.data.environment.machine[n].getCommunication().equalsIgnoreCase(this.data.environment.COMM_LIN)) {
                    this.col1[i].setSelectedIndex(3);
                } else if (this.data.environment.machine[n].getCommunication().equalsIgnoreCase(this.data.environment.COMM_LOG)) {
                    this.col1[i].setSelectedIndex(2);
                }
                this.col2[i].setSelectedIndex(Tools.mpiValue(1, "MAX"));
                this.col3[i].setSelectedIndex(Tools.mpiValue(2, "0"));
                this.col4[i].setSelectedIndex(Tools.mpiValue(3, "MAX"));
                continue;
            }
            if (this.data.wan.mpiGetValue(1, i) != 0) {
                this.col1[i].setSelectedIndex(this.data.wan.mpiGetValue(1, i));
                this.col2[i].setSelectedIndex(this.data.wan.mpiGetValue(2, i));
                this.col3[i].setSelectedIndex(this.data.wan.mpiGetValue(3, i));
                this.col4[i].setSelectedIndex(this.data.wan.mpiGetValue(4, i));
                continue;
            }
            String string = this.data.wan.getCommunication();
            Objects.requireNonNull(this.data.wan);
            if (string.equalsIgnoreCase("1")) {
                this.col1[i].setSelectedIndex(4);
            } else {
                String string2 = this.data.wan.getCommunication();
                Objects.requireNonNull(this.data.wan);
                if (string2.equalsIgnoreCase("2")) {
                    this.col1[i].setSelectedIndex(3);
                } else {
                    String string3 = this.data.wan.getCommunication();
                    Objects.requireNonNull(this.data.wan);
                    if (string3.equalsIgnoreCase("3")) {
                        this.col1[i].setSelectedIndex(2);
                    }
                }
            }
            this.col2[i].setSelectedIndex(Tools.mpiValue(1, "MAX"));
            this.col3[i].setSelectedIndex(Tools.mpiValue(2, "0"));
            this.col4[i].setSelectedIndex(Tools.mpiValue(3, "MAX"));
        }
    }

    private boolean storeInfo(int n) {
        for (int i = 14; i >= 0; --i) {
            if (this.col1[i].getSelectedIndex() == 0 || this.col2[i].getSelectedIndex() == 0 || this.col3[i].getSelectedIndex() == 0 || this.col4[i].getSelectedIndex() == 0) {
                Tools.showInformationMessage("One or more values are not set.");
                return false;
            }
            if (this.internalOperations) {
                if (n >= this.data.environment.getNumberOfMachines()) {
                    return false;
                }
                this.data.environment.machine[n].mpiSetValue(1, i, this.col1[i].getSelectedIndex());
                this.data.environment.machine[n].mpiSetValue(2, i, this.col2[i].getSelectedIndex());
                this.data.environment.machine[n].mpiSetValue(3, i, this.col3[i].getSelectedIndex());
                this.data.environment.machine[n].mpiSetValue(4, i, this.col4[i].getSelectedIndex());
                continue;
            }
            this.data.wan.mpiSetValue(1, i, this.col1[i].getSelectedIndex());
            this.data.wan.mpiSetValue(2, i, this.col2[i].getSelectedIndex());
            this.data.wan.mpiSetValue(3, i, this.col3[i].getSelectedIndex());
            this.data.wan.mpiSetValue(4, i, this.col4[i].getSelectedIndex());
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block17: {
            block19: {
                block18: {
                    block16: {
                        if (actionEvent.getSource() != this.b_left) break block16;
                        if (!this.storeInfo(Integer.parseInt(this.tf_number.getText()) - 1)) break block17;
                        this.tf_number.setText(this.decrease(this.tf_number.getText()));
                        this.fillInfo(Integer.parseInt(this.tf_number.getText()) - 1);
                        break block17;
                    }
                    if (actionEvent.getSource() != this.b_right) break block18;
                    if (!this.storeInfo(Integer.parseInt(this.tf_number.getText()) - 1)) break block17;
                    this.tf_number.setText(this.increase(this.tf_number.getText()));
                    this.fillInfo(Integer.parseInt(this.tf_number.getText()) - 1);
                    break block17;
                }
                if (actionEvent.getSource() != this.b_save) break block19;
                if (!this.storeInfo(Integer.parseInt(this.tf_number.getText()) - 1)) break block17;
                this.dispose();
                break block17;
            }
            if (actionEvent.getSource() == this.b_same) {
                for (int i = this.data.environment.getNumberOfMachines() - 1; i >= 0 && this.storeInfo(i); --i) {
                }
            } else if (actionEvent.getSource() == this.b_close) {
                this.data.environment.mpiRestore();
                this.dispose();
            } else if (actionEvent.getSource() == this.cb_equals1[0]) {
                for (int i = 14; i >= 0; --i) {
                    this.col1[i].setSelectedIndex(this.cb_equals1[0].getSelectedIndex());
                }
            } else if (actionEvent.getSource() == this.cb_equals2[0]) {
                for (int i = 14; i >= 0; --i) {
                    this.col2[i].setSelectedIndex(this.cb_equals2[0].getSelectedIndex());
                }
            } else if (actionEvent.getSource() == this.cb_equals3[0]) {
                for (int i = 14; i >= 0; --i) {
                    this.col3[i].setSelectedIndex(this.cb_equals3[0].getSelectedIndex());
                }
            } else if (actionEvent.getSource() == this.cb_equals4[0]) {
                for (int i = 14; i >= 0; --i) {
                    this.col4[i].setSelectedIndex(this.cb_equals4[0].getSelectedIndex());
                }
            }
        }
    }
}

