/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import gui.CollectiveOpWindow;
import gui.FlightTimeWindow;
import gui.GUIWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.RandomAccessFile;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import tools.Tools;

public class CommunicationWindow
extends GUIWindow {
    public static final long serialVersionUID = 4L;
    private JTextField tf_file;
    private JButton b_close = this.createButton("Close");
    private JButton b_save = this.createButton("Save to disk");
    private JButton b_int = this.createButton("Setup");
    private JButton b_ext = this.createButton("Setup");
    private JButton b_ft = this.createButton("Setup");

    public CommunicationWindow(Data data, JTextField jTextField) {
        super(data);
        this.setTitle("Communication setup window");
        this.tf_file = jTextField;
        this.drawLine(new Component[]{this.b_ext, new JLabel("External collective operations")});
        this.drawLine(new Component[]{this.b_int, new JLabel("Internal collective operations")});
        this.drawLine(new Component[]{this.b_ft, new JLabel("Flight time information")});
        this.drawButtons(new Component[]{this.b_save, this.b_close}, 5, 5);
        this.setBounds(500, 150, this.getWidth() + 35, this.getHeight());
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.b_close) {
            if (this.tf_file.getText().equalsIgnoreCase("")) {
                Tools.showInformationMessage("If you do not save this information to file,\n communication data will be lost.");
            }
            this.dispose();
        } else if (actionEvent.getSource() == this.b_save) {
            File file = null;
            Tools.fc.addChoosableFileFilter(new Tools.CFGfilter());
            int n = Tools.fc.showSaveDialog(null);
            if (n == 0) {
                file = Tools.fc.getSelectedFile().getAbsolutePath().endsWith(".cfg") ? new File(Tools.fc.getSelectedFile().getAbsolutePath()) : new File(Tools.fc.getSelectedFile().getAbsolutePath() + ".cfg");
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    if (randomAccessFile.length() != 0L) {
                        randomAccessFile.setLength(0L);
                    }
                    randomAccessFile.writeBytes("Policy: FIFO\n");
                    this.data.environment.ftSave(randomAccessFile);
                    for (int i = 0; i < this.data.environment.getNumberOfMachines(); ++i) {
                        this.data.environment.machine[i].mpiSave(randomAccessFile);
                    }
                    this.data.wan.mpiSave(randomAccessFile);
                    randomAccessFile.close();
                    this.data.config.setCommunication(file.getAbsolutePath());
                    this.tf_file.setText(file.getAbsolutePath());
                }
                catch (Throwable throwable) {
                    Tools.showInformationMessage(throwable.toString());
                }
            }
            Tools.fc.resetChoosableFileFilters();
            this.dispose();
        } else if (actionEvent.getSource() == this.b_int) {
            if (this.b_close.isEnabled() && this.b_save.isEnabled()) {
                this.b_close.setEnabled(false);
                this.b_save.setEnabled(false);
            }
            this.b_int.setEnabled(false);
            new CollectiveOpWindow(this.data, true).addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    if (CommunicationWindow.this.b_ext.isEnabled() && CommunicationWindow.this.b_ft.isEnabled()) {
                        CommunicationWindow.this.b_close.setEnabled(true);
                        CommunicationWindow.this.b_save.setEnabled(true);
                    }
                    CommunicationWindow.this.b_int.setEnabled(true);
                }
            });
        } else if (actionEvent.getSource() == this.b_ext) {
            if (this.b_close.isEnabled() && this.b_save.isEnabled()) {
                this.b_close.setEnabled(false);
                this.b_save.setEnabled(false);
            }
            this.b_ext.setEnabled(false);
            new CollectiveOpWindow(this.data, false).addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    if (CommunicationWindow.this.b_int.isEnabled() && CommunicationWindow.this.b_ft.isEnabled()) {
                        CommunicationWindow.this.b_close.setEnabled(true);
                        CommunicationWindow.this.b_save.setEnabled(true);
                    }
                    CommunicationWindow.this.b_ext.setEnabled(true);
                }
            });
        } else if (actionEvent.getSource() == this.b_ft) {
            if (this.data.environment.getNumberOfMachines() == 1) {
                Tools.showInformationMessage("Two or more machines are needed to configure these properties.");
            } else {
                if (this.b_close.isEnabled() && this.b_save.isEnabled()) {
                    this.b_close.setEnabled(false);
                    this.b_save.setEnabled(false);
                }
                this.b_ft.setEnabled(false);
                new FlightTimeWindow(this.data).addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        if (CommunicationWindow.this.b_int.isEnabled() && CommunicationWindow.this.b_ext.isEnabled()) {
                            CommunicationWindow.this.b_close.setEnabled(true);
                            CommunicationWindow.this.b_save.setEnabled(true);
                        }
                        CommunicationWindow.this.b_ft.setEnabled(true);
                    }
                });
            }
        }
    }
}

