/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import gui.CommunicationWindow;
import gui.GUIWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import tools.Tools;

public class ConfigurationFilesWindow
extends GUIWindow {
    public static final long serialVersionUID = 5L;
    private JComboBox cb_select = this.createComboBox();
    private JButton b_save = this.createButton("Save");
    private JButton b_close = this.createButton("Close");
    private JButton b_edit = this.createButton("Edit");
    private JTextField tf_scheduler = new JTextField(25);
    private JTextField tf_fileSys = new JTextField(25);
    private JTextField tf_comm = new JTextField(18);
    private JTextField tf_sensitivity = new JTextField(25);

    private JComboBox createComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Browse file");
        jComboBox.addItem("Scheduler");
        jComboBox.addItem("File system");
        jComboBox.addItem("Communication");
        jComboBox.addItem("Sensitivity");
        jComboBox.addActionListener(this);
        return jComboBox;
    }

    public ConfigurationFilesWindow(Data data) {
        super(data);
        this.setTitle("Configuration files information");
        this.tf_scheduler.setText(this.data.config.getScheduler(false));
        this.tf_fileSys.setText(this.data.config.getFileSys(false));
        this.tf_comm.setText(this.data.config.getCommunication(false));
        this.tf_sensitivity.setText(this.data.config.getSensitivity(false));
        this.drawLine(new Component[]{new JLabel("Scheduler"), this.tf_scheduler});
        this.drawLine(new Component[]{new JLabel("File system"), this.tf_fileSys});
        this.drawLine(new Component[]{new JLabel("Communication"), this.tf_comm, this.b_edit});
        this.drawLine(new Component[]{new JLabel("Sensitivity"), this.tf_sensitivity});
        this.drawButtons(new Component[]{this.b_save, this.cb_select, this.b_close}, 25, 5);
        this.setBounds(25, 150, this.getWidth() + 20, this.getHeight());
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.b_save) {
            this.data.config.setScheduler(this.tf_scheduler.getText());
            this.data.config.setFileSys(this.tf_fileSys.getText());
            this.data.config.setCommunication(this.tf_comm.getText());
            this.data.config.setSensitivity(this.tf_sensitivity.getText());
            this.dispose();
        } else if (actionEvent.getSource() == this.cb_select) {
            if (this.cb_select.getSelectedIndex() == 3 && this.data.environment.getNumberOfMachines() == 0) {
                Tools.showInformationMessage("You must define the number of machines before load this data file.");
            } else if (this.cb_select.getSelectedIndex() != 0) {
                Tools.fc.addChoosableFileFilter(new Tools.CFGfilter());
                int n = Tools.fc.showOpenDialog(null);
                if (n == 0) {
                    if (this.cb_select.getSelectedIndex() == 1) {
                        this.tf_scheduler.setText(Tools.fc.getSelectedFile().getAbsolutePath());
                    } else if (this.cb_select.getSelectedIndex() == 2) {
                        this.tf_fileSys.setText(Tools.fc.getSelectedFile().getAbsolutePath());
                    } else if (this.cb_select.getSelectedIndex() == 3) {
                        try {
                            if (this.data.loadCommunicationData(Tools.fc.getSelectedFile().getAbsolutePath())) {
                                this.tf_comm.setText(Tools.fc.getSelectedFile().getAbsolutePath());
                            }
                        }
                        catch (Exception exception) {
                            Tools.showInformationMessage(exception.toString());
                        }
                    } else if (this.cb_select.getSelectedIndex() == 4) {
                        this.tf_sensitivity.setText(Tools.fc.getSelectedFile().getAbsolutePath());
                    }
                }
                Tools.fc.resetChoosableFileFilters();
            }
            this.cb_select.setSelectedIndex(0);
        } else if (actionEvent.getSource() == this.b_close) {
            this.dispose();
        } else if (actionEvent.getSource() == this.b_edit) {
            if (this.data.environment.getNumberOfMachines() == 0) {
                Tools.showInformationMessage("You must specify the number of machines before configure these properties.");
            } else {
                this.b_edit.setEnabled(false);
                this.b_close.setEnabled(false);
                this.b_save.setEnabled(false);
                this.cb_select.setEnabled(false);
                new CommunicationWindow(this.data, this.tf_comm).addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        ConfigurationFilesWindow.this.b_edit.setEnabled(true);
                        ConfigurationFilesWindow.this.b_close.setEnabled(true);
                        ConfigurationFilesWindow.this.b_save.setEnabled(true);
                        ConfigurationFilesWindow.this.cb_select.setEnabled(true);
                    }
                });
            }
        }
    }
}

