/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import gui.BlockFactorsWindow;
import gui.ConfigurationFilesWindow;
import gui.DedicatedConnectionWindow;
import gui.EnvironmentWindow;
import gui.FileSystemWindow;
import gui.GUIWindow;
import gui.GridMappingWindow;
import gui.NodeWindow;
import gui.PredefinedMapsWindow;
import gui.WideAreaNetworkWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import tools.Tools;

public class ConfigurationOptionsWindow
extends GUIWindow {
    public static final long serialVersionUID = 6L;
    private final String CONFIG_BUTTON_TEXT = "Config!";
    private final String STATUS_OPEN = "Open";
    private final String STATUS_DEFAULT = "Default";
    private final String STATUS_MODIFIED = "Altered";
    private final int TXTFIELD_COLS = 10;
    private JButton b_wan = this.createButton("Config!");
    private JButton b_dedicated = this.createButton("Config!");
    private JButton b_environment = this.createButton("Config!");
    private JButton b_node = this.createButton("Config!");
    private JButton b_mapping = this.createButton("Config!");
    private JButton b_config_files = this.createButton("Config!");
    private JButton b_file_sys = this.createButton("Config!");
    private JButton b_block = this.createButton("Config!");
    private JButton b_close = this.createButton("Close window");
    private JLabel lbl_wan = this.createLabel();
    private JLabel lbl_dedicated = this.createLabel();
    private JLabel lbl_environment = this.createLabel();
    private JLabel lbl_node = this.createLabel();
    private JLabel lbl_mapping = this.createLabel();
    private JLabel lbl_config_files = this.createLabel();
    private JLabel lbl_file_sys = this.createLabel();
    private JLabel lbl_block = this.createLabel();

    public void refresh() {
        if (this.b_wan.isEnabled()) {
            if (!this.data.wan.defaultValues()) {
                this.lbl_wan.setText("Altered");
                this.lbl_wan.setForeground(Color.blue);
            } else {
                this.lbl_wan.setText("Default");
            }
        }
        if (this.b_dedicated.isEnabled()) {
            if (!this.data.dedicated.defaultValues()) {
                this.lbl_dedicated.setText("Altered");
                this.lbl_dedicated.setForeground(Color.blue);
            } else {
                this.lbl_dedicated.setText("Default");
            }
        }
        if (this.b_environment.isEnabled()) {
            if (!this.data.environment.defaultValues()) {
                this.lbl_environment.setText("Altered");
                this.lbl_environment.setForeground(Color.blue);
            } else {
                this.lbl_environment.setText("Default");
            }
        }
        if (this.b_node.isEnabled()) {
            if (!this.data.nodes_information.defaultValues()) {
                this.lbl_node.setText("Altered");
                this.lbl_node.setForeground(Color.blue);
            } else {
                this.lbl_node.setText("Default");
            }
        }
        if (this.b_mapping.isEnabled()) {
            if (!this.data.map.defaultValues()) {
                this.lbl_mapping.setText("Altered");
                this.lbl_mapping.setForeground(Color.blue);
            } else {
                this.lbl_mapping.setText("Default");
            }
        }
        if (this.b_config_files.isEnabled()) {
            if (!this.data.config.defaultValues()) {
                this.lbl_config_files.setText("Altered");
                this.lbl_config_files.setForeground(Color.blue);
            } else {
                this.lbl_config_files.setText("Default");
            }
        }
        if (this.b_file_sys.isEnabled()) {
            if (!this.data.fileSys.defaultValues()) {
                this.lbl_file_sys.setText("Altered");
                this.lbl_file_sys.setForeground(Color.blue);
            } else {
                this.lbl_file_sys.setText("Default");
            }
        }
        if (this.b_block.isEnabled()) {
            if (!this.data.block.defaultValues()) {
                this.lbl_block.setText("Altered");
                this.lbl_block.setForeground(Color.blue);
            } else {
                this.lbl_block.setText("Default");
            }
        }
    }

    private JLabel createLabel() {
        JLabel jLabel = new JLabel("Default", 2);
        jLabel.setBorder(null);
        return jLabel;
    }

    public ConfigurationOptionsWindow(Data data) {
        super(data);
        this.setTitle("Configuration window");
        this.refresh();
        this.drawLine(new Component[]{this.b_wan, new JLabel("WAN information"), this.lbl_wan});
        this.drawLine(new Component[]{this.b_dedicated, new JLabel("Dedicated connections"), this.lbl_dedicated});
        this.drawLine(new Component[]{this.b_environment, new JLabel("Environment information"), this.lbl_environment});
        this.drawLine(new Component[]{this.b_node, new JLabel("Node information"), this.lbl_node});
        this.drawLine(new Component[]{this.b_mapping, new JLabel("Mapping information"), this.lbl_mapping});
        this.drawLine(new Component[]{this.b_config_files, new JLabel("Config files"), this.lbl_config_files});
        this.drawLine(new Component[]{this.b_file_sys, new JLabel("File system parameters"), this.lbl_file_sys});
        this.drawLine(new Component[]{this.b_block, new JLabel("Block factors"), this.lbl_block});
        this.drawButtons(new Component[]{this.b_close}, 5, 5);
        this.setBounds(500, 150, this.getWidth() + 35, this.getHeight());
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.b_wan) {
            new WideAreaNetworkWindow(this.data).addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    ConfigurationOptionsWindow.this.b_wan.setEnabled(false);
                    ConfigurationOptionsWindow.this.lbl_wan.setText("Open");
                    ConfigurationOptionsWindow.this.lbl_wan.setForeground(Color.red);
                }

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    ConfigurationOptionsWindow.this.b_wan.setEnabled(true);
                    ConfigurationOptionsWindow.this.lbl_wan.setForeground(Color.black);
                    if (ConfigurationOptionsWindow.this.data.wan.defaultValues()) {
                        ConfigurationOptionsWindow.this.lbl_wan.setText("Default");
                    } else {
                        ConfigurationOptionsWindow.this.lbl_wan.setText("Altered");
                        ConfigurationOptionsWindow.this.lbl_wan.setForeground(Color.blue);
                    }
                }
            });
        } else if (actionEvent.getSource() == this.b_dedicated) {
            if (this.data.wan.getDedicated().equalsIgnoreCase("0")) {
                Tools.showInformationMessage("You must specify the number of dedicated connections before configure them.");
            } else {
                new DedicatedConnectionWindow(this.data).addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent windowEvent) {
                        ConfigurationOptionsWindow.this.b_dedicated.setEnabled(false);
                        ConfigurationOptionsWindow.this.lbl_dedicated.setText("Open");
                        ConfigurationOptionsWindow.this.lbl_dedicated.setForeground(Color.red);
                    }

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        ConfigurationOptionsWindow.this.b_dedicated.setEnabled(true);
                        ConfigurationOptionsWindow.this.lbl_dedicated.setForeground(Color.black);
                        if (ConfigurationOptionsWindow.this.data.dedicated.defaultValues()) {
                            ConfigurationOptionsWindow.this.lbl_dedicated.setText("Default");
                        } else {
                            ConfigurationOptionsWindow.this.lbl_dedicated.setText("Altered");
                            ConfigurationOptionsWindow.this.lbl_dedicated.setForeground(Color.blue);
                        }
                    }
                });
            }
        } else if (actionEvent.getSource() == this.b_environment) {
            if (this.data.environment.getNumberOfMachines() == 0) {
                Tools.showInformationMessage("No machines defined. Using a single machine environment with default values.\nTo tune the number of machines use the 'WAN information' dialog.");
                this.data.wan.initialValues();
                this.data.environment.setNumberOfMachines(1);
                try {
                    this.data.environment.changeAtMachines();
                }
                catch (Exception exception) {
                    Tools.showErrorMessage("Error creating default machine");
                    return;
                }
            }
            new EnvironmentWindow(this.data).addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    ConfigurationOptionsWindow.this.b_environment.setEnabled(false);
                    ConfigurationOptionsWindow.this.lbl_environment.setText("Open");
                    ConfigurationOptionsWindow.this.lbl_environment.setForeground(Color.red);
                }

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    ConfigurationOptionsWindow.this.b_environment.setEnabled(true);
                    ConfigurationOptionsWindow.this.lbl_environment.setForeground(Color.black);
                    if (ConfigurationOptionsWindow.this.data.environment.defaultValues()) {
                        ConfigurationOptionsWindow.this.lbl_environment.setText("Default");
                    } else {
                        ConfigurationOptionsWindow.this.lbl_environment.setText("Altered");
                        ConfigurationOptionsWindow.this.lbl_environment.setForeground(Color.blue);
                    }
                }
            });
        } else if (actionEvent.getSource() == this.b_node) {
            if (this.data.nodes_information.getNumberOfNodes() == 0) {
                Tools.showInformationMessage("You must specify the number of nodes before configure them.");
            } else {
                new NodeWindow(this.data, 0).addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent windowEvent) {
                        ConfigurationOptionsWindow.this.b_node.setEnabled(false);
                        ConfigurationOptionsWindow.this.lbl_node.setText("Open");
                        ConfigurationOptionsWindow.this.lbl_node.setForeground(Color.red);
                    }

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        ConfigurationOptionsWindow.this.b_node.setEnabled(true);
                        ConfigurationOptionsWindow.this.lbl_node.setForeground(Color.black);
                        if (ConfigurationOptionsWindow.this.data.nodes_information.defaultValues()) {
                            ConfigurationOptionsWindow.this.lbl_node.setText("Default");
                        } else {
                            ConfigurationOptionsWindow.this.lbl_node.setText("Altered");
                            ConfigurationOptionsWindow.this.lbl_node.setForeground(Color.blue);
                        }
                    }
                });
            }
        } else if (actionEvent.getSource() == this.b_mapping) {
            if (this.data.nodes_information.getNumberOfNodes() == 0) {
                Tools.showInformationMessage("You must specify the number of nodes before configure task-mapping.");
            } else if (this.data.map.getTasks() == -1 || this.data.map.getTasks() == 0 || this.data.map.getTasks() > 64 || this.data.nodes_information.getNumberOfNodes() > 64) {
                new PredefinedMapsWindow(this.data).addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent windowEvent) {
                        ConfigurationOptionsWindow.this.b_mapping.setEnabled(false);
                        ConfigurationOptionsWindow.this.lbl_mapping.setText("Open");
                        ConfigurationOptionsWindow.this.lbl_mapping.setForeground(Color.red);
                    }

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        ConfigurationOptionsWindow.this.b_mapping.setEnabled(true);
                        ConfigurationOptionsWindow.this.lbl_mapping.setForeground(Color.black);
                        if (ConfigurationOptionsWindow.this.data.map.defaultValues()) {
                            ConfigurationOptionsWindow.this.lbl_mapping.setText("Default");
                        } else {
                            ConfigurationOptionsWindow.this.lbl_mapping.setText("Altered");
                            ConfigurationOptionsWindow.this.lbl_mapping.setForeground(Color.blue);
                        }
                    }
                });
            } else {
                new GridMappingWindow(this.data).addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent windowEvent) {
                        ConfigurationOptionsWindow.this.b_mapping.setEnabled(false);
                        ConfigurationOptionsWindow.this.lbl_mapping.setText("Open");
                        ConfigurationOptionsWindow.this.lbl_mapping.setForeground(Color.red);
                    }

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        ConfigurationOptionsWindow.this.b_mapping.setEnabled(true);
                        ConfigurationOptionsWindow.this.lbl_mapping.setForeground(Color.black);
                        if (ConfigurationOptionsWindow.this.data.map.defaultValues()) {
                            ConfigurationOptionsWindow.this.lbl_mapping.setText("Default");
                        } else {
                            ConfigurationOptionsWindow.this.lbl_mapping.setText("Altered");
                            ConfigurationOptionsWindow.this.lbl_mapping.setForeground(Color.blue);
                        }
                    }
                });
            }
        } else if (actionEvent.getSource() == this.b_config_files) {
            new ConfigurationFilesWindow(this.data).addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    ConfigurationOptionsWindow.this.b_config_files.setEnabled(false);
                    ConfigurationOptionsWindow.this.lbl_config_files.setText("Open");
                    ConfigurationOptionsWindow.this.lbl_config_files.setForeground(Color.red);
                }

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    ConfigurationOptionsWindow.this.b_config_files.setEnabled(true);
                    ConfigurationOptionsWindow.this.lbl_config_files.setForeground(Color.black);
                    if (ConfigurationOptionsWindow.this.data.config.defaultValues()) {
                        ConfigurationOptionsWindow.this.lbl_config_files.setText("Default");
                    } else {
                        ConfigurationOptionsWindow.this.lbl_config_files.setText("Altered");
                        ConfigurationOptionsWindow.this.lbl_config_files.setForeground(Color.blue);
                    }
                }
            });
        } else if (actionEvent.getSource() == this.b_file_sys) {
            new FileSystemWindow(this.data).addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    ConfigurationOptionsWindow.this.b_file_sys.setEnabled(false);
                    ConfigurationOptionsWindow.this.lbl_file_sys.setText("Open");
                    ConfigurationOptionsWindow.this.lbl_file_sys.setForeground(Color.red);
                }

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    ConfigurationOptionsWindow.this.b_file_sys.setEnabled(true);
                    ConfigurationOptionsWindow.this.lbl_file_sys.setForeground(Color.black);
                    if (ConfigurationOptionsWindow.this.data.fileSys.defaultValues()) {
                        ConfigurationOptionsWindow.this.lbl_file_sys.setText("Default");
                    } else {
                        ConfigurationOptionsWindow.this.lbl_file_sys.setText("Altered");
                        ConfigurationOptionsWindow.this.lbl_file_sys.setForeground(Color.blue);
                    }
                }
            });
        } else if (actionEvent.getSource() == this.b_block) {
            new BlockFactorsWindow(this.data).addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    ConfigurationOptionsWindow.this.b_block.setEnabled(false);
                    ConfigurationOptionsWindow.this.lbl_block.setText("Open");
                    ConfigurationOptionsWindow.this.lbl_block.setForeground(Color.red);
                }

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    ConfigurationOptionsWindow.this.b_block.setEnabled(true);
                    ConfigurationOptionsWindow.this.lbl_block.setForeground(Color.black);
                    if (ConfigurationOptionsWindow.this.data.block.defaultValues()) {
                        ConfigurationOptionsWindow.this.lbl_block.setText("Default");
                    } else {
                        ConfigurationOptionsWindow.this.lbl_block.setText("Altered");
                        ConfigurationOptionsWindow.this.lbl_block.setForeground(Color.blue);
                    }
                }
            });
        } else if (actionEvent.getSource() == this.b_close) {
            if (!(this.b_wan.isEnabled() && this.b_dedicated.isEnabled() && this.b_environment.isEnabled() && this.b_node.isEnabled() && this.b_mapping.isEnabled() && this.b_config_files.isEnabled() && this.b_file_sys.isEnabled() && this.b_block.isEnabled())) {
                Tools.showInformationMessage("You should close all the windows opened to configure the Target Machine before exit.");
            } else {
                this.dispose();
            }
        }
    }
}

