/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import gui.GUIWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tools.Tools;

public class DedicatedConnectionWindow
extends GUIWindow {
    public static final long serialVersionUID = 7L;
    private JButton b_left = this.createButton("<<<");
    private JButton b_right = this.createButton(">>>");
    private JButton b_save = this.createButton("Save");
    private JButton b_close = this.createButton("Close");
    private JButton b_same = this.createButton("Do all the same");
    private JComboBox cb_firstCond = this.createComboBox('c');
    private JComboBox cb_secondCond = this.createComboBox('c');
    private JComboBox cb_operation = this.createComboBox('o');
    private JComboBox cb_source = this.createComboBox('m');
    private JComboBox cb_target = this.createComboBox('m');
    private JTextField tf_number = this.createTextField(2, false, true);
    private JTextField tf_id = this.createTextField(20, true, false);
    private JTextField tf_source = this.createTextField(12, false, false);
    private JTextField tf_target = this.createTextField(12, false, false);
    private JTextField tf_bandwidth = this.createTextField(20, true, false);
    private JTextField tf_tags = this.createTextField(20, true, false);
    private JTextField tf_firstSize = this.createTextField(8, true, false);
    private JTextField tf_secondSize = this.createTextField(8, true, false);
    private JTextField tf_communicators = this.createTextField(20, true, false);
    private JTextField tf_startup = this.createTextField(20, true, false);
    private JTextField tf_flight = this.createTextField(20, true, false);

    private JComboBox createComboBox(char c) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        switch (c) {
            case 'c': {
                jComboBox.addItem("Select");
                jComboBox.addItem("<");
                jComboBox.addItem("=");
                jComboBox.addItem(">");
                break;
            }
            case 'o': {
                jComboBox.addItem("Operation");
                jComboBox.addItem("AND");
                jComboBox.addItem("OR");
                break;
            }
            case 'm': {
                jComboBox.addItem("Select");
                for (int i = 0; i < this.data.environment.getNumberOfMachines(); ++i) {
                    jComboBox.addItem(this.data.environment.machine[i].getId());
                }
                jComboBox.addActionListener(this);
                break;
            }
        }
        return jComboBox;
    }

    private JTextField createTextField(int n, boolean bl, boolean bl2) {
        JTextField jTextField = new JTextField(n);
        if (bl2) {
            jTextField.setText("1");
            jTextField.setBorder(null);
        }
        jTextField.setEditable(bl);
        return jTextField;
    }

    protected void drawPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Message size required to use the connection"));
        jPanel.add(this.cb_firstCond);
        jPanel.add(this.tf_firstSize);
        jPanel.add(this.cb_operation);
        jPanel.add(this.cb_secondCond);
        jPanel.add(this.tf_secondSize);
        super.addComponent(jPanel);
    }

    private void fillInformation(int n) {
        int n2;
        this.tf_id.setText(this.data.dedicated.connection[n].getId());
        this.tf_bandwidth.setText(this.data.dedicated.connection[n].getBandwidth());
        this.tf_tags.setText(this.data.dedicated.connection[n].getTags(false));
        this.tf_communicators.setText(this.data.dedicated.connection[n].getCommunicators(false));
        this.tf_firstSize.setText(this.data.dedicated.connection[n].getFirstSize());
        this.tf_secondSize.setText(this.data.dedicated.connection[n].getSecondSize());
        this.tf_source.setText(this.data.dedicated.connection[n].getSource());
        this.tf_target.setText(this.data.dedicated.connection[n].getTarget());
        this.tf_startup.setText(this.data.dedicated.connection[n].getStartup());
        this.tf_flight.setText(this.data.dedicated.connection[n].getFlightTime());
        if (this.tf_source.getText().equalsIgnoreCase("")) {
            this.cb_source.setSelectedIndex(0);
        } else {
            for (n2 = 1; n2 < this.cb_source.getItemCount(); ++n2) {
                if (!this.tf_source.getText().equalsIgnoreCase((String)this.cb_source.getItemAt(n2))) continue;
                this.cb_source.setSelectedIndex(n2);
                break;
            }
        }
        if (this.tf_target.getText().equalsIgnoreCase("")) {
            this.cb_target.setSelectedIndex(0);
        } else {
            for (n2 = 1; n2 < this.cb_target.getItemCount(); ++n2) {
                if (!this.tf_target.getText().equalsIgnoreCase((String)this.cb_target.getItemAt(n2))) continue;
                this.cb_target.setSelectedIndex(n2);
                break;
            }
        }
        if (this.data.dedicated.connection[n].getFirstCond(false).equalsIgnoreCase("<")) {
            this.cb_firstCond.setSelectedIndex(1);
        } else if (this.data.dedicated.connection[n].getFirstCond(false).equalsIgnoreCase("=")) {
            this.cb_firstCond.setSelectedIndex(2);
        } else if (this.data.dedicated.connection[n].getFirstCond(false).equalsIgnoreCase(">")) {
            this.cb_firstCond.setSelectedIndex(3);
        } else {
            this.cb_firstCond.setSelectedIndex(0);
        }
        if (this.data.dedicated.connection[n].getOperation(false).equalsIgnoreCase("&")) {
            this.cb_operation.setSelectedIndex(1);
        } else if (this.data.dedicated.connection[n].getOperation(false).equalsIgnoreCase("|")) {
            this.cb_operation.setSelectedIndex(2);
        } else {
            this.cb_operation.setSelectedIndex(0);
        }
        if (this.data.dedicated.connection[n].getSecondCond(false).equalsIgnoreCase("<")) {
            this.cb_secondCond.setSelectedIndex(1);
        } else if (this.data.dedicated.connection[n].getSecondCond(false).equalsIgnoreCase("=")) {
            this.cb_secondCond.setSelectedIndex(2);
        } else if (this.data.dedicated.connection[n].getSecondCond(false).equalsIgnoreCase(">")) {
            this.cb_secondCond.setSelectedIndex(3);
        } else {
            this.cb_secondCond.setSelectedIndex(0);
        }
    }

    private boolean dataOK() {
        if (this.tf_id.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("DEDICATED CONNECTION ID");
            return false;
        }
        if (this.tf_source.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("SOURCE MACHINE");
            return false;
        }
        if (this.tf_target.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("TARGET MACHINE");
            return false;
        }
        if (this.tf_target.getText().equalsIgnoreCase(this.tf_source.getText())) {
            Tools.showInformationMessage("Source and target machine shouldn't have the same identificator.");
            return false;
        }
        if (this.tf_bandwidth.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("BANDWIDTH");
            return false;
        }
        if (this.tf_startup.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("STARTUP");
            return false;
        }
        if (this.tf_flight.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("FLIGHT TIME");
            return false;
        }
        return true;
    }

    private boolean storeInformation(int n, boolean bl) {
        if (!this.dataOK()) {
            return false;
        }
        try {
            if (!bl) {
                this.data.dedicated.connection[n].setId(this.tf_id.getText());
            }
            this.data.dedicated.connection[n].setSource(this.tf_source.getText());
            this.data.dedicated.connection[n].setTarget(this.tf_target.getText());
            this.data.dedicated.connection[n].setBandwidth(this.tf_bandwidth.getText());
            this.data.dedicated.connection[n].setTags(this.tf_tags.getText());
            this.data.dedicated.connection[n].setCommunicators(this.tf_communicators.getText());
            this.data.dedicated.connection[n].setFirstSize(this.tf_firstSize.getText());
            this.data.dedicated.connection[n].setSecondSize(this.tf_secondSize.getText());
            this.data.dedicated.connection[n].setStartup(this.tf_startup.getText());
            this.data.dedicated.connection[n].setFlightTime(this.tf_flight.getText());
        }
        catch (Exception exception) {
            return false;
        }
        if (this.cb_firstCond.getSelectedIndex() == 0) {
            this.data.dedicated.connection[n].setFirstCond(">");
        } else if (this.cb_firstCond.getSelectedIndex() == 1) {
            this.data.dedicated.connection[n].setFirstCond("<");
        } else if (this.cb_firstCond.getSelectedIndex() == 2) {
            this.data.dedicated.connection[n].setFirstCond("=");
        } else if (this.cb_firstCond.getSelectedIndex() == 3) {
            this.data.dedicated.connection[n].setFirstCond(">");
        }
        if (this.cb_operation.getSelectedIndex() == 0) {
            this.data.dedicated.connection[n].setOperation("|");
        }
        if (this.cb_operation.getSelectedIndex() == 1) {
            this.data.dedicated.connection[n].setOperation("&");
        } else if (this.cb_operation.getSelectedIndex() == 2) {
            this.data.dedicated.connection[n].setOperation("|");
        }
        if (this.cb_secondCond.getSelectedIndex() == 0) {
            this.data.dedicated.connection[n].setSecondCond(">");
        } else if (this.cb_secondCond.getSelectedIndex() == 1) {
            this.data.dedicated.connection[n].setSecondCond("<");
        } else if (this.cb_secondCond.getSelectedIndex() == 2) {
            this.data.dedicated.connection[n].setSecondCond("=");
        } else if (this.cb_secondCond.getSelectedIndex() == 3) {
            this.data.dedicated.connection[n].setSecondCond(">");
        }
        return true;
    }

    public DedicatedConnectionWindow(Data data) {
        super(data);
        this.setTitle("Dedicated connection information");
        this.drawLine(new Component[]{new JLabel("Dedicated connection number"), this.b_left, this.tf_number, this.b_right});
        this.drawLine(new Component[]{new JLabel("Connection id"), this.tf_id});
        this.drawLine(new Component[]{new JLabel("Source machine"), this.cb_source, this.tf_source});
        this.drawLine(new Component[]{new JLabel("Target machine"), this.cb_target, this.tf_target});
        this.drawLine(new Component[]{new JLabel("Connection bandwidth [MByte/s]"), this.tf_bandwidth});
        this.tf_tags.setToolTipText("Type TAGS between commas: \"T1,T2,...,Tn\"");
        this.drawLine(new Component[]{new JLabel("Tag list"), this.tf_tags});
        this.drawPanel();
        this.tf_communicators.setToolTipText("Type COMMUNICATORS between commas: \"C1,C2,...,Cn\"");
        this.drawLine(new Component[]{new JLabel("Communicators list"), this.tf_communicators});
        this.drawLine(new Component[]{new JLabel("Connection startup [s]"), this.tf_startup});
        this.drawLine(new Component[]{new JLabel("Flight time [s]"), this.tf_flight});
        this.drawButtons(new Component[]{this.b_save, this.b_same, this.b_close}, 25, 5);
        this.fillInformation(0);
        this.setBounds(25, 150, this.getWidth() + 10, this.getHeight());
        this.pack();
        this.setVisible(true);
    }

    private String increase(String string) {
        int n = Integer.parseInt(string);
        if (n == this.data.dedicated.getNumberOfConnections()) {
            return "1";
        }
        return String.valueOf(++n);
    }

    private String decrease(String string) {
        int n = Integer.parseInt(string);
        if (n == 1) {
            return this.data.wan.getDedicated();
        }
        return String.valueOf(--n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.b_left && this.storeInformation(Integer.parseInt(this.tf_number.getText()) - 1, false)) {
            this.tf_number.setText(this.decrease(this.tf_number.getText()));
            this.fillInformation(Integer.parseInt(this.tf_number.getText()) - 1);
        }
        if (actionEvent.getSource() == this.b_right) {
            if (this.storeInformation(Integer.parseInt(this.tf_number.getText()) - 1, false)) {
                this.tf_number.setText(this.increase(this.tf_number.getText()));
                this.fillInformation(Integer.parseInt(this.tf_number.getText()) - 1);
            }
        } else if (actionEvent.getSource() == this.b_save) {
            if (this.storeInformation(Integer.parseInt(this.tf_number.getText()) - 1, false)) {
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.b_close) {
            this.dispose();
        } else if (actionEvent.getSource() == this.b_same) {
            for (int i = this.data.dedicated.getNumberOfConnections() - 1; i >= 0 && this.storeInformation(i, true); --i) {
            }
        } else if (actionEvent.getSource() == this.cb_source) {
            if (this.cb_source.getSelectedIndex() != 0) {
                this.tf_source.setText((String)this.cb_source.getSelectedItem());
            } else {
                this.tf_source.setText("");
            }
        } else if (actionEvent.getSource() == this.cb_target) {
            if (this.cb_target.getSelectedIndex() != 0) {
                this.tf_target.setText((String)this.cb_target.getSelectedItem());
            } else {
                this.tf_target.setText("");
            }
        }
    }
}

