/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import data.EnvironmentData;
import gui.GUIWindow;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tools.Tools;

public class EnvironmentWindow
extends GUIWindow {
    public static final long serialVersionUID = 8L;
    private JRadioButton lin;
    private JRadioButton log;
    private JRadioButton ct;
    private ButtonGroup boxGroup = this.createGroup();
    private JButton b_left = this.createButton("<<<");
    private JButton b_right = this.createButton(">>>");
    private JButton b_save = this.createButton("Save");
    private JButton b_close = this.createButton("Close");
    private JButton b_same = this.createButton("Do all the same");
    private JTextField tf_architecture = new JTextField(10);
    private JTextField tf_number = this.createTextField(2);
    private JTextField tf_name = new JTextField(18);
    private JTextField tf_id = new JTextField(18);
    private JTextField tf_nodes = new JTextField(18);
    private JTextField tf_bandwidth = new JTextField(18);
    private JTextField tf_buses = new JTextField(18);

    private JTextField createTextField(int n) {
        JTextField jTextField = new JTextField(n);
        jTextField.setText("1");
        jTextField.setBorder(null);
        jTextField.setEditable(false);
        return jTextField;
    }

    private ButtonGroup createGroup() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.log = new JRadioButton("LOG");
        this.lin = new JRadioButton("LIN");
        this.ct = new JRadioButton("CT");
        buttonGroup.add(this.log);
        buttonGroup.add(this.lin);
        buttonGroup.add(this.ct);
        return buttonGroup;
    }

    private void fillInformation(int n) {
        switch (Integer.parseInt(this.data.environment.machine[n].getCommunication())) {
            case 1: {
                this.ct.setSelected(true);
                break;
            }
            case 2: {
                this.lin.setSelected(true);
                break;
            }
            case 3: {
                this.log.setSelected(true);
            }
        }
        this.tf_name.setText(this.data.environment.machine[n].getName(false));
        this.tf_id.setText(this.data.environment.machine[n].getId());
        this.tf_architecture.setText(this.data.environment.machine[n].getNodeArchitecture());
        this.tf_nodes.setText(this.data.environment.machine[n].getNodes());
        this.tf_bandwidth.setText(this.data.environment.machine[n].getBandwidth());
        this.tf_buses.setText(this.data.environment.machine[n].getBuses());
    }

    private boolean dataOK() {
        if (this.tf_id.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("MACHINE ID");
            return false;
        }
        if (this.tf_nodes.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("NUMBER OF NODES");
            return false;
        }
        if (this.tf_bandwidth.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("BANDWIDTH");
            return false;
        }
        if (this.tf_buses.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("NUMBER OF BUSES");
            return false;
        }
        return true;
    }

    private boolean storeInformation(int n, boolean bl) {
        if (!this.dataOK()) {
            return false;
        }
        try {
            this.data.environment.machine[n].setNodeArchitecture(this.tf_architecture.getText());
            this.data.environment.machine[n].setNodes(this.tf_nodes.getText());
            this.data.environment.machine[n].setBandwidth(this.tf_bandwidth.getText());
            this.data.environment.machine[n].setBuses(this.tf_buses.getText());
            String string = this.data.environment.machine[n].getId();
            if (bl) {
                this.data.nodes_information.verifyArchitecture(string, String.valueOf(n), this.data.environment, n);
            } else {
                this.data.environment.machine[n].setId(this.tf_id.getText());
                this.data.environment.machine[n].setName(this.tf_name.getText());
                this.data.nodes_information.verifyArchitecture(string, this.tf_id.getText(), this.data.environment, n);
            }
            if (this.ct.isSelected()) {
                EnvironmentData.Machine machine = this.data.environment.machine[n];
                Objects.requireNonNull(this.data.environment);
                machine.setCommunication("1");
            } else if (this.lin.isSelected()) {
                this.data.environment.machine[n].setCommunication(this.data.environment.COMM_LIN);
            } else if (this.log.isSelected()) {
                this.data.environment.machine[n].setCommunication(this.data.environment.COMM_LOG);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public EnvironmentWindow(Data data) {
        super(data);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 5, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Inter-node communications parameters"));
        this.setTitle("Environment information");
        this.fillInformation(0);
        this.drawLine(new Component[]{new JLabel("Machine number"), this.b_left, this.tf_number, this.b_right});
        this.drawLine(new Component[]{new JLabel("Machine name"), this.tf_name});
        jPanel.add(new JLabel("Number of nodes"));
        jPanel.add(this.tf_nodes);
        jPanel.add(new JLabel("Network bandwidth [MByte/s]"));
        jPanel.add(this.tf_bandwidth);
        jPanel.add(new JLabel("Number of buses"));
        jPanel.add(this.tf_buses);
        jPanel.add(new JLabel("Collective communications model"));
        jPanel2.add(this.log);
        jPanel2.add(this.lin);
        jPanel2.add(this.ct);
        jPanel.add(jPanel2);
        super.addComponent(jPanel);
        this.drawButtons(new Component[]{this.b_save, this.b_same, this.b_close}, 25, 5);
        this.setBounds(25, 150, this.getWidth() + 20, this.getHeight());
        this.pack();
        this.setVisible(true);
    }

    private String increase(String string) {
        int n = Integer.parseInt(string);
        if (n == this.data.environment.getNumberOfMachines()) {
            return "1";
        }
        return String.valueOf(++n);
    }

    private String decrease(String string) {
        int n = Integer.parseInt(string);
        if (n == 1) {
            return this.data.wan.getMachines();
        }
        return String.valueOf(--n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.b_left && this.storeInformation(Integer.parseInt(this.tf_number.getText()) - 1, false)) {
            this.tf_number.setText(this.decrease(this.tf_number.getText()));
            this.fillInformation(Integer.parseInt(this.tf_number.getText()) - 1);
        }
        if (actionEvent.getSource() == this.b_right) {
            if (this.storeInformation(Integer.parseInt(this.tf_number.getText()) - 1, false)) {
                this.tf_number.setText(this.increase(this.tf_number.getText()));
                this.fillInformation(Integer.parseInt(this.tf_number.getText()) - 1);
            }
        } else if (actionEvent.getSource() == this.b_save) {
            if (this.storeInformation(Integer.parseInt(this.tf_number.getText()) - 1, false)) {
                int n = 0;
                for (int i = this.data.environment.getNumberOfMachines() - 1; i >= 0; --i) {
                    n += Integer.parseInt(this.data.environment.machine[i].getNodes());
                }
                try {
                    this.data.nodes_information.setNumberOfNodes(n);
                    if (this.data.nodes_information.node == null) {
                        this.data.nodes_information.createNodes(this.data.environment);
                    } else {
                        this.data.nodes_information.changeAtNodes(this.data.environment);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Exception when changing number of nodes");
                }
                String string = this.data.map.changeAtNodes();
                if (string != null) {
                    Tools.showWarningMessage(string + "\nPlease check the \"Mapping information\" to verify your task mapping");
                }
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.b_close) {
            this.dispose();
        } else if (actionEvent.getSource() == this.b_same) {
            for (int i = this.data.environment.getNumberOfMachines() - 1; i >= 0 && this.storeInformation(i, true); --i) {
            }
        }
    }
}

