/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import gui.GUIWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FileSystemWindow
extends GUIWindow {
    public static final long serialVersionUID = 9L;
    private JButton b_save = this.createButton("Save");
    private JButton b_close = this.createButton("Close");
    private JTextField tf_diskLatency = new JTextField(15);
    private JTextField tf_diskBandwidth = new JTextField(15);
    private JTextField tf_blockSize = new JTextField(15);
    private JTextField tf_requests = new JTextField(15);
    private JTextField tf_hitRatio = new JTextField(15);

    public FileSystemWindow(Data data) {
        super(data);
        this.setTitle("File system information");
        this.tf_diskLatency.setText(this.data.fileSys.getLatency());
        this.tf_diskBandwidth.setText(this.data.fileSys.getBandwidth());
        this.tf_blockSize.setText(this.data.fileSys.getSize());
        this.tf_requests.setText(this.data.fileSys.getReq());
        this.tf_hitRatio.setText(this.data.fileSys.getHit());
        this.drawLine(new Component[]{new JLabel("Disk latency [s]"), this.tf_diskLatency});
        this.drawLine(new Component[]{new JLabel("Disk bandwidth [MByte/s]"), this.tf_diskBandwidth});
        this.drawLine(new Component[]{new JLabel("Block size [Bytes]"), this.tf_blockSize});
        this.drawLine(new Component[]{new JLabel("Concurrent requests"), this.tf_requests});
        this.drawLine(new Component[]{new JLabel("Hit ratio"), this.tf_hitRatio});
        this.drawButtons(new Component[]{this.b_save, this.b_close}, 60, 5);
        this.setBounds(25, 150, this.getWidth() + 25, this.getHeight());
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.b_save) {
            try {
                this.data.fileSys.setLatency(this.tf_diskLatency.getText());
                this.data.fileSys.setBandwidth(this.tf_diskBandwidth.getText());
                this.data.fileSys.setSize(this.tf_blockSize.getText());
                this.data.fileSys.setReq(this.tf_requests.getText());
                this.data.fileSys.setHit(this.tf_hitRatio.getText());
                this.dispose();
            }
            catch (Exception exception) {}
        } else if (actionEvent.getSource() == this.b_close) {
            this.dispose();
        }
    }
}

