/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import gui.GUIWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import tools.Tools;

public class FlightTimeWindow
extends GUIWindow {
    public static final long serialVersionUID = 10L;
    private JTextField[][] cells;
    private JScrollPane elements;
    private JPanel buttonPanel;
    private JButton b_close = this.createButton("Close");
    private JButton b_save = this.createButton("Save");
    private JButton b_sym = this.createButton("Symmetric");
    private JButton b_all = this.createButton("Do all the same");

    private void createPanels() {
        int n = this.data.environment.getNumberOfMachines();
        int n2 = 0;
        int n3 = 0;
        this.cells = new JTextField[n][n - 1];
        JPanel jPanel = new JPanel(new GridLayout(n + 1, n + 1));
        this.buttonPanel = new JPanel(new FlowLayout());
        this.buttonPanel.add(this.b_save);
        this.buttonPanel.add(this.b_sym);
        this.buttonPanel.add(this.b_all);
        this.buttonPanel.add(this.b_close);
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= n; ++j) {
                if (i == j) {
                    jPanel.add(new JLabel(""));
                    continue;
                }
                if (i == 0) {
                    jPanel.add(new JLabel("Source " + j, 0));
                    continue;
                }
                if (j == 0) {
                    jPanel.add(new JLabel("Target " + i, 0));
                    continue;
                }
                this.cells[n2][n3] = new JTextField(8);
                this.cells[n2][n3].setText("0.0");
                jPanel.add(this.cells[n2][n3]);
                if (++n3 != n - 1) continue;
                ++n2;
                n3 = 0;
            }
        }
        this.elements = new JScrollPane(jPanel, 20, 30);
    }

    private void fillInfo() {
        for (int i = 0; i < this.data.environment.getNumberOfMachines(); ++i) {
            for (int j = 0; j < this.data.environment.getNumberOfMachines() - 1; ++j) {
                this.cells[i][j].setText(this.data.environment.ftGetValue(i, j));
            }
        }
    }

    public FlightTimeWindow(Data data) {
        super(data);
        this.setTitle("Flight time information");
        this.setResizable(true);
        this.windowPanel.setLayout(new BorderLayout());
        this.createPanels();
        this.windowPanel.add((Component)this.elements, "Center");
        this.windowPanel.add((Component)this.buttonPanel, "South");
        this.fillInfo();
        this.setBounds(25, 150, this.getWidth() + 25, this.getHeight());
        this.pack();
        this.setVisible(true);
    }

    private boolean dataOK() {
        for (int i = 0; i < this.data.environment.getNumberOfMachines(); ++i) {
            for (int j = 0; j < this.data.environment.getNumberOfMachines() - 1; ++j) {
                try {
                    Double.parseDouble(this.cells[i][j].getText());
                    this.cells[i][j].setText(Tools.filterForDouble(this.cells[i][j].getText()));
                    this.data.environment.ftSetValue(i, j, Double.parseDouble(this.cells[i][j].getText()));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    Tools.showErrorMessage("FLIGHT TIME");
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block8: {
            block9: {
                block7: {
                    if (actionEvent.getSource() != this.b_close) break block7;
                    this.dispose();
                    break block8;
                }
                if (actionEvent.getSource() != this.b_save) break block9;
                if (!this.dataOK()) break block8;
                this.dispose();
                break block8;
            }
            if (actionEvent.getSource() == this.b_sym) {
                for (int i = 0; i < this.data.environment.getNumberOfMachines(); ++i) {
                    for (int j = i; j < this.data.environment.getNumberOfMachines() - 1; ++j) {
                        this.cells[j + 1][i].setText(this.cells[i][j].getText());
                    }
                }
            } else if (actionEvent.getSource() == this.b_all) {
                for (int i = 0; i < this.data.environment.getNumberOfMachines(); ++i) {
                    for (int j = i; j < this.data.environment.getNumberOfMachines() - 1; ++j) {
                        this.cells[i][j].setText(this.cells[0][0].getText());
                    }
                }
            }
        }
    }
}

