/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

abstract class GUIWindow
extends JFrame
implements ActionListener {
    protected Data data;
    protected Container windowPanel = this.getContentPane();
    protected GridBagLayout layout = new GridBagLayout();
    protected GridBagConstraints grid = new GridBagConstraints();

    protected JButton createButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected void addComponent(Component component) {
        this.grid.anchor = 10;
        this.grid.fill = 2;
        this.layout.setConstraints(component, this.grid);
        this.windowPanel.add(component);
    }

    protected void drawButtons(Component[] componentArray, int n, int n2) {
        JPanel jPanel = new JPanel(new FlowLayout(1, n, n2));
        for (int i = 0; i < componentArray.length; ++i) {
            jPanel.add(componentArray[i]);
        }
        this.addComponent(jPanel);
    }

    protected void drawLine(Component[] componentArray) {
        int n;
        for (n = 0; n < componentArray.length - 1; ++n) {
            this.grid.gridwidth = 1;
            this.addComponent(componentArray[n]);
        }
        this.grid.gridwidth = 0;
        this.addComponent(componentArray[n]);
    }

    public GUIWindow(Data data) {
        this.data = data;
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("resources/dimemas_icon.png")));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setBorder(BorderFactory.createRaisedBevelBorder());
        this.windowPanel.setLayout(this.layout);
        this.setResizable(true);
        this.grid.insets = new Insets(5, 5, 5, 5);
        this.grid.weighty = 0.5;
        this.grid.weightx = 0.5;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }
}

