/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import data.MappingData;
import gui.GUIWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import tools.Tools;

public class GridMappingWindow
extends GUIWindow {
    public static final long serialVersionUID = 10L;
    private JToggleButton[][] mapButtons;
    private int[] currentMap;
    private int currentMapInfo;
    private int nTasksPerNode;
    private JButton b_close;
    private JButton b_save;
    private ButtonGroup bg_predefinedMaps;
    private JLabel l_machine;
    private JLabel l_nodes;
    private JLabel l_tasks;
    private JPanel p_buttons;
    private JScrollPane p_gridButtons;
    private JPanel p_predefinedMaps;
    private JRadioButton rb_fillNodes;
    private JRadioButton rb_interleaved;
    private JRadioButton rb_irregularMap;
    private JRadioButton rb_nTasksPerNode;
    private JTextField tf_nTasksPerNode;

    public GridMappingWindow(Data data) {
        super(data);
        this.initComponents();
        this.generateGridButtons();
        this.currentMap = this.data.map.getMap();
        this.currentMapInfo = this.data.map.getMapInfo();
        this.nTasksPerNode = this.data.map.getNTasksPerNode();
        this.setState();
        this.pack();
        this.setVisible(true);
    }

    private void initComponents() {
        this.bg_predefinedMaps = new ButtonGroup();
        this.p_gridButtons = new JScrollPane();
        this.p_buttons = new JPanel();
        this.l_tasks = new JLabel();
        this.l_machine = new JLabel();
        this.l_nodes = new JLabel();
        this.p_predefinedMaps = new JPanel();
        this.rb_fillNodes = new JRadioButton();
        this.rb_nTasksPerNode = new JRadioButton();
        this.tf_nTasksPerNode = new JTextField();
        this.rb_interleaved = new JRadioButton();
        this.rb_irregularMap = new JRadioButton();
        this.b_save = new JButton();
        this.b_close = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Applications Tasks Map");
        this.setMaximumSize(new Dimension(674, 564));
        this.setMinimumSize(new Dimension(674, 564));
        this.setResizable(false);
        this.p_gridButtons.setMaximumSize(new Dimension(579, 400));
        this.p_gridButtons.setMinimumSize(new Dimension(579, 400));
        GroupLayout groupLayout = new GroupLayout(this.p_buttons);
        this.p_buttons.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 577, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 398, Short.MAX_VALUE));
        this.p_gridButtons.setViewportView(this.p_buttons);
        this.l_tasks.setText("Application Tasks");
        this.l_machine.setText("Machine");
        this.l_nodes.setText("Nodes");
        this.p_predefinedMaps.setBorder(BorderFactory.createTitledBorder("Predefined Maps"));
        this.bg_predefinedMaps.add(this.rb_fillNodes);
        this.rb_fillNodes.setText("Fill Nodes");
        this.rb_fillNodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GridMappingWindow.this.rb_fillNodesActionPerformed(actionEvent);
            }
        });
        this.bg_predefinedMaps.add(this.rb_nTasksPerNode);
        this.rb_nTasksPerNode.setFont(this.rb_nTasksPerNode.getFont());
        this.rb_nTasksPerNode.setText("'n' tasks per node");
        this.rb_nTasksPerNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GridMappingWindow.this.rb_nTasksPerNodeActionPerformed(actionEvent);
            }
        });
        this.tf_nTasksPerNode.setColumns(2);
        this.tf_nTasksPerNode.setFont(this.tf_nTasksPerNode.getFont());
        this.tf_nTasksPerNode.setText("1");
        this.tf_nTasksPerNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GridMappingWindow.this.tf_nTasksPerNodeActionPerformed(actionEvent);
            }
        });
        this.bg_predefinedMaps.add(this.rb_interleaved);
        this.rb_interleaved.setFont(this.rb_interleaved.getFont());
        this.rb_interleaved.setText("Interleaved");
        this.rb_interleaved.setToolTipText("One tasks is assigned to each node in a cyclic way");
        this.rb_interleaved.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GridMappingWindow.this.rb_interleavedActionPerformed(actionEvent);
            }
        });
        this.bg_predefinedMaps.add(this.rb_irregularMap);
        this.rb_irregularMap.setText("Irregular map");
        this.rb_irregularMap.setToolTipText("Map modified manually, not selectable");
        this.rb_irregularMap.setEnabled(false);
        GroupLayout groupLayout2 = new GroupLayout(this.p_predefinedMaps);
        this.p_predefinedMaps.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.rb_fillNodes).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rb_nTasksPerNode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tf_nTasksPerNode, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rb_interleaved).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rb_irregularMap).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rb_nTasksPerNode).addComponent(this.tf_nTasksPerNode, -2, -1, -2).addComponent(this.rb_interleaved).addComponent(this.rb_irregularMap)).addComponent(this.rb_fillNodes)).addContainerGap(-1, Short.MAX_VALUE)));
        this.b_save.setText("Save");
        this.b_save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GridMappingWindow.this.b_saveActionPerformed(actionEvent);
            }
        });
        this.b_close.setText("Close");
        this.b_close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GridMappingWindow.this.b_closeActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.l_machine).addComponent(this.l_nodes)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(groupLayout3.createSequentialGroup().addComponent(this.b_save, -2, 162, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.b_close, -2, 162, -2)).addComponent(this.p_predefinedMaps, -2, -1, -2).addComponent(this.l_tasks).addComponent(this.p_gridButtons, GroupLayout.Alignment.TRAILING, -1, -1, -2)).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.l_tasks).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(groupLayout3.createSequentialGroup().addComponent(this.l_machine).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.l_nodes)).addComponent(this.p_gridButtons, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.p_predefinedMaps, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.b_save).addComponent(this.b_close)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void generateGridButtons() {
        int n = this.data.map.getTasks();
        int n2 = this.data.nodes_information.getNumberOfNodes();
        this.p_buttons.setLayout(new GridLayout(n2 + 2, n + 2, 0, 0));
        this.mapButtons = new JToggleButton[n2][n];
        for (int i = 0; i < n2 + 2; ++i) {
            for (int j = 0; j < n + 2; ++j) {
                JLabel jLabel;
                if (i == 0 || i == n2 + 1) {
                    jLabel = j == 0 || j == n + 1 ? new JLabel("") : new JLabel(String.valueOf(j));
                    this.p_buttons.add(jLabel);
                    continue;
                }
                if (j == 0 || j == n + 1) {
                    jLabel = new JLabel(String.valueOf(i));
                    this.p_buttons.add(jLabel);
                    continue;
                }
                this.mapButtons[i - 1][j - 1] = new JToggleButton();
                this.mapButtons[i - 1][j - 1].setPreferredSize(new Dimension(20, 20));
                this.mapButtons[i - 1][j - 1].setMinimumSize(new Dimension(20, 20));
                this.mapButtons[i - 1][j - 1].setMaximumSize(new Dimension(20, 20));
                this.mapButtons[i - 1][j - 1].setBackground(Color.gray);
                this.mapButtons[i - 1][j - 1].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = GridMappingWindow.this.data.map.getTasks();
                        int n2 = GridMappingWindow.this.data.nodes_information.getNumberOfNodes();
                        for (int i = 0; i < n2; ++i) {
                            for (int j = 0; j < n; ++j) {
                                if (actionEvent.getSource() != GridMappingWindow.this.mapButtons[i][j]) continue;
                                GridMappingWindow.this.buttonPushed(i, j);
                            }
                        }
                    }
                });
                this.p_buttons.add(this.mapButtons[i - 1][j - 1]);
            }
        }
        this.p_gridButtons.setPreferredSize(new Dimension(577, 400));
        this.p_gridButtons.repaint();
    }

    private void rb_nTasksPerNodeActionPerformed(ActionEvent actionEvent) {
        MappingData.MapResult mapResult = new MappingData.MapResult(this.data.map);
        try {
            this.nTasksPerNode = Integer.parseInt(this.tf_nTasksPerNode.getText());
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("Wrong tasks per node value");
            return;
        }
        mapResult = this.data.map.mapNTasksPerNode(this.nTasksPerNode);
        if (mapResult.errorMessage != null) {
            Tools.showErrorMessage(mapResult.errorMessage);
        }
        this.currentMap = mapResult.generatedMap;
        this.currentMapInfo = 2;
        this.setState();
    }

    private void tf_nTasksPerNodeActionPerformed(ActionEvent actionEvent) {
        MappingData.MapResult mapResult = new MappingData.MapResult(this.data.map);
        try {
            this.nTasksPerNode = Integer.parseInt(this.tf_nTasksPerNode.getText());
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("Wrong tasks per node value");
            return;
        }
        mapResult = this.data.map.mapNTasksPerNode(this.nTasksPerNode);
        if (mapResult.errorMessage != null) {
            Tools.showErrorMessage(mapResult.errorMessage);
        }
        this.currentMap = mapResult.generatedMap;
        this.currentMapInfo = 2;
        this.setState();
    }

    private void rb_interleavedActionPerformed(ActionEvent actionEvent) {
        MappingData.MapResult mapResult = new MappingData.MapResult(this.data.map);
        mapResult = this.data.map.mapInterleaved();
        if (mapResult.errorMessage != null) {
            Tools.showErrorDialog(mapResult.errorMessage);
        }
        this.currentMap = mapResult.generatedMap;
        this.currentMapInfo = 3;
        this.setState();
    }

    private void b_closeActionPerformed(ActionEvent actionEvent) {
        this.closeEvent();
    }

    private void rb_fillNodesActionPerformed(ActionEvent actionEvent) {
        MappingData.MapResult mapResult = new MappingData.MapResult(this.data.map);
        mapResult = this.data.map.mapFillingNodes();
        if (mapResult.errorMessage != null) {
            Tools.showErrorMessage(mapResult.errorMessage);
        }
        this.currentMap = mapResult.generatedMap;
        this.currentMapInfo = 1;
        this.setState();
    }

    private void b_saveActionPerformed(ActionEvent actionEvent) {
        if (this.rb_nTasksPerNode.isSelected()) {
            try {
                this.nTasksPerNode = Integer.parseInt(this.tf_nTasksPerNode.getText());
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorMessage("Wrong tasks per node value");
                return;
            }
        }
        this.data.map.setMapInfo(this.currentMapInfo);
        this.data.map.setMap(this.currentMap);
        this.data.map.setNTasksPerNode(this.nTasksPerNode);
    }

    private void buttonPushed(int n, int n2) {
        int n3;
        MappingData.MapTest mapTest = new MappingData.MapTest(this.data.map);
        int n4 = this.data.nodes_information.getNumberOfNodes();
        int n5 = this.data.map.getTasks();
        for (n3 = 0; n3 < n4; ++n3) {
            if (n3 != n) {
                this.mapButtons[n3][n2].setSelected(false);
                continue;
            }
            this.mapButtons[n3][n2].setSelected(true);
        }
        for (n3 = 0; n3 < n5; ++n3) {
            for (int i = 0; i < n4; ++i) {
                if (!this.mapButtons[i][n3].isSelected()) continue;
                this.currentMap[n3] = i;
            }
        }
        mapTest = this.data.map.detectMap(this.currentMap);
        this.currentMapInfo = mapTest.mapInfo;
        this.nTasksPerNode = mapTest.nTasksPerNode;
        this.setState();
    }

    private void setState() {
        int n = this.data.map.getTasks();
        int n2 = this.data.nodes_information.getNumberOfNodes();
        switch (this.currentMapInfo) {
            case 0: {
                this.rb_irregularMap.setSelected(true);
                this.clearMap();
                for (int i = 0; i < n; ++i) {
                    this.mapButtons[this.currentMap[i]][i].setSelected(true);
                }
                break;
            }
            case 1: {
                this.rb_fillNodes.setSelected(true);
                this.clearMap();
                for (int i = 0; i < n; ++i) {
                    this.mapButtons[this.currentMap[i]][i].setSelected(true);
                }
                break;
            }
            case 2: {
                this.rb_nTasksPerNode.setSelected(true);
                this.tf_nTasksPerNode.setText(String.valueOf(this.nTasksPerNode));
                this.clearMap();
                for (int i = 0; i < n; ++i) {
                    this.mapButtons[this.currentMap[i]][i].setSelected(true);
                }
                break;
            }
            case 3: {
                this.rb_interleaved.setSelected(true);
                this.clearMap();
                for (int i = 0; i < n; ++i) {
                    this.mapButtons[this.currentMap[i]][i].setSelected(true);
                }
                break;
            }
        }
    }

    private void clearMap() {
        int n = this.data.map.getTasks();
        int n2 = this.data.nodes_information.getNumberOfNodes();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.mapButtons[i][j].setSelected(false);
            }
        }
    }

    private void closeEvent() {
        if (this.data.map.getMapInfo() == -1) {
            Tools.showWarningMessage("Please select a map before closing");
            this.setVisible(true);
        } else {
            this.dispose();
        }
    }
}

