/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import gui.GUIWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import tools.Tools;

public class InitialMachineWindow
extends GUIWindow {
    public static final long serialVersionUID = 11L;
    private JTextField tf_tracefile = new JTextField(33);
    private JTextField tf_tasks = new JTextField(17);
    private JButton b_save = this.createButton("Save");
    private JButton b_select = this.createButton("Select tracefile");
    private JButton b_close = this.createButton("Close");

    public InitialMachineWindow(Data data) {
        super(data);
        this.setTitle("Application information");
        this.tf_tracefile.setText(this.data.map.getTracefile(false));
        if (this.data.map.getTasks() == -1) {
            this.tf_tasks.setText("N/A");
        } else {
            this.tf_tasks.setText(String.valueOf(this.data.map.getTasks()));
        }
        this.drawLine(new Component[]{new JLabel("Input tracefile name"), this.tf_tracefile});
        this.tf_tracefile.setEditable(false);
        this.drawLine(new Component[]{new JLabel("Number of aplication tasks"), this.tf_tasks});
        this.tf_tasks.setEditable(false);
        this.drawButtons(new Component[]{this.b_save, this.b_select, this.b_close}, 20, 5);
        this.setBounds(25, 150, this.getWidth() + 20, this.getHeight());
        this.pack();
        this.setVisible(true);
    }

    private boolean dataOK() {
        if (this.tf_tracefile.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("TRACEFILE");
            return false;
        }
        if (this.tf_tasks.getText().equalsIgnoreCase("") || this.tf_tasks.getText().equalsIgnoreCase("0")) {
            Tools.showWarningMessage("NUMBER OF TASKS");
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.b_save) {
            if (this.dataOK()) {
                try {
                    for (int i = this.data.environment.getNumberOfMachines() - 1; i >= 0; --i) {
                        this.data.environment.machine[i].setArchitecture(this.data.instrumentedArchitecture);
                    }
                    this.dispose();
                }
                catch (Exception exception) {}
            }
        } else if (actionEvent.getSource() == this.b_select) {
            Tools.fc.setAcceptAllFileFilterUsed(false);
            Tools.fc.addChoosableFileFilter(new Tools.DIMfilter());
            int n = Tools.fc.showOpenDialog(null);
            if (n == 0) {
                this.tf_tracefile.setText(Tools.fc.getSelectedFile().getAbsolutePath());
                this.data.map.setTracefile(this.tf_tracefile.getText());
                if (this.data.map.getTasks() != -1) {
                    this.tf_tasks.setText(String.valueOf(this.data.map.getTasks()));
                } else {
                    this.tf_tasks.setText("N/A");
                }
            }
            Tools.fc.resetChoosableFileFilters();
        } else if (actionEvent.getSource() == this.b_close) {
            this.dispose();
        }
    }

    class progress
    extends Thread {
        int current;
        JProgressBar bar = new JProgressBar();
        JFrame frame = new JFrame("Work in progress");

        public progress(int n) {
            this.bar.setMinimum(0);
            this.bar.setMaximum(n);
            this.bar.setStringPainted(true);
            this.frame.setIconImage(Toolkit.getDefaultToolkit().createImage(this.getClass().getClassLoader().getResource("resources/dimemas_icon.png")));
            this.frame.getContentPane().setLayout(new BorderLayout());
            this.frame.getContentPane().add((Component)new JLabel("Please wait", 0), "Center");
            this.frame.getContentPane().add((Component)this.bar, "South");
            this.frame.setResizable(false);
            this.frame.setBounds(150, 200, this.frame.getWidth() + 50, this.frame.getHeight() + 20);
            this.frame.pack();
        }

        public void setCurrent(int n) {
            this.current = n;
        }

        @Override
        public void run() {
            this.frame.setVisible(true);
            while (this.bar.getValue() < this.bar.getMaximum()) {
                try {
                    progress.sleep(500L);
                    this.bar.setValue(this.current);
                }
                catch (InterruptedException interruptedException) {
                    this.bar.setValue(this.bar.getMaximum());
                    break;
                }
            }
            this.frame.setVisible(false);
        }
    }

    class workUnit
    extends Thread {
        String line;
        int nTasks = 0;
        int first;
        int second;
        RandomAccessFile sourceFile;

        public workUnit(File file) {
            try {
                this.sourceFile = new RandomAccessFile(file, "r");
            }
            catch (FileNotFoundException fileNotFoundException) {
                Tools.showErrorDialog("Tracefile " + file.getName() + " not found");
            }
        }

        public String getNumberOfTasks() {
            return String.valueOf(this.nTasks);
        }

        @Override
        public void run() {
            try {
                workUnit.sleep(50L);
                do {
                    this.line = this.sourceFile.readLine();
                } while (this.line.equals(""));
                if (this.line.startsWith("#DIMEMAS")) {
                    Pattern pattern = Pattern.compile("#DIMEMAS:\"(.*)\":(.*):(\\d+)\\((.*)$");
                    Matcher matcher = pattern.matcher(this.line);
                    if (!matcher.matches()) {
                        Tools.showErrorDialog("Wrong header in tracefile");
                    } else {
                        String string = matcher.group(3);
                        InitialMachineWindow.this.tf_tasks.setText(matcher.group(3));
                    }
                } else if (this.line.startsWith("SDDFA;;")) {
                    Tools.showErrorDialog("This version does not support TRF tracefiles. Plase convert the trace");
                    InitialMachineWindow.this.tf_tracefile.setText(null);
                } else {
                    Tools.showErrorDialog("Unknown input trace format");
                    InitialMachineWindow.this.tf_tracefile.setText(null);
                }
                this.sourceFile.close();
            }
            catch (InterruptedException interruptedException) {
                Tools.showInformationMessage(interruptedException.toString());
            }
            catch (IOException iOException) {
                Tools.showInformationMessage(iOException.toString());
            }
        }
    }
}

