/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import gui.OptionsMenu;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class Main
extends JFrame {
    public static final long serialVersionUID = 1000L;
    JTextField currentConfigurationFile = new JTextField("");
    Data data = new Data(this.currentConfigurationFile);
    OptionsMenu menu = new OptionsMenu(this.data);
    Container panelPrincipal = this.getContentPane();

    public Main() {
        super("Dimemas");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("resources/dimemas_icon.png")));
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setJMenuBar(this.menu);
        this.panelPrincipal.setLayout(new BorderLayout());
        this.panelPrincipal.add("West", new JLabel("  Current configuration file: "));
        this.panelPrincipal.add("Center", this.currentConfigurationFile);
        this.setBounds(25, 50, 600, 100);
        this.setResizable(false);
        this.setVisible(true);
    }

    public void loadCommandLineConfigurationFile(String string) {
        this.data.loadFromDisk(string);
    }

    public static void main(String[] stringArray) {
        if (!Data.checkConfigurationFiles()) {
            System.exit(-1);
        }
        final Main main = new Main();
        if (stringArray.length == 1) {
            main.loadCommandLineConfigurationFile(stringArray[0]);
        }
        main.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (0 == JOptionPane.showConfirmDialog(null, "Are you sure you want to quit?", "Dimemas Question", 0)) {
                    System.exit(0);
                } else {
                    main.setVisible(true);
                }
            }
        });
    }
}

