/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import gui.GUIWindow;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tools.Tools;

public class NodeWindow
extends GUIWindow {
    public static final long serialVersionUID = 12L;
    private JButton b_left = this.createButton("<<<");
    private JButton b_right = this.createButton(">>>");
    private JButton b_save = this.createButton("Save");
    private JButton b_close = this.createButton("Close");
    private JButton b_same = this.createButton("Do all the same");
    private JTextField tf_number = this.createTextField(2);
    private JTextField tf_machine_id = this.createTextField(18);
    private JTextField tf_node_id = new JTextField(18);
    private JTextField tf_architecture = this.createTextField(18);
    private JTextField tf_processors = new JTextField(18);
    private JTextField tf_cpu_ratio = new JTextField(18);
    private JTextField tf_intra_node_startup = new JTextField(18);
    private JTextField tf_intra_node_bandwidth = new JTextField(18);
    private JTextField tf_intra_node_buses = new JTextField(18);
    private JTextField tf_intra_node_in_links = new JTextField(18);
    private JTextField tf_intra_node_out_links = new JTextField(18);
    private JTextField tf_inter_node_startup = new JTextField(18);
    private JTextField tf_inter_node_in_links = new JTextField(18);
    private JTextField tf_inter_node_out_links = new JTextField(18);
    private JTextField tf_wan_startup = new JTextField(18);
    private JCheckBox cb_acc = new JCheckBox("Heterogenous node");
    private JTextField tf_acc = new JTextField(18);
    private JTextField tf_acc_number = new JTextField(18);
    private JTextField tf_acc_startup = new JTextField(18);
    private JTextField tf_acc_mem_startup = new JTextField(18);
    private JTextField tf_acc_bandwidth = new JTextField(18);
    private JTextField tf_acc_buses = new JTextField(18);
    private JTextField tf_acc_ratio = new JTextField(18);

    private JTextField createTextField(int n) {
        JTextField jTextField = new JTextField(n);
        jTextField.setBorder(null);
        jTextField.setEditable(false);
        return jTextField;
    }

    private void fillInformation(int n) {
        this.tf_number.setText(String.valueOf(n + 1));
        this.tf_machine_id.setText(this.data.nodes_information.node[n].getMachine_id());
        this.tf_node_id.setText(this.data.nodes_information.node[n].getNode_id());
        if (this.data.nodes_information.node[n].getArchitecture(false).equalsIgnoreCase("")) {
            this.tf_architecture.setText("Custom architecture");
        } else {
            this.tf_architecture.setText(this.data.nodes_information.node[n].getArchitecture(false));
        }
        this.tf_processors.setText(this.data.nodes_information.node[n].getProcessors());
        this.tf_cpu_ratio.setText(this.data.nodes_information.node[n].getCPURatio());
        this.tf_intra_node_startup.setText(this.data.nodes_information.node[n].getIntraNodeStartup());
        this.tf_intra_node_bandwidth.setText(this.data.nodes_information.node[n].getIntraNodeBandwidth());
        this.tf_intra_node_buses.setText(this.data.nodes_information.node[n].getIntraNodeBuses());
        this.tf_intra_node_in_links.setText(this.data.nodes_information.node[n].getIntraNodeInLinks());
        this.tf_intra_node_out_links.setText(this.data.nodes_information.node[n].getIntraNodeOutLinks());
        this.tf_inter_node_startup.setText(this.data.nodes_information.node[n].getInterNodeStartup());
        this.tf_inter_node_in_links.setText(this.data.nodes_information.node[n].getInterNodeInLinks());
        this.tf_inter_node_out_links.setText(this.data.nodes_information.node[n].getInterNodeOutLinks());
        this.tf_wan_startup.setText(this.data.nodes_information.node[n].getWANStartup());
        this.cb_acc.setSelected(this.data.nodes_information.node[n].getAcc());
        if (this.data.nodes_information.node[n].getAcc().booleanValue()) {
            this.tf_acc_number.setText(this.data.nodes_information.node[n].getAccNumber());
            this.tf_acc_startup.setText(this.data.nodes_information.node[n].getAccStartup());
            this.tf_acc_mem_startup.setText(this.data.nodes_information.node[n].getAccMemStartup());
            this.tf_acc_bandwidth.setText(this.data.nodes_information.node[n].getAccBandwidth());
            this.tf_acc_buses.setText(this.data.nodes_information.node[n].getAccBuses());
            this.tf_acc_ratio.setText(this.data.nodes_information.node[n].getAccRatio());
        }
    }

    private boolean dataOK() {
        if (this.tf_machine_id.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("Machine identificator missing");
            return false;
        }
        if (this.tf_node_id.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("Node identificator missing");
            return false;
        }
        if (this.tf_processors.getText().equalsIgnoreCase("") || this.tf_processors.getText().equalsIgnoreCase("0")) {
            Tools.showWarningMessage("Number of processors missing or equals to 0");
            return false;
        }
        if (this.tf_cpu_ratio.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("Relative processor speed (CPU ratio) missing");
            return false;
        }
        if (this.tf_intra_node_startup.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("Intra-node communications startup missing");
            return false;
        }
        if (this.tf_intra_node_bandwidth.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("Intra-node communications bandwidth missing");
            return false;
        }
        if (this.tf_intra_node_in_links.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("Intra-node communications input links missing");
            return false;
        }
        if (this.tf_intra_node_out_links.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("Intra-node communications output links missing");
            return false;
        }
        if (this.tf_inter_node_startup.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("Inter-node communications startup missing");
            return false;
        }
        if (this.tf_inter_node_in_links.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("Inter-node communications input links missing");
            return false;
        }
        if (this.tf_inter_node_out_links.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("Inter-node communications output links missing");
            return false;
        }
        if (this.tf_wan_startup.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("Inter-machines (WAN) communications startup missing");
            return false;
        }
        if (this.cb_acc.isSelected()) {
            if (this.tf_acc_number.getText().equalsIgnoreCase("")) {
                Tools.showWarningMessage("Number of GPU missing");
                return false;
            }
            if (this.tf_acc_startup.getText().equalsIgnoreCase("")) {
                Tools.showWarningMessage("Accelerator startup missing");
                return false;
            }
            if (this.tf_acc_mem_startup.getText().equalsIgnoreCase("")) {
                Tools.showWarningMessage("Accelerator memory startup missing");
                return false;
            }
            if (this.tf_acc_bandwidth.getText().equalsIgnoreCase("")) {
                Tools.showWarningMessage("Accelerator bandwidth missing");
                return false;
            }
            if (this.tf_acc_buses.getText().equalsIgnoreCase("")) {
                Tools.showWarningMessage("Accelerator number of buses missing");
                return false;
            }
            if (this.tf_acc_ratio.getText().equalsIgnoreCase("")) {
                Tools.showWarningMessage("Accelerator speed ratio missing");
                return false;
            }
        }
        return true;
    }

    private boolean storeInformation(int n, boolean bl) {
        if (!this.dataOK()) {
            return false;
        }
        try {
            if (!bl) {
                this.data.nodes_information.node[n].setNode_id(this.tf_node_id.getText());
            }
            this.data.nodes_information.node[n].setProcessors(this.tf_processors.getText());
            this.data.nodes_information.node[n].setCPURatio(this.tf_cpu_ratio.getText());
            this.data.nodes_information.node[n].setIntraNodeStartup(this.tf_intra_node_startup.getText());
            this.data.nodes_information.node[n].setIntraNodeBandwidth(this.tf_intra_node_bandwidth.getText());
            this.data.nodes_information.node[n].setIntraNodeBuses(this.tf_intra_node_buses.getText());
            this.data.nodes_information.node[n].setIntraNodeInLinks(this.tf_intra_node_in_links.getText());
            this.data.nodes_information.node[n].setIntraNodeOutLinks(this.tf_intra_node_out_links.getText());
            this.data.nodes_information.node[n].setInterNodeStartup(this.tf_inter_node_startup.getText());
            this.data.nodes_information.node[n].setInterNodeInLinks(this.tf_inter_node_in_links.getText());
            this.data.nodes_information.node[n].setInterNodeOutLinks(this.tf_inter_node_out_links.getText());
            this.data.nodes_information.node[n].setWANStartup(this.tf_wan_startup.getText());
            this.data.nodes_information.node[n].setAcc(this.cb_acc.isSelected());
            if (this.cb_acc.isSelected()) {
                this.data.nodes_information.node[n].setAccNumber(this.tf_acc_number.getText());
                this.data.nodes_information.node[n].setAccStartup(this.tf_acc_startup.getText());
                this.data.nodes_information.node[n].setAccMemStartup(this.tf_acc_mem_startup.getText());
                this.data.nodes_information.node[n].setAccBandwidth(this.tf_acc_bandwidth.getText());
                this.data.nodes_information.node[n].setAccBuses(this.tf_acc_buses.getText());
                this.data.nodes_information.node[n].setAccRatio(this.tf_acc_ratio.getText());
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public NodeWindow(Data data, int n) {
        super(data);
        this.setTitle("Node information");
        this.fillInformation(n);
        this.drawLine(new Component[]{new JLabel("Node number"), this.b_left, this.tf_number, this.b_right});
        this.drawLine(new Component[]{new JLabel("Machine id"), this.tf_machine_id});
        this.drawLine(new Component[]{new JLabel("Simulated architecture"), this.tf_architecture});
        this.drawProcessorPanel();
        this.drawIntraNodeCommsPanel();
        this.drawInterNodeCommsPanel();
        this.drawWANCommsPanel();
        this.drawAccPanel(n);
        this.drawButtons(new Component[]{this.b_save, this.b_same, this.b_close}, 25, 5);
        this.setBounds(25, 150, this.getWidth() + 30, this.getHeight());
        this.pack();
        this.setVisible(true);
    }

    private void drawProcessorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Processor parameters"));
        jPanel.add(new JLabel("Number of processors"));
        jPanel.add(this.tf_processors);
        jPanel.add(new JLabel("Relative processor speed [%]"));
        jPanel.add(this.tf_cpu_ratio);
        super.addComponent(jPanel);
    }

    private void drawIntraNodeCommsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Intra-node communications parameters"));
        jPanel.add(new JLabel("Startup [s]"));
        jPanel.add(this.tf_intra_node_startup);
        jPanel.add(new JLabel("Bandwidth [MByte/s]"));
        jPanel.add(this.tf_intra_node_bandwidth);
        jPanel.add(new JLabel("Buses"));
        jPanel.add(this.tf_intra_node_buses);
        jPanel.add(new JLabel("Input Links"));
        jPanel.add(this.tf_intra_node_in_links);
        jPanel.add(new JLabel("Output Links"));
        jPanel.add(this.tf_intra_node_out_links);
        super.addComponent(jPanel);
    }

    private void drawInterNodeCommsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Inter-node communications parameters"));
        jPanel.add(new JLabel("Startup [s]"));
        jPanel.add(this.tf_inter_node_startup);
        jPanel.add(new JLabel("Input links"));
        jPanel.add(this.tf_inter_node_in_links);
        jPanel.add(new JLabel("Output links"));
        jPanel.add(this.tf_inter_node_out_links);
        super.addComponent(jPanel);
    }

    private void drawWANCommsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "WAN communications parameters"));
        jPanel.add(new JLabel("Startup [s]"));
        jPanel.add(this.tf_wan_startup);
        super.addComponent(jPanel);
    }

    private void drawAccPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(7, 2, 5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Accelerator parameters"));
        Boolean bl = this.data.nodes_information.node[n].getAcc();
        jPanel.add(new JLabel("Heterogenous node"));
        this.cb_acc.setSelected(bl);
        jPanel.add(this.cb_acc);
        this.cb_acc.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (NodeWindow.this.cb_acc.isSelected()) {
                    NodeWindow.this.tf_acc_number.setEnabled(true);
                    NodeWindow.this.tf_acc_startup.setEnabled(true);
                    NodeWindow.this.tf_acc_mem_startup.setEnabled(true);
                    NodeWindow.this.tf_acc_bandwidth.setEnabled(true);
                    NodeWindow.this.tf_acc_buses.setEnabled(true);
                    NodeWindow.this.tf_acc_ratio.setEnabled(true);
                } else if (!NodeWindow.this.cb_acc.isSelected()) {
                    NodeWindow.this.tf_acc_number.setEnabled(false);
                    NodeWindow.this.tf_acc_startup.setEnabled(false);
                    NodeWindow.this.tf_acc_mem_startup.setEnabled(false);
                    NodeWindow.this.tf_acc_bandwidth.setEnabled(false);
                    NodeWindow.this.tf_acc_buses.setEnabled(false);
                    NodeWindow.this.tf_acc_ratio.setEnabled(false);
                }
            }
        });
        jPanel.add(new JLabel("Number of gpu [s]"));
        this.tf_acc_number.setEnabled(bl);
        jPanel.add(this.tf_acc_number);
        jPanel.add(new JLabel("Startup [s]"));
        this.tf_acc_startup.setEnabled(bl);
        jPanel.add(this.tf_acc_startup);
        jPanel.add(new JLabel("Memory startup [s]"));
        this.tf_acc_mem_startup.setEnabled(bl);
        jPanel.add(this.tf_acc_mem_startup);
        jPanel.add(new JLabel("Bandwidth [MByte/s]"));
        this.tf_acc_bandwidth.setEnabled(bl);
        jPanel.add(this.tf_acc_bandwidth);
        jPanel.add(new JLabel("Buses"));
        this.tf_acc_buses.setEnabled(bl);
        jPanel.add(this.tf_acc_buses);
        jPanel.add(new JLabel("Relative speed [%]"));
        this.tf_acc_ratio.setEnabled(bl);
        jPanel.add(this.tf_acc_ratio);
        super.addComponent(jPanel);
    }

    private String increase(String string) {
        int n = Integer.parseInt(string);
        if (n == this.data.nodes_information.getNumberOfNodes()) {
            return "1";
        }
        return String.valueOf(++n);
    }

    private String decrease(String string) {
        int n = Integer.parseInt(string);
        if (n == 1) {
            return String.valueOf(this.data.nodes_information.getNumberOfNodes());
        }
        return String.valueOf(--n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (actionEvent.getSource() == this.b_left && this.storeInformation(Integer.parseInt(this.tf_number.getText()) - 1, false)) {
            string = this.data.map.changeAtNodes();
            if (string != null) {
                Tools.showWarningMessage(string + "\nPlease check the \"Mapping information\" to verify your task mapping");
            }
            this.tf_number.setText(this.decrease(this.tf_number.getText()));
            this.fillInformation(Integer.parseInt(this.tf_number.getText()) - 1);
        }
        if (actionEvent.getSource() == this.b_right) {
            if (this.storeInformation(Integer.parseInt(this.tf_number.getText()) - 1, false)) {
                string = this.data.map.changeAtNodes();
                if (string != null) {
                    Tools.showWarningMessage(string + "\nPlease check the \"Mapping information\" to verify your task mapping");
                }
                this.tf_number.setText(this.increase(this.tf_number.getText()));
                this.fillInformation(Integer.parseInt(this.tf_number.getText()) - 1);
            }
        } else if (actionEvent.getSource() == this.b_save) {
            if (this.storeInformation(Integer.parseInt(this.tf_number.getText()) - 1, false)) {
                string = this.data.map.changeAtNodes();
                if (string != null) {
                    Tools.showWarningMessage(string + "\nPlease check the \"Mapping information\" to verify your task mapping");
                }
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.b_close) {
            this.dispose();
        } else if (actionEvent.getSource() == this.b_same) {
            boolean bl = false;
            for (int i = this.data.nodes_information.getNumberOfNodes() - 1; i >= 0; --i) {
                if (this.storeInformation(i, true)) continue;
                bl = true;
                break;
            }
            if (!bl && (string = this.data.map.changeAtNodes()) != null) {
                Tools.showWarningMessage(string + "\nPlease check the \"Mapping information\" to verify your task mapping");
            }
        }
    }
}

