/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import gui.AboutWindow;
import gui.ConfigurationOptionsWindow;
import gui.InitialMachineWindow;
import gui.SimulatorCallWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import tools.Tools;

public class OptionsMenu
extends JMenuBar
implements ActionListener {
    public static final long serialVersionUID = 13L;
    private final Data data;
    private final JMenu config = new JMenu("Configuration");
    private final JMenu sim = new JMenu("Simulator");
    private final JMenu info = new JMenu("Information");
    private final JMenuItem initial = this.createMenuItem("Select tracefile...");
    private final JMenuItem target = this.createMenuItem("Configure target machine");
    private final JMenuItem loadConf = this.createMenuItem("Load configuration");
    private final JMenuItem saveConf = this.createMenuItem("Save configuration");
    private final JMenuItem exit = this.createMenuItem("Exit");
    private final JMenuItem dimemas = this.createMenuItem("Dimemas");
    private final JMenuItem critical = this.createMenuItem("Critical path analysis");
    private final JMenuItem perturbation = this.createMenuItem("Synthetic perturbation analysis");
    private final JMenuItem loadOp = this.createMenuItem("Load options");
    private final JMenuItem saveOp = this.createMenuItem("Save options");
    private final JMenuItem about = this.createMenuItem("About");
    ConfigurationOptionsWindow cow;

    private JMenuItem createMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    public OptionsMenu(Data data) {
        this.data = data;
        this.critical.setEnabled(false);
        this.perturbation.setEnabled(false);
        this.config.add(this.initial);
        this.config.add(this.target);
        this.config.addSeparator();
        this.config.add(this.loadConf);
        this.config.add(this.saveConf);
        this.config.addSeparator();
        this.config.add(this.exit);
        this.sim.add(this.dimemas);
        this.sim.add(this.critical);
        this.sim.add(this.perturbation);
        this.sim.addSeparator();
        this.sim.add(this.loadOp);
        this.sim.add(this.saveOp);
        this.info.add(this.about);
        this.add(this.config);
        this.add(this.info);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.initial) {
            this.initial.setEnabled(false);
            new InitialMachineWindow(this.data).addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    OptionsMenu.this.initial.setEnabled(true);
                    if (!OptionsMenu.this.target.isEnabled()) {
                        OptionsMenu.this.cow.refresh();
                    }
                }
            });
        } else if (actionEvent.getSource() == this.target) {
            this.target.setEnabled(false);
            this.cow = new ConfigurationOptionsWindow(this.data);
            this.cow.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    OptionsMenu.this.target.setEnabled(true);
                    OptionsMenu.this.cow = null;
                }
            });
        } else if (actionEvent.getSource() == this.loadConf) {
            Tools.fc.setAcceptAllFileFilterUsed(false);
            Tools.fc.addChoosableFileFilter(new Tools.CFGfilter());
            int n = Tools.fc.showOpenDialog(null);
            if (n == 0) {
                this.data.loadFromDisk(Tools.fc.getSelectedFile().getAbsolutePath());
                if (!this.target.isEnabled()) {
                    this.cow.refresh();
                }
            }
            Tools.fc.resetChoosableFileFilters();
        } else if (actionEvent.getSource() == this.saveConf) {
            Tools.fc.setAcceptAllFileFilterUsed(false);
            Tools.fc.addChoosableFileFilter(new Tools.CFGfilter());
            int n = Tools.fc.showSaveDialog(null);
            if (n == 0) {
                String string = Tools.fc.getSelectedFile().getAbsolutePath();
                Object object = string.endsWith(".cfg") ? string : string + ".cfg";
                boolean bl = true;
                if (new File((String)object).isFile() && !Tools.showConfirmationMessage("Do you want to overwrite current file?")) {
                    bl = false;
                }
                if (bl && this.data.saveToDisk((String)object)) {
                    this.data.setCurrentConfigurationFileLabel((String)object);
                }
            }
            Tools.fc.resetChoosableFileFilters();
        } else if (actionEvent.getSource() == this.exit) {
            if (0 == JOptionPane.showConfirmDialog(this, "Are you sure you want to quit?", "Dimemas Question", 0)) {
                System.exit(0);
            }
        } else if (actionEvent.getSource() == this.dimemas) {
            this.dimemas.setEnabled(false);
            new SimulatorCallWindow(this.data).addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    OptionsMenu.this.dimemas.setEnabled(true);
                }
            });
        } else if (actionEvent.getSource() != this.critical && actionEvent.getSource() != this.perturbation) {
            if (actionEvent.getSource() == this.loadOp) {
                Tools.fc.addChoosableFileFilter(new Tools.OPTfilter());
                int n = Tools.fc.showOpenDialog(null);
                if (n == 0) {
                    this.data.simOptions.loadFromDisk(Tools.fc.getSelectedFile());
                }
                Tools.fc.resetChoosableFileFilters();
            } else if (actionEvent.getSource() == this.saveOp) {
                Tools.fc.addChoosableFileFilter(new Tools.OPTfilter());
                int n = Tools.fc.showSaveDialog(null);
                if (n == 0) {
                    if (Tools.fc.getSelectedFile().getAbsolutePath().endsWith(".opt")) {
                        this.data.simOptions.saveToDisk(Tools.fc.getSelectedFile().getAbsolutePath());
                    } else {
                        this.data.simOptions.saveToDisk(Tools.fc.getSelectedFile().getAbsolutePath() + ".opt");
                    }
                }
                Tools.fc.resetChoosableFileFilters();
            } else if (actionEvent.getSource() == this.about) {
                this.about.setEnabled(false);
                new AboutWindow().addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        OptionsMenu.this.about.setEnabled(true);
                    }
                });
            }
        }
    }
}

