/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import data.MappingData;
import gui.GUIWindow;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import tools.Tools;

public class PredefinedMapsWindow
extends GUIWindow {
    public static final long serialVersionUID = 14L;
    private int[] currentMap;
    private int currentMapInfo;
    private int nTasksPerNode;
    private JButton b_close;
    private JButton b_save;
    private JLabel l_unknownTaskNum;
    private JLabel l_unknownTaskNum1;
    private JPanel p_buttons;
    private JPanel p_labels;
    private JPanel p_radioButtos;
    private JRadioButton rb_filledNodes;
    private JRadioButton rb_interleaved;
    private JRadioButton rb_irregularMap;
    private JRadioButton rb_nTasksPerNode;
    private ButtonGroup rb_predefinedMaps;
    private JTextField tf_nTasksPerNode;

    public PredefinedMapsWindow(Data data) {
        super(data);
        this.initComponents();
        this.currentMap = this.data.map.getMap();
        this.currentMapInfo = this.data.map.getMapInfo();
        this.nTasksPerNode = this.data.map.getNTasksPerNode();
        if (this.data.map.getTasks() <= 0) {
            this.l_unknownTaskNum.setVisible(true);
            this.l_unknownTaskNum1.setVisible(true);
        } else {
            this.l_unknownTaskNum.setVisible(false);
            this.l_unknownTaskNum1.setVisible(false);
        }
        this.setState();
        this.pack();
        this.setVisible(true);
    }

    private void initComponents() {
        this.rb_predefinedMaps = new ButtonGroup();
        this.p_radioButtos = new JPanel();
        this.rb_filledNodes = new JRadioButton();
        this.rb_interleaved = new JRadioButton();
        this.tf_nTasksPerNode = new JTextField();
        this.rb_nTasksPerNode = new JRadioButton();
        this.rb_irregularMap = new JRadioButton();
        this.p_buttons = new JPanel();
        this.b_close = new JButton();
        this.b_save = new JButton();
        this.p_labels = new JPanel();
        this.l_unknownTaskNum1 = new JLabel();
        this.l_unknownTaskNum = new JLabel();
        this.setTitle("Predefined Maps");
        this.setResizable(false);
        this.rb_predefinedMaps.add(this.rb_filledNodes);
        this.rb_filledNodes.setFont(this.rb_filledNodes.getFont());
        this.rb_filledNodes.setText("Fill Nodes");
        this.rb_filledNodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PredefinedMapsWindow.this.rb_filledNodesActionPerformed(actionEvent);
            }
        });
        this.rb_predefinedMaps.add(this.rb_interleaved);
        this.rb_interleaved.setFont(this.rb_interleaved.getFont());
        this.rb_interleaved.setText("Interleaved");
        this.rb_interleaved.setToolTipText("One tasks is assigned to each node in a cyclic way");
        this.rb_interleaved.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PredefinedMapsWindow.this.rb_interleavedActionPerformed(actionEvent);
            }
        });
        this.tf_nTasksPerNode.setColumns(2);
        this.tf_nTasksPerNode.setFont(this.tf_nTasksPerNode.getFont());
        this.tf_nTasksPerNode.setText("1");
        this.tf_nTasksPerNode.setToolTipText("Press 'Enter' to confirm the value");
        this.tf_nTasksPerNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PredefinedMapsWindow.this.tf_nTasksPerNodeActionPerformed(actionEvent);
            }
        });
        this.rb_predefinedMaps.add(this.rb_nTasksPerNode);
        this.rb_nTasksPerNode.setFont(this.rb_nTasksPerNode.getFont());
        this.rb_nTasksPerNode.setText("'n' tasks per node");
        this.rb_nTasksPerNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PredefinedMapsWindow.this.rb_nTasksPerNodeActionPerformed(actionEvent);
            }
        });
        this.rb_predefinedMaps.add(this.rb_irregularMap);
        this.rb_irregularMap.setText("Irregular map");
        this.rb_irregularMap.setToolTipText("Map modified manually, not selectable");
        this.rb_irregularMap.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout(this.p_radioButtos);
        this.p_radioButtos.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rb_irregularMap).addComponent(this.rb_interleaved).addComponent(this.rb_filledNodes)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.rb_nTasksPerNode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tf_nTasksPerNode, -2, -1, -2)))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.rb_filledNodes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rb_nTasksPerNode).addComponent(this.tf_nTasksPerNode, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rb_interleaved).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rb_irregularMap).addContainerGap()));
        this.b_close.setFont(this.b_close.getFont());
        this.b_close.setText("Close");
        this.b_close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PredefinedMapsWindow.this.b_closeActionPerformed(actionEvent);
            }
        });
        this.b_save.setFont(this.b_save.getFont());
        this.b_save.setText("Save");
        this.b_save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PredefinedMapsWindow.this.b_saveActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.p_buttons);
        this.p_buttons.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(28, 28, 28).addComponent(this.b_save, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.b_close, -2, 100, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.b_close).addComponent(this.b_save)).addContainerGap()));
        GroupLayout groupLayout3 = new GroupLayout(this.p_labels);
        this.p_labels.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 14, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 40, Short.MAX_VALUE));
        this.l_unknownTaskNum1.setForeground(new Color(255, 0, 0));
        this.l_unknownTaskNum1.setText("Verify the mapping in the simulator");
        this.l_unknownTaskNum.setForeground(new Color(255, 0, 0));
        this.l_unknownTaskNum.setText("NOTE: unknown number of tasks.");
        GroupLayout groupLayout4 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addComponent(this.p_labels, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.l_unknownTaskNum1).addComponent(this.l_unknownTaskNum))).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.p_buttons, -1, -1, Short.MAX_VALUE)).addGroup(groupLayout4.createSequentialGroup().addGap(37, 37, 37).addComponent(this.p_radioButtos, -2, -1, -2))).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.p_radioButtos, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.p_buttons, -2, 47, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addComponent(this.p_labels, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(groupLayout4.createSequentialGroup().addComponent(this.l_unknownTaskNum, -2, 17, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.l_unknownTaskNum1))).addContainerGap()));
    }

    private void rb_nTasksPerNodeActionPerformed(ActionEvent actionEvent) {
        MappingData.MapResult mapResult = new MappingData.MapResult(this.data.map);
        try {
            this.nTasksPerNode = Integer.parseInt(this.tf_nTasksPerNode.getText());
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("Wrong tasks per node value");
            return;
        }
        mapResult = this.data.map.mapNTasksPerNode(this.nTasksPerNode);
        if (mapResult.errorMessage != null) {
            Tools.showErrorMessage(mapResult.errorMessage);
        }
        this.currentMap = mapResult.generatedMap;
        this.currentMapInfo = 2;
        this.setState();
    }

    private void rb_interleavedActionPerformed(ActionEvent actionEvent) {
        MappingData.MapResult mapResult = new MappingData.MapResult(this.data.map);
        mapResult = this.data.map.mapInterleaved();
        if (mapResult.errorMessage != null) {
            Tools.showErrorDialog(mapResult.errorMessage);
        }
        this.currentMap = mapResult.generatedMap;
        this.currentMapInfo = 3;
        this.setState();
    }

    private void rb_filledNodesActionPerformed(ActionEvent actionEvent) {
        MappingData.MapResult mapResult = new MappingData.MapResult(this.data.map);
        mapResult = this.data.map.mapFillingNodes();
        if (mapResult.errorMessage != null) {
            Tools.showErrorMessage(mapResult.errorMessage);
        }
        this.currentMap = mapResult.generatedMap;
        this.currentMapInfo = 1;
        this.setState();
    }

    private void tf_nTasksPerNodeActionPerformed(ActionEvent actionEvent) {
        MappingData.MapResult mapResult = new MappingData.MapResult(this.data.map);
        try {
            this.nTasksPerNode = Integer.parseInt(this.tf_nTasksPerNode.getText());
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage("Wrong tasks per node value");
            return;
        }
        mapResult = this.data.map.mapNTasksPerNode(this.nTasksPerNode);
        if (mapResult.errorMessage != null) {
            Tools.showErrorMessage(mapResult.errorMessage);
        }
        this.currentMap = mapResult.generatedMap;
        this.currentMapInfo = 2;
        this.setState();
    }

    private void b_saveActionPerformed(ActionEvent actionEvent) {
        if (this.rb_nTasksPerNode.isSelected()) {
            try {
                this.nTasksPerNode = Integer.parseInt(this.tf_nTasksPerNode.getText());
            }
            catch (NumberFormatException numberFormatException) {
                Tools.showErrorMessage("Wrong tasks per node value");
                return;
            }
        }
        this.data.map.setMapInfo(this.currentMapInfo);
        this.data.map.setMap(this.currentMap);
        this.data.map.setNTasksPerNode(this.nTasksPerNode);
        if (this.data.map.getMapInfo() == -1) {
            Tools.showWarningMessage("Please select the mapping first");
            this.setVisible(true);
        } else {
            this.dispose();
        }
    }

    private void b_closeActionPerformed(ActionEvent actionEvent) {
        if (this.data.map.getMapInfo() == -1) {
            Tools.showWarningMessage("Please select a map before closing");
            this.setVisible(true);
            this.dispose();
        } else {
            this.dispose();
        }
    }

    private void setState() {
        switch (this.currentMapInfo) {
            case 0: {
                this.rb_irregularMap.setSelected(true);
                break;
            }
            case 1: {
                this.rb_filledNodes.setSelected(true);
                break;
            }
            case 2: {
                this.rb_nTasksPerNode.setSelected(true);
                this.tf_nTasksPerNode.setText(String.valueOf(this.nTasksPerNode));
                break;
            }
            case 3: {
                this.rb_interleaved.setSelected(true);
                break;
            }
        }
    }
}

