/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import gui.GUIWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.RandomAccessFile;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import tools.Tools;

public class ResultsWindow
extends GUIWindow {
    public static final long serialVersionUID = 15L;
    private boolean errorWindow;
    private JPanel buttonPanel = new JPanel(new FlowLayout());
    private JTextArea result = new JTextArea();
    private JButton b_save = this.createButton("Save results");
    private JButton b_close = this.createButton("Close window");
    private JScrollPane scrollPanel = new JScrollPane(this.result, 20, 30);

    public ResultsWindow(Data data, String string) {
        super(data);
        this.errorWindow = string.equalsIgnoreCase("Error");
        this.setTitle(string);
        this.setSize(425, 375);
        this.windowPanel.setLayout(new BorderLayout());
        this.result.setEditable(false);
        this.result.setBackground(Color.lightGray);
        if (this.errorWindow) {
            this.setLocation(425, 150);
        } else {
            this.setLocation(0, 150);
            this.buttonPanel.add(this.b_save);
        }
        this.buttonPanel.add(this.b_close);
        this.windowPanel.add("Center", this.scrollPanel);
        this.windowPanel.add("South", this.buttonPanel);
    }

    public void writeLine(String string) {
        this.result.append(string);
        this.result.append("\n");
    }

    public boolean empty() {
        return this.result.getLineCount() == 0;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.b_close) {
            this.dispose();
        } else if (actionEvent.getSource() == this.b_save) {
            Tools.fc.addChoosableFileFilter(new Tools.OUTfilter());
            int n = Tools.fc.showSaveDialog(null);
            if (n == 0) {
                File file = Tools.fc.getSelectedFile().getAbsolutePath().endsWith(".out") ? new File(Tools.fc.getSelectedFile().getAbsolutePath()) : new File(Tools.fc.getSelectedFile().getAbsolutePath() + ".out");
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    if (randomAccessFile.length() != 0L) {
                        randomAccessFile.setLength(0L);
                    }
                    randomAccessFile.writeBytes(this.result.getText());
                    randomAccessFile.close();
                }
                catch (Throwable throwable) {
                    Tools.showInformationMessage(throwable.toString());
                }
            }
            Tools.fc.resetChoosableFileFilters();
        }
    }
}

