/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import gui.GUIWindow;
import gui.ResultsWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tools.Tools;

public class SimulatorCallWindow
extends GUIWindow {
    public static final long serialVersionUID = 16L;
    private final String TEMP_CONFIG_FILE = "conf0000.tmp";
    private JButton b_sim = this.createButton("Call simulator");
    private JButton b_close = this.createButton("Close");
    private JTextField tf_break = new JTextField(15);
    private JTextField tf_start = new JTextField(15);
    private JTextField tf_stop = new JTextField(15);
    private JTextField tf_size = new JTextField(15);
    private JTextField tf_filename = new JTextField(15);
    private JComboBox cb_output = this.createComboBox();
    private JRadioButton ignoreSync_no;
    private JRadioButton ignoreSync_yes;
    private ButtonGroup syncGroup = this.createGroup('i');
    private JRadioButton load_no;
    private JRadioButton load_yes;
    private ButtonGroup loadGroup = this.createGroup('l');
    private JRadioButton type_ascii;
    private JRadioButton type_binary;
    private ButtonGroup typeGroup = this.createGroup('t');

    private JComboBox createComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("None");
        jComboBox.addItem("Paraver");
        jComboBox.addItem("Vampir");
        jComboBox.addActionListener(this);
        return jComboBox;
    }

    private ButtonGroup createGroup(char c) {
        ButtonGroup buttonGroup = new ButtonGroup();
        switch (c) {
            case 'i': {
                this.ignoreSync_no = new JRadioButton("NO");
                this.ignoreSync_yes = new JRadioButton("YES");
                buttonGroup.add(this.ignoreSync_no);
                buttonGroup.add(this.ignoreSync_yes);
                break;
            }
            case 'l': {
                this.load_no = new JRadioButton("NO");
                this.load_yes = new JRadioButton("YES");
                buttonGroup.add(this.load_no);
                buttonGroup.add(this.load_yes);
                break;
            }
            case 't': {
                this.type_ascii = new JRadioButton("ASCII");
                this.type_binary = new JRadioButton("Binary");
                buttonGroup.add(this.type_ascii);
                buttonGroup.add(this.type_binary);
                break;
            }
        }
        return buttonGroup;
    }

    public SimulatorCallWindow(Data data) {
        super(data);
        this.setTitle("Simulator options");
        this.tf_break.setText(this.data.simOptions.getSimTime());
        this.tf_filename.setText(this.data.simOptions.getFilename());
        this.tf_start.setText(this.data.simOptions.getStartTime());
        this.tf_stop.setText(this.data.simOptions.getStopTime());
        this.tf_size.setText(this.data.simOptions.getMinSize());
        if (this.data.simOptions.getLoadInMemory()) {
            this.load_yes.setSelected(true);
        } else {
            this.load_no.setSelected(true);
        }
        if (this.data.simOptions.getIsTypeAscii()) {
            this.type_ascii.setSelected(true);
        } else {
            this.type_binary.setSelected(true);
        }
        if (this.data.simOptions.getIgnoreSend()) {
            this.ignoreSync_yes.setSelected(true);
        } else {
            this.ignoreSync_no.setSelected(true);
        }
        this.cb_output.setSelectedIndex(this.data.simOptions.getOutputFile());
        this.drawLine(new Component[]{new JLabel("Load trace into memory"), this.load_no, this.load_yes});
        this.drawLine(new Component[]{new JLabel("Simulation break time [s]"), this.tf_break});
        this.drawLine(new Component[]{new JLabel("Ignore synchronous send trace field"), this.ignoreSync_no, this.ignoreSync_yes});
        this.drawLine(new Component[]{new JLabel("Min. message size for Rendezvous [Bytes]"), this.tf_size});
        this.drawLine(new Component[]{new JLabel("Output tracefile"), this.cb_output});
        this.drawLine(new Component[]{new JLabel("Output tracefile name"), this.tf_filename});
        this.drawLine(new Component[]{new JLabel("Output tracefile type"), this.type_ascii, this.type_binary});
        this.drawLine(new Component[]{new JLabel("Output tracefile start time [s]"), this.tf_start});
        this.drawLine(new Component[]{new JLabel("Output tracefile stop time [s]"), this.tf_stop});
        this.drawButtons(new Component[]{this.b_sim, this.b_close}, 55, 5);
        this.setBounds(225, 150, this.getWidth() + 30, this.getHeight());
        this.pack();
        this.setVisible(true);
    }

    private boolean dataOK() {
        try {
            this.data.simOptions.setSimTime(this.tf_break.getText());
            this.data.simOptions.setMinSize(this.tf_size.getText());
            this.data.simOptions.setOutputFile(this.cb_output.getSelectedIndex());
            if (this.cb_output.getSelectedIndex() != 0) {
                if (this.tf_filename.getText().equalsIgnoreCase("")) {
                    Tools.showWarningMessage("Output name");
                    return false;
                }
                this.data.simOptions.setFilename(this.tf_filename.getText());
                this.data.simOptions.setStartTime(this.tf_start.getText());
                this.data.simOptions.setStopTime(this.tf_stop.getText());
                if (this.type_ascii.isSelected()) {
                    this.data.simOptions.setIsTypeAscii(true);
                } else {
                    this.data.simOptions.setIsTypeAscii(false);
                }
            }
            if (this.load_yes.isSelected()) {
                this.data.simOptions.setLoadInMemory(true);
            } else {
                this.data.simOptions.setLoadInMemory(false);
            }
            if (this.ignoreSync_yes.isSelected()) {
                this.data.simOptions.setIgnoreSend(true);
            } else {
                this.data.simOptions.setIgnoreSend(false);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.b_sim) {
            if (this.dataOK()) {
                this.b_sim.setEnabled(false);
                File file = new File("conf0000.tmp");
                this.data.saveToDisk("conf0000.tmp");
                String string = this.data.simOptions.generateCommand(file.getAbsolutePath());
                JFrame jFrame = new JFrame("Work in progress");
                Container container = jFrame.getContentPane();
                container.setLayout(new BorderLayout());
                container.add((Component)new JLabel("Please wait."), "Center");
                jFrame.setContentPane(container);
                jFrame.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("resources/dimemas_icon.png")));
                jFrame.setResizable(false);
                jFrame.setBounds(375, 275, jFrame.getWidth() + 80, jFrame.getHeight() + 25);
                jFrame.pack();
                jFrame.setVisible(true);
                try {
                    Runtime runtime = Runtime.getRuntime();
                    Process process = runtime.exec(string);
                    Stream stream = new Stream(process.getErrorStream(), "Error", this.data);
                    Stream stream2 = new Stream(process.getInputStream(), "Simulation results", this.data);
                    stream.start();
                    stream2.start();
                    process.waitFor();
                }
                catch (Throwable throwable) {
                    Tools.showInformationMessage(throwable.toString());
                }
                file.delete();
                jFrame.dispose();
                this.b_sim.setEnabled(true);
            }
        } else if (actionEvent.getSource() == this.b_close) {
            if (this.dataOK()) {
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.cb_output) {
            if (this.cb_output.getSelectedIndex() == 0) {
                this.type_ascii.setEnabled(false);
                this.type_binary.setEnabled(false);
                this.tf_filename.setEditable(false);
                this.tf_start.setEditable(false);
                this.tf_stop.setEditable(false);
            } else {
                this.type_ascii.setEnabled(true);
                this.type_binary.setEnabled(true);
                this.tf_filename.setEditable(true);
                this.tf_start.setEditable(true);
                this.tf_stop.setEditable(true);
            }
        }
    }

    class Stream
    extends Thread {
        private String type;
        private InputStream in;

        Stream(InputStream inputStream, String string, Data data) {
            this.in = inputStream;
            this.type = string;
        }

        @Override
        public void run() {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.in));
                ResultsWindow resultsWindow = new ResultsWindow(SimulatorCallWindow.this.data, this.type);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    resultsWindow.writeLine(string);
                }
                if (!resultsWindow.empty()) {
                    resultsWindow.setVisible(true);
                } else {
                    resultsWindow.dispose();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

