/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Data;
import data.EnvironmentData;
import data.WideAreaNetworkData;
import gui.GUIWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tools.Tools;

public class WideAreaNetworkWindow
extends GUIWindow {
    public static final long serialVersionUID = 17L;
    private JRadioButton commLin;
    private JRadioButton commLog;
    private JRadioButton commCt;
    private ButtonGroup commGroup = this.createGroup(true);
    private JRadioButton trafficExp;
    private JRadioButton trafficLin;
    private JRadioButton trafficLog;
    private JRadioButton trafficCt;
    private ButtonGroup trafficGroup = this.createGroup(false);
    private JComboBox cb_bandwidth = this.createComboBox(false);
    private JTextField tf_name = new JTextField(10);
    private JTextField tf_machines = new JTextField(21);
    private JTextField tf_connections = new JTextField(21);
    private JTextField tf_max = new JTextField(21);
    private JTextField tf_bandwidth = new JTextField(10);
    private JButton b_save = this.createButton("Save");
    private JButton b_close = this.createButton("Close");

    private JComboBox createComboBox(boolean bl) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Edit");
        if (!bl) {
            jComboBox.addItem("1");
            jComboBox.addItem("0.1");
            jComboBox.addItem("0.01");
            jComboBox.addItem("0.001");
            jComboBox.addItem("0.0001");
        }
        jComboBox.addActionListener(this);
        return jComboBox;
    }

    private ButtonGroup createGroup(boolean bl) {
        ButtonGroup buttonGroup = new ButtonGroup();
        if (bl) {
            this.commLog = new JRadioButton("LOG");
            this.commLin = new JRadioButton("LIN");
            this.commCt = new JRadioButton("CT");
            buttonGroup.add(this.commLog);
            buttonGroup.add(this.commLin);
            buttonGroup.add(this.commCt);
        } else {
            this.trafficExp = new JRadioButton("EXP");
            this.trafficLog = new JRadioButton("LOG");
            this.trafficLin = new JRadioButton("LIN");
            this.trafficCt = new JRadioButton("CT");
            buttonGroup.add(this.trafficExp);
            buttonGroup.add(this.trafficLog);
            buttonGroup.add(this.trafficLin);
            buttonGroup.add(this.trafficCt);
        }
        return buttonGroup;
    }

    public WideAreaNetworkWindow(Data data) {
        super(data);
        this.setTitle("Wide area network information");
        this.tf_name.setText(this.data.wan.getName(false));
        this.tf_machines.setText(this.data.wan.getMachines());
        this.tf_connections.setText(this.data.wan.getDedicated());
        this.tf_max.setText(this.data.wan.getMax());
        this.tf_bandwidth.setText(this.data.wan.getBandwidth());
        switch (Integer.parseInt(this.data.wan.getCommunication())) {
            case 1: {
                this.commCt.setSelected(true);
                break;
            }
            case 2: {
                this.commLin.setSelected(true);
                break;
            }
            case 3: {
                this.commLog.setSelected(true);
            }
        }
        switch (Integer.parseInt(this.data.wan.getTraffic())) {
            case 1: {
                this.trafficExp.setSelected(true);
                break;
            }
            case 2: {
                this.trafficLog.setSelected(true);
                break;
            }
            case 3: {
                this.trafficLin.setSelected(true);
                break;
            }
            case 4: {
                this.trafficCt.setSelected(true);
            }
        }
        this.drawLine(new Component[]{new JLabel("Number of machines"), this.tf_machines});
        this.drawLine(new Component[]{new JLabel("Number of dedicated connections"), this.tf_connections});
        this.drawLine(new Component[]{new JLabel("Function of traffic"), this.trafficExp, this.trafficLog, this.trafficLin, this.trafficCt});
        this.drawLine(new Component[]{new JLabel("Max traffic value"), this.tf_max});
        this.drawLine(new Component[]{new JLabel("External net bandwidth [MByte/s]"), this.cb_bandwidth, this.tf_bandwidth});
        this.drawLine(new Component[]{new JLabel("Communication group model"), this.commLog, this.commLin, this.commCt});
        this.drawButtons(new Component[]{this.b_save, this.b_close}, 70, 5);
        this.setBounds(25, 150, this.getWidth() + 25, this.getHeight());
        this.pack();
        this.setVisible(true);
    }

    private boolean dataOK() {
        int n;
        int n2;
        try {
            n2 = Integer.parseInt(this.tf_machines.getText());
        }
        catch (Exception exception) {
            Tools.showErrorMessage("MACHINES");
            return false;
        }
        try {
            n = Integer.parseInt(this.tf_connections.getText());
        }
        catch (Exception exception) {
            Tools.showErrorMessage("DEDICATED CONNECTIONS");
            return false;
        }
        if (n >= 1 && n2 <= 1) {
            Tools.showInformationMessage("At least two machines are necessary to create dedicated connecions.");
            return false;
        }
        if (this.tf_machines.getText().equalsIgnoreCase("") || this.tf_machines.getText().equalsIgnoreCase("0")) {
            Tools.showWarningMessage("NUMBER OF MACHINES");
            return false;
        }
        if (this.tf_connections.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("DEDICATED CONNECTIONS");
            return false;
        }
        if (this.tf_max.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("MAX TRAFFIC VALUE");
            return false;
        }
        if (this.tf_bandwidth.getText().equalsIgnoreCase("")) {
            Tools.showWarningMessage("EXTERNAL BANDWIDTH");
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.b_save) {
            if (this.dataOK()) {
                try {
                    this.data.wan.setDedicated(this.tf_connections.getText());
                    this.data.wan.setMachines(this.tf_machines.getText());
                    this.data.wan.setName(this.tf_name.getText());
                    this.data.wan.setMax(this.tf_max.getText());
                    this.data.wan.setBandwidth(this.tf_bandwidth.getText());
                    if (this.trafficExp.isSelected()) {
                        WideAreaNetworkData wideAreaNetworkData = this.data.wan;
                        Objects.requireNonNull(this.data.wan);
                        wideAreaNetworkData.setTraffic("1");
                    } else if (this.trafficLog.isSelected()) {
                        WideAreaNetworkData wideAreaNetworkData = this.data.wan;
                        Objects.requireNonNull(this.data.wan);
                        wideAreaNetworkData.setTraffic("2");
                    } else if (this.trafficLin.isSelected()) {
                        WideAreaNetworkData wideAreaNetworkData = this.data.wan;
                        Objects.requireNonNull(this.data.wan);
                        wideAreaNetworkData.setTraffic("3");
                    } else if (this.trafficCt.isSelected()) {
                        WideAreaNetworkData wideAreaNetworkData = this.data.wan;
                        Objects.requireNonNull(this.data.wan);
                        wideAreaNetworkData.setTraffic("4");
                    }
                    if (this.commLog.isSelected()) {
                        WideAreaNetworkData wideAreaNetworkData = this.data.wan;
                        Objects.requireNonNull(this.data.wan);
                        wideAreaNetworkData.setCommunication("3");
                    } else if (this.commLin.isSelected()) {
                        WideAreaNetworkData wideAreaNetworkData = this.data.wan;
                        Objects.requireNonNull(this.data.wan);
                        wideAreaNetworkData.setCommunication("2");
                    } else if (this.commCt.isSelected()) {
                        WideAreaNetworkData wideAreaNetworkData = this.data.wan;
                        Objects.requireNonNull(this.data.wan);
                        wideAreaNetworkData.setCommunication("1");
                    }
                    int n = this.data.dedicated.getNumberOfConnections();
                    int n2 = Integer.parseInt(this.tf_connections.getText());
                    if (n2 != n) {
                        this.data.dedicated.setNumberOfConnections(n2);
                        this.data.dedicated.changeAtConnections();
                    }
                    int n3 = this.data.environment.getNumberOfMachines();
                    int n4 = Integer.parseInt(this.tf_machines.getText());
                    if (n4 != n3) {
                        this.data.environment.setNumberOfMachines(n4);
                        this.data.environment.changeAtMachines();
                    }
                    for (int i = this.data.environment.getNumberOfMachines() - 1; i >= 0; --i) {
                        EnvironmentData.Machine machine = this.data.environment.machine[i];
                        Objects.requireNonNull(this.data.environment);
                        machine.setArchitecture("");
                        this.data.environment.machine[i].setBuses(this.data.environment.DEFAULT_BUSES);
                    }
                    this.dispose();
                }
                catch (Exception exception) {}
            }
        } else if (actionEvent.getSource() == this.b_close) {
            this.dispose();
        } else if (actionEvent.getSource() == this.cb_bandwidth) {
            if (this.cb_bandwidth.getSelectedIndex() != 0) {
                this.tf_bandwidth.setText((String)this.cb_bandwidth.getSelectedItem());
            } else {
                Objects.requireNonNull(this.data.wan);
                this.tf_bandwidth.setText("0.0");
            }
        }
    }
}

