/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public class Tools {
    public static JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));

    public static boolean showConfirmationMessage(String string) {
        int n = JOptionPane.showConfirmDialog(null, string, "Confirmation", 2);
        return n == 0;
    }

    public static void showErrorMessage(String string) {
        JOptionPane.showMessageDialog(null, "Wrong value at " + string + ".", "Error", 0);
    }

    public static void showErrorDialog(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    public static void showWarningMessage(String string) {
        JOptionPane.showMessageDialog(null, string + " is not set.", "Warning", 2);
    }

    public static void showInformationMessage(String string) {
        JOptionPane.showMessageDialog(null, string, "Information", 1);
    }

    public static int verifyData(String string, String string2) {
        if (string.startsWith(",")) {
            string = string.substring(1);
            return Tools.verifyData(string, string2);
        }
        if (string.endsWith(",")) {
            string = string.substring(0, string.length() - 1);
            return Tools.verifyData(string, string2);
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.indexOf(",", n2);
        try {
            while (n3 != -1) {
                Integer.parseInt(Tools.blanks(string.substring(n2, n3)));
                ++n;
                n2 = n3 + 1;
                n3 = string.indexOf(",", n2);
            }
            Integer.parseInt(Tools.blanks(string.substring(n2)));
            return ++n;
        }
        catch (NumberFormatException numberFormatException) {
            Tools.showErrorMessage(string2);
            return -1;
        }
    }

    public static String blanks(String string) {
        if (string.startsWith(" ") || string.startsWith("\t")) {
            return Tools.blanks(string.substring(1));
        }
        if (string.endsWith(" ") || string.endsWith("\t")) {
            return Tools.blanks(string.substring(0, string.length() - 1));
        }
        return string;
    }

    public static String filterForDouble(String object) {
        if (((String)object).endsWith("d") || ((String)object).endsWith("f")) {
            object = ((String)object).substring(0, ((String)object).length() - 2);
        }
        if (((String)object).indexOf(".") == -1) {
            object = (String)object + ".0";
        } else {
            if (((String)object).startsWith(".")) {
                object = "0" + (String)object;
            }
            if (((String)object).endsWith(".")) {
                object = (String)object + "0";
            }
        }
        return object;
    }

    public static int mpiValue(int n, String string) {
        if (n == 0 || n == 2) {
            if (string.equalsIgnoreCase("0")) {
                return 1;
            }
            if (string.equalsIgnoreCase("LOG")) {
                return 2;
            }
            if (string.equalsIgnoreCase("LIN")) {
                return 3;
            }
            if (string.equalsIgnoreCase("CTE")) {
                return 4;
            }
        } else {
            if (string.equalsIgnoreCase("MIN")) {
                return 1;
            }
            if (string.equalsIgnoreCase("MAX")) {
                return 2;
            }
            if (string.equalsIgnoreCase("MEAN")) {
                return 3;
            }
            if (string.equalsIgnoreCase("2MAX")) {
                return 4;
            }
            if (string.equalsIgnoreCase("S+R")) {
                return 5;
            }
        }
        return 0;
    }

    public static String mpiString(int n, int n2) {
        if (n == 0 || n == 2) {
            if (n2 == 1) {
                return "0";
            }
            if (n2 == 2) {
                return "LOG";
            }
            if (n2 == 3) {
                return "LIN";
            }
            if (n2 == 4) {
                return "CTE";
            }
            return "0";
        }
        if (n2 == 1) {
            return "MIN";
        }
        if (n2 == 2) {
            return "MAX";
        }
        if (n2 == 3) {
            return "MEAN";
        }
        if (n2 == 4) {
            return "2MAX";
        }
        if (n2 == 5) {
            return "S+R";
        }
        return "MAX";
    }

    public static class DIMfilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return FilenameUtils.getExtension((String)file.getPath()).equals("dim");
        }

        @Override
        public String getDescription() {
            return "DIM files (*.dim)";
        }
    }

    public static class OPTfilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return FilenameUtils.getExtension((String)file.getPath()).equals("opt");
        }

        @Override
        public String getDescription() {
            return "OPT files (*.opt)";
        }
    }

    public static class OUTfilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return FilenameUtils.getExtension((String)file.getPath()).equals("out");
        }

        @Override
        public String getDescription() {
            return "OUT files (*.out)";
        }
    }

    public static class CFGfilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return FilenameUtils.getExtension((String)file.getPath()).equals("cfg");
        }

        @Override
        public String getDescription() {
            return "CFG files (*.cfg)";
        }
    }
}

