/*****************************************************************************\
 *                        ANALYSIS PERFORMANCE TOOLS                         *
 *                               Dimemas GUI                                 *
 *                  GUI for the Dimemas simulation tool                      *
 *                                                                           *
 *****************************************************************************
 *     ___     This library is free software; you can redistribute it and/or *
 *    /  __         modify it under the terms of the GNU LGPL as published   *
 *   /  /  _____    by the Free Software Foundation; either version 2.1      *
 *  /  /  /     \   of the License, or (at your option) any later version.   *
 * (  (  ( B S C )                                                           *
 *  \  \  \_____/   This library is distributed in hope that it will be      *
 *   \  \__         useful but WITHOUT ANY WARRANTY; without even the        *
 *    \___          implied warranty of MERCHANTABILITY or FITNESS FOR A     *
 *                  PARTICULAR PURPOSE. See the GNU LGPL for more details.   *
 *                                                                           *
 * You should have received a copy of the GNU Lesser General Public License  *
 * along with this library; if not, write to the Free Software Foundation,   *
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA          *
 * The GNU LEsser General Public License is contained in the file COPYING.   *
 *                                 ---------                                 *
 *   Barcelona Supercomputing Center - Centro Nacional de Supercomputacion   *
\*****************************************************************************/

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- *\

  $URL::              $:  File
  $Rev::              $:  Revision of last commit
  $Author::           $:  Author of last commit
  $Date::             $:  Date of last commit

\* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */

package gui;

import data.Data;
import data.MappingData;
import tools.Tools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JToggleButton;

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 *
 * @author jgonzale
 */
public class GridMappingWindow extends GUIWindow {
  
  public static final long serialVersionUID = 10L;
  
  private JToggleButton mapButtons[][];
  private int[]         currentMap;
  private int           currentMapInfo;
  private int           nTasksPerNode;
  
  /**
   * Creates new form GridMappingWindow
   */
  public GridMappingWindow(Data d) {
    super(d);
    initComponents();
    generateGridButtons();
    
    currentMap     = data.map.getMap();
    currentMapInfo = data.map.getMapInfo();
    nTasksPerNode  = data.map.getNTasksPerNode();
    
    setState();
    pack();
    setVisible(true);
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        bg_predefinedMaps = new javax.swing.ButtonGroup();
        p_gridButtons = new javax.swing.JScrollPane();
        p_buttons = new javax.swing.JPanel();
        l_tasks = new javax.swing.JLabel();
        l_machine = new javax.swing.JLabel();
        l_nodes = new javax.swing.JLabel();
        p_predefinedMaps = new javax.swing.JPanel();
        rb_fillNodes = new javax.swing.JRadioButton();
        rb_nTasksPerNode = new javax.swing.JRadioButton();
        tf_nTasksPerNode = new javax.swing.JTextField();
        rb_interleaved = new javax.swing.JRadioButton();
        rb_irregularMap = new javax.swing.JRadioButton();
        b_save = new javax.swing.JButton();
        b_close = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Applications Tasks Map");
        setMaximumSize(new java.awt.Dimension(674, 564));
        setMinimumSize(new java.awt.Dimension(674, 564));
        setResizable(false);

        p_gridButtons.setMaximumSize(new java.awt.Dimension(579, 400));
        p_gridButtons.setMinimumSize(new java.awt.Dimension(579, 400));

        javax.swing.GroupLayout p_buttonsLayout = new javax.swing.GroupLayout(p_buttons);
        p_buttons.setLayout(p_buttonsLayout);
        p_buttonsLayout.setHorizontalGroup(
            p_buttonsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 577, Short.MAX_VALUE)
        );
        p_buttonsLayout.setVerticalGroup(
            p_buttonsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 398, Short.MAX_VALUE)
        );

        p_gridButtons.setViewportView(p_buttons);

        l_tasks.setText("Application Tasks");

        l_machine.setText("Machine");

        l_nodes.setText("Nodes");

        p_predefinedMaps.setBorder(javax.swing.BorderFactory.createTitledBorder("Predefined Maps"));

        bg_predefinedMaps.add(rb_fillNodes);
        rb_fillNodes.setText("Fill Nodes");
        rb_fillNodes.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rb_fillNodesActionPerformed(evt);
            }
        });

        bg_predefinedMaps.add(rb_nTasksPerNode);
        rb_nTasksPerNode.setFont(rb_nTasksPerNode.getFont());
        rb_nTasksPerNode.setText("'n' tasks per node");
        rb_nTasksPerNode.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rb_nTasksPerNodeActionPerformed(evt);
            }
        });

        tf_nTasksPerNode.setColumns(2);
        tf_nTasksPerNode.setFont(tf_nTasksPerNode.getFont());
        tf_nTasksPerNode.setText("1");
        tf_nTasksPerNode.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tf_nTasksPerNodeActionPerformed(evt);
            }
        });

        bg_predefinedMaps.add(rb_interleaved);
        rb_interleaved.setFont(rb_interleaved.getFont());
        rb_interleaved.setText("Interleaved");
        rb_interleaved.setToolTipText("One tasks is assigned to each node in a cyclic way");
        rb_interleaved.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rb_interleavedActionPerformed(evt);
            }
        });

        bg_predefinedMaps.add(rb_irregularMap);
        rb_irregularMap.setText("Irregular map");
        rb_irregularMap.setToolTipText("Map modified manually, not selectable");
        rb_irregularMap.setEnabled(false);

        javax.swing.GroupLayout p_predefinedMapsLayout = new javax.swing.GroupLayout(p_predefinedMaps);
        p_predefinedMaps.setLayout(p_predefinedMapsLayout);
        p_predefinedMapsLayout.setHorizontalGroup(
            p_predefinedMapsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(p_predefinedMapsLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(rb_fillNodes)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(rb_nTasksPerNode)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(tf_nTasksPerNode, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(rb_interleaved)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(rb_irregularMap)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        p_predefinedMapsLayout.setVerticalGroup(
            p_predefinedMapsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(p_predefinedMapsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(p_predefinedMapsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(p_predefinedMapsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(rb_nTasksPerNode)
                        .addComponent(tf_nTasksPerNode, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(rb_interleaved)
                        .addComponent(rb_irregularMap))
                    .addComponent(rb_fillNodes))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        b_save.setText("Save");
        b_save.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                b_saveActionPerformed(evt);
            }
        });

        b_close.setText("Close");
        b_close.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                b_closeActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(l_machine)
                    .addComponent(l_nodes))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(b_save, javax.swing.GroupLayout.PREFERRED_SIZE, 162, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(b_close, javax.swing.GroupLayout.PREFERRED_SIZE, 162, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(p_predefinedMaps, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(l_tasks)
                    .addComponent(p_gridButtons, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(l_tasks)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(l_machine)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(l_nodes))
                    .addComponent(p_gridButtons, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(p_predefinedMaps, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(b_save)
                    .addComponent(b_close))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

  private void generateGridButtons()
  {
    
    // JLabel mapButtons[][];
    
    int nTasks, nNodes;
    
    nTasks = data.map.getTasks();
    nNodes = data.nodes_information.getNumberOfNodes();
    // GridBagLayout GBL      = new GridBagLayout();
    // GridBagConstraints GBC = new GridBagConstraints();
    // p_buttons.setLayout(GBL);
    p_buttons.setLayout(new GridLayout(nNodes+2, nTasks+2, 0, 0));
    // p_buttons.setLayout(null);
    
    
    
    // System.out.println("Number of Tasks = "+nTasks);
    // System.out.println("Number of Nodes = "+nNodes);
    
    mapButtons = new JToggleButton[nNodes][nTasks];
    //mapButtons = new JLabel[nTasks][nNodes];

    for (int row = 0; row < nNodes+2; row++)
    {
      for (int col = 0; col < nTasks+2; col++)
      {
        // GBC.gridx = col;
        // GBC.gridy = row;
        
        if (row == 0 || row == nNodes+1)
        {
          JLabel columnLabel;
          
          if (col == 0 || col == nTasks+1)
          {
            columnLabel = new JLabel("");
          }
          else
          {
            columnLabel = new JLabel(String.valueOf(col));
          }
          p_buttons.add(columnLabel);
        }
        else
        {
          if (col == 0 || col == nTasks+1)
          {
            JLabel rowLabel = new JLabel(String.valueOf(row));
            p_buttons.add(rowLabel);
          }
          else
          {
            mapButtons[row-1][col-1] = new JToggleButton();
            // mapButtons[i][j] = new JLabel("Button "+i+" "+j);
            // mapButtons[i][j].setVisible(true);
            // mapButtons[row][col].setBounds(20*row, 20*col+40,20, 20);
            mapButtons[row-1][col-1].setPreferredSize(new Dimension(20,20));
            mapButtons[row-1][col-1].setMinimumSize(new Dimension(20,20));
            mapButtons[row-1][col-1].setMaximumSize(new Dimension(20,20));
            mapButtons[row-1][col-1].setBackground(Color.gray);

            // GBL.setConstraints(mapButtons[row][col], GBC);

            // ("Button Row = "+row+" Col = "+col);
            
            mapButtons[row-1][col-1].addActionListener(
              new ActionListener()
              {
                public void actionPerformed(ActionEvent e)
                {
                  int nTasks = data.map.getTasks();
                  int nNodes = data.nodes_information.getNumberOfNodes();
                  
                  for(int row = 0; row < nNodes; row++)
                  {
                    for(int col = 0; col < nTasks; col++)
                    {
                      if(e.getSource() == mapButtons[row][col])
                      {
                        buttonPushed(row,col);
                      }
                    }
                  }
                }
              }
            );

            p_buttons.add(mapButtons[row-1][col-1]);
          }
        }
      }
    }

    p_gridButtons.setPreferredSize(new Dimension(577,400));
    p_gridButtons.repaint();
    // p_gridButtons.revalidate();
    return;
  }
  
  private void rb_nTasksPerNodeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rb_nTasksPerNodeActionPerformed

    MappingData.MapResult result = data.map.new MapResult();

    // System.out.println("'n' Tasks per Node Selected");
    try
    {
      nTasksPerNode = Integer.parseInt(tf_nTasksPerNode.getText());
    }
    catch (NumberFormatException e)
    {
      Tools.showErrorMessage("Wrong tasks per node value");
      return;
    }

    result = data.map.mapNTasksPerNode(nTasksPerNode);
    
    if (result.errorMessage != null)
    {
      Tools.showErrorMessage(result.errorMessage);
    }
    
    currentMap     = result.generatedMap;
    currentMapInfo = Data.N_TASKS_PER_NODE_MAP;  
    setState();
  }//GEN-LAST:event_rb_nTasksPerNodeActionPerformed

  private void tf_nTasksPerNodeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tf_nTasksPerNodeActionPerformed
    MappingData.MapResult result = data.map.new MapResult();

    // System.out.println("'n' Tasks per Node Selected");
    try
    {
      nTasksPerNode = Integer.parseInt(tf_nTasksPerNode.getText());
    }
    catch (NumberFormatException e)
    {
      Tools.showErrorMessage("Wrong tasks per node value");
      return;
    }

    result = data.map.mapNTasksPerNode(nTasksPerNode);
    
    if (result.errorMessage != null)
    {
      Tools.showErrorMessage(result.errorMessage);
    }

    currentMap     = result.generatedMap;
    currentMapInfo = Data.N_TASKS_PER_NODE_MAP;
    setState();
  }//GEN-LAST:event_tf_nTasksPerNodeActionPerformed

  private void rb_interleavedActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rb_interleavedActionPerformed

    MappingData.MapResult result = data.map.new MapResult();
    
    // System.out.println("Interleaved selected");
    
    result = data.map.mapInterleaved();
    
    if ( result.errorMessage != null)
    {
      Tools.showErrorDialog(result.errorMessage);
    }

    currentMap     = result.generatedMap;
    currentMapInfo = Data.INTERLEAVE_MAP;
    setState();
  }//GEN-LAST:event_rb_interleavedActionPerformed

  private void b_closeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_b_closeActionPerformed
    // TODO add your handling code here:
    closeEvent();
  }//GEN-LAST:event_b_closeActionPerformed

  private void rb_fillNodesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rb_fillNodesActionPerformed

    MappingData.MapResult result = data.map.new MapResult();
    
    // System.out.println("Fill Nodes Selected");
    
    result = data.map.mapFillingNodes();

    if (result.errorMessage != null)
    {
      Tools.showErrorMessage(result.errorMessage);
    }

    currentMap     = result.generatedMap;
    currentMapInfo = Data.FILL_NODE_MAP;
    setState();
  }//GEN-LAST:event_rb_fillNodesActionPerformed

  private void b_saveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_b_saveActionPerformed
    
    /* Check a possible value change in the text field that indicates the
       tasks per node */
    if (rb_nTasksPerNode.isSelected())
    {
      try
      {
        nTasksPerNode = Integer.parseInt(tf_nTasksPerNode.getText());
      }
      catch (NumberFormatException e)
      {
        Tools.showErrorMessage("Wrong tasks per node value");
        return;
      }
    }
    
    data.map.setMapInfo(currentMapInfo);
    data.map.setMap(currentMap);
    data.map.setNTasksPerNode(nTasksPerNode);
  }//GEN-LAST:event_b_saveActionPerformed

  private void buttonPushed(int row, int col)
  {
    MappingData.MapTest result = data.map.new MapTest();
    
    int nNodes = data.nodes_information.getNumberOfNodes();
    int nTasks = data.map.getTasks();
    
    for (int currentRow = 0; currentRow < nNodes; currentRow++)
    {
      if (currentRow != row)
      {
        mapButtons[currentRow][col].setSelected(false);
      }
      else
      {
        mapButtons[currentRow][col].setSelected(true);
      }
    }
    
    for (int currentCol = 0; currentCol < nTasks; currentCol++)
    {
      for (int currentRow = 0; currentRow < nNodes; currentRow++)
      {
        if (mapButtons[currentRow][currentCol].isSelected())
        {
          currentMap[currentCol] = currentRow;
        }
      }
    }
    
    result = data.map.detectMap(currentMap);
    
    currentMapInfo = result.mapInfo;
    nTasksPerNode  = result.nTasksPerNode;
    
    setState();
    
    return;
  }
  
  private void setState()
  {
            
    int nTasks = data.map.getTasks();
    int nNodes = data.nodes_information.getNumberOfNodes();
    
    switch(currentMapInfo)
    {
      case Data.UNKNOWN_MAP:
        rb_irregularMap.setSelected(true);
        
        clearMap();
        for (int cols = 0; cols < nTasks; cols++)
        {
          mapButtons[currentMap[cols]][cols].setSelected(true);
        }
        break;
      case Data.FILL_NODE_MAP:
        rb_fillNodes.setSelected(true);
        
        clearMap();
        for (int cols = 0; cols < nTasks; cols++)
        {
          mapButtons[currentMap[cols]][cols].setSelected(true);
        }
        break;
      case Data.N_TASKS_PER_NODE_MAP:
        rb_nTasksPerNode.setSelected(true);
        tf_nTasksPerNode.setText(String.valueOf(nTasksPerNode));
       
        clearMap();
        for (int cols = 0; cols < nTasks; cols++)
        {
          mapButtons[currentMap[cols]][cols].setSelected(true);
        }
        
        break;
      case Data.INTERLEAVE_MAP:
        rb_interleaved.setSelected(true);
      
        clearMap();
        for (int cols = 0; cols < nTasks; cols++)
        {
          mapButtons[currentMap[cols]][cols].setSelected(true);
        }
        
        break;
      default:
        // System.out.println("Unknow map "+data.map.getMapInfo());
        break;
    }
  }
  
  private void clearMap()
  {
    int nTasks = data.map.getTasks();
    int nNodes = data.nodes_information.getNumberOfNodes();
    
    for (int rows = 0; rows < nNodes; rows++)
    {
      for (int cols = 0; cols < nTasks; cols++)
      {
        mapButtons[rows][cols].setSelected(false);
      }
    }
    return;
  }
  
  private void closeEvent()
  {
    // System.out.println("Closing event!");
    if (data.map.getMapInfo() == Data.NO_MAP)
    {
      Tools.showWarningMessage("Please select a map before closing");
      this.setVisible(true);
    }
    else
    {
      dispose();
    }
  }
 

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton b_close;
    private javax.swing.JButton b_save;
    private javax.swing.ButtonGroup bg_predefinedMaps;
    private javax.swing.JLabel l_machine;
    private javax.swing.JLabel l_nodes;
    private javax.swing.JLabel l_tasks;
    private javax.swing.JPanel p_buttons;
    private javax.swing.JScrollPane p_gridButtons;
    private javax.swing.JPanel p_predefinedMaps;
    private javax.swing.JRadioButton rb_fillNodes;
    private javax.swing.JRadioButton rb_interleaved;
    private javax.swing.JRadioButton rb_irregularMap;
    private javax.swing.JRadioButton rb_nTasksPerNode;
    private javax.swing.JTextField tf_nTasksPerNode;
    // End of variables declaration//GEN-END:variables
}
