/*****************************************************************************\
 *                        ANALYSIS PERFORMANCE TOOLS                         *
 *                                   Extrae                                  *
 *              Instrumentation package for parallel applications            *
 *****************************************************************************
 *     ___     This library is free software; you can redistribute it and/or *
 *    /  __         modify it under the terms of the GNU LGPL as published   *
 *   /  /  _____    by the Free Software Foundation; either version 2.1      *
 *  /  /  /     \   of the License, or (at your option) any later version.   *
 * (  (  ( B S C )                                                           *
 *  \  \  \_____/   This library is distributed in hope that it will be      *
 *   \  \__         useful but WITHOUT ANY WARRANTY; without even the        *
 *    \___          implied warranty of MERCHANTABILITY or FITNESS FOR A     *
 *                  PARTICULAR PURPOSE. See the GNU LGPL for more details.   *
 *                                                                           *
 * You should have received a copy of the GNU Lesser General Public License  *
 * along with this library; if not, write to the Free Software Foundation,   *
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA          *
 * The GNU LEsser General Public License is contained in the file COPYING.   *
 *                                 ---------                                 *
 *   Barcelona Supercomputing Center - Centro Nacional de Supercomputacion   *
\*****************************************************************************/

#ifndef __EVENTS_H_INCLUDED__
#define __EVENTS_H_INCLUDED__

#include "openshmem_events.h"
#include "new_openmp_events.h"

#ifdef __cplusplus
extern "C" {
#endif
unsigned IsMPI (unsigned EvType);
unsigned IsOpenMP (unsigned EvType);
unsigned IsMISC (unsigned EvType);

unsigned IsBurst (unsigned EvType);
unsigned IsHwcChange (unsigned EvType);
unsigned IsMPICollective (unsigned EvType);
unsigned IsOPENACC(unsigned);
#ifdef __cplusplus
}
#endif


#define EMPTY            ( 0)
#define NO_COUNTER       (-1)
#define SAMPLE_COUNTER   (-2)

#define MAX_CALLERS      100

/******************************************************************************
 *   General user events to trace the application.
 ******************************************************************************/

#define NULL_EV -1

/* Values */
#define EVT_BEGIN                1
#define EVT_END                  0

/* Trace options, just do a bitwise or/and with these values */
#define TRACEOPTION_NONE            (0)
#define TRACEOPTION_HWC             (1<<0)
#define TRACEOPTION_CIRCULAR_BUFFER (1<<1)
/* Useless #define TRACEOPTION_BURSTS          (1<<2) */
#define TRACEOPTION_BIGENDIAN       (1<<3)
#define TRACEOPTION_PARAVER         (1<<4)
#define TRACEOPTION_DIMEMAS         (1<<5)

/* These trace options are intended to 'catch' special architectures */
#define TRACEOPTION_UNK_ARCH        (1<<10) /* Unknown */
#define TRACEOPTION_MN_ARCH         (1<<11) /* MareNostrum */
#define TRACEOPTION_BG_ARCH         (1<<12) /* BlueGene / {PL} */

#define SYNCHRONIZATION_POINT_EV     1000
#define OPTIONS_EV                   1001

#define SAMPLING_EV              30000000
#define SAMPLING_LINE_EV         30000100
#define SAMPLING_CALLER_OFFSET     100000
#define HWC_SET_OVERFLOW_EV      31000000
#define SAMPLING_ADDRESS_LD_EV               32000000
#define SAMPLING_ADDRESS_ST_EV               32000001
#define SAMPLING_ADDRESS_MEM_LEVEL_EV        32000002
#define SAMPLING_ADDRESS_MEM_HITORMISS_EV    32000003
#define SAMPLING_ADDRESS_TLB_LEVEL_EV        32000004
#define SAMPLING_ADDRESS_TLB_HITORMISS_EV    32000005
#define SAMPLING_ADDRESS_REFERENCE_COST_EV   32000006
#define SAMPLING_ADDRESS_ALLOCATED_OBJECT_EV 32000007
#define SAMPLING_ADDRESS_ALLOCATED_OBJECT_ALLOC_EV 32000009
#define SAMPLING_ADDRESS_STATIC_OBJECT_EV    32000008
#define SAMPLING_ADDRESS_L3_STORE_MISSES_EV  32000010
#define SAMPLING_ADDRESS_ALLOCATED_OBJECT_CALLER_EV 32000100 /* internal purposes, not emitted into paraver tracefile */

#define SYSCALL_EV               40000000

enum {
  SYSCALL_SCHED_YIELD_EV,
	SYSCALL_EVENTS_COUNT
};

#define APPL_EV                  40000001
#define TRACE_INIT_EV            40000002
#define FLUSH_EV                 40000003
#define READ_EV                  40000004
#define IO_EV                    READ_EV  /* Used in merger */
#define WRITE_EV                 40000005
#define READ_VAL_EV                     1 /* Used in merger, with IO_EV */
#define WRITE_VAL_EV                    2 /* Used in merger, with IO_EV */
#define FREAD_VAL_EV                    3 /* Used in merger, with IO_EV */
#define FWRITE_VAL_EV                   4 /* Used in merger, with IO_EV */
#define PREAD_VAL_EV                    5 /* Used in merger, with IO_EV */
#define PWRITE_VAL_EV                   6 /* Used in merger, with IO_EV */
#define READV_VAL_EV                    7 /* Used in merger, with IO_EV */
#define WRITEV_VAL_EV                   8 /* Used in merger, with IO_EV */
#define PREADV_VAL_EV                   9 /* Used in merger, with IO_EV */
#define PWRITEV_VAL_EV                 10 /* Used in merger, with IO_EV */
#define OPEN_VAL_EV                    11 /* Used in merger, with IO_EV */
#define FOPEN_VAL_EV                   12 /* Used in merger, with IO_EV */
#define IOCTL_VAL_EV                   13 /* Used in merger, with IO_EV */
#define CLOSE_VAL_EV                   14 /* Used in merger, with IO_EV */
#define FCLOSE_VAL_EV                  15 /* Used in merger, with IO_EV */
#define USER_EV                  40000006
#define HWC_DEF_EV               40000007
#define HWC_CHANGE_EV            40000008
#define HWC_EV                   40000009
#define IO_DESCRIPTOR_EV         40000010
#define IO_SIZE_EV               40000011
#define IO_DESCRIPTOR_TYPE_EV    40000013
#define TRACING_EV               40000012
#define SET_TRACE_EV             40000014
#define CPU_BURST_EV             40000015
#define RUSAGE_EV                40000016
#define TRACING_MODE_EV          40000018
#define MEMUSAGE_EV              40000020
#define USER_SEND_EV             40000021
#define USER_RECV_EV             40000022
#define RESUME_VIRTUAL_THREAD_EV 40000023
#define SUSPEND_VIRTUAL_THREAD_EV 40000024
#define REGISTER_STACKED_TYPE_EV 40000025
#define REGISTER_CODELOCATION_TYPE_EV 40000026
#define FORK_EV                  40000027
#define FORK_SYSCALL_EV          FORK_EV
#define WAIT_EV                  40000028
#define WAITPID_EV               40000029
#define WAITEDPID_EV             40000030
#define EXEC_EV                  40000031
#define EXEC_BIN_EV              40000032
#define GETCPU_EV                40000033
#define CPU_EVENT_INTERVAL_EV    40000133
#define SYSTEM_EV                40000034
#define SYSTEM_BIN_EV            40000035
#define PID_EV                   40000036
#define PPID_EV                  40000037
#define FORK_DEPTH_EV            40000038
#define LIBRARY_EV               40000039
#define MALLOC_EV                40000040
#define FREE_EV                  40000041
#define CALLOC_EV                40000042
#define REALLOC_EV               40000043
#define POSIX_MEMALIGN_EV        40000044
#define MEMKIND_MALLOC_EV         40000045
#define MEMKIND_CALLOC_EV         40000046
#define MEMKIND_REALLOC_EV        40000047
#define MEMKIND_POSIX_MEMALIGN_EV 40000048
#define MEMKIND_FREE_EV           40000049
#define ADD_RESERVED_MEM_EV       40000069
#define SUB_RESERVED_MEM_EV       40000070
#define MEMKIND_PARTITION_EV      40001000
#define KMPC_MALLOC_EV            40000062
#define KMPC_FREE_EV              40000063
#define KMPC_CALLOC_EV            40000064
#define KMPC_REALLOC_EV           40000065
#define KMPC_ALIGNED_MALLOC_EV    40000066

enum
{
  MEMKIND_PARTITION_DEFAULT_VAL = 1,
  MEMKIND_PARTITION_HBW_VAL,
  MEMKIND_PARTITION_HBW_HUGETLB_VAL,
  MEMKIND_PARTITION_HBW_PREFERRED_VAL,
  MEMKIND_PARTITION_HBW_PREFERRED_HUGETLB_VAL,
  MEMKIND_PARTITION_HUGETLB_VAL,
  MEMKIND_PARTITION_HBW_GBTLB_VAL,
  MEMKIND_PARTITION_HBW_PREFERRED_GBTLB_VAL,
  MEMKIND_PARTITION_GBTLB_VAL,
  MEMKIND_PARTITION_HBW_INTERLEAVE_VAL,
  MEMKIND_PARTITION_INTERLEAVE_VAL,
  MEMKIND_PARTITION_OTHER_VAL,
};

#define DYNAMIC_MEM_EV                     MALLOC_EV         /* Used in merger only */
#define DYNAMIC_MEM_REQUESTED_SIZE_EV      DYNAMIC_MEM_EV+1  /* Used in merger only */
#define DYNAMIC_MEM_POINTER_IN_EV          DYNAMIC_MEM_EV+2  /* Used in merger only, free input, realloc in */
#define DYNAMIC_MEM_POINTER_OUT_EV         DYNAMIC_MEM_EV+3  /* Used in merger only, malloc output, calloc output, realloc out */
#define CLOCK_FROM_SYSTEM_EV     40000050
#define FREAD_EV                 40000051
#define FWRITE_EV                40000052
#define PREAD_EV                 40000053
#define PWRITE_EV                40000054
#define READV_EV                 40000055
#define WRITEV_EV                40000056
#define PREADV_EV                40000057
#define PWRITEV_EV               40000058
#define FILE_NAME_EV             40000059
#define OPEN_EV                  40000060
#define FOPEN_EV                 40000061
#define IOCTL_EV                 40000067
#define IOCTL_REQUEST_EV         40000068
#define CLOSE_EV                 40000071
#define FCLOSE_EV                40000072

#define ADDRESSES_FOR_BINARY_EV  41000000

#define RUSAGE_BASE              45000000
enum {
   RUSAGE_UTIME_EV = 0,
   RUSAGE_STIME_EV,
   RUSAGE_MAXRSS_EV,
   RUSAGE_IXRSS_EV,
   RUSAGE_IDRSS_EV,
   RUSAGE_ISRSS_EV,
   RUSAGE_MINFLT_EV,
   RUSAGE_MAJFLT_EV,
   RUSAGE_NSWAP_EV,
   RUSAGE_INBLOCK_EV,
   RUSAGE_OUBLOCK_EV,
   RUSAGE_MSGSND_EV,
   RUSAGE_MSGRCV_EV,
   RUSAGE_NSIGNALS_EV,
   RUSAGE_NVCSW_EV,
   RUSAGE_NIVCSW_EV,
   RUSAGE_EVENTS_COUNT /* Total number of getrusage events */
};

#define MEMUSAGE_BASE			 46000000
enum {
   MEMUSAGE_ARENA_EV = 0,
   MEMUSAGE_HBLKHD_EV,
   MEMUSAGE_UORDBLKS_EV,
   MEMUSAGE_FORDBLKS_EV,
   MEMUSAGE_INUSE_EV,
   MEMUSAGE_EVENTS_COUNT /* Total number of memusage events */
};

#define JAVA_JVMTI_GARBAGECOLLECTOR_EV     48000001
#define JAVA_JVMTI_EXCEPTION_EV            48000002
#define JAVA_JVMTI_OBJECT_ALLOC_EV         48000003
#define JAVA_JVMTI_OBJECT_FREE_EV          48000004

#define OMP_STATS_BASE           65000000
enum {
	OMP_NUM_TASKS_INSTANTIATED = 0,
	OMP_NUM_TASKS_EXECUTED,
	OMP_STATS_EVENTS_COUNT
};

#define MPI_BURST_STATS_BASE           54000000

#define OMP_BURST_STATS_BASE           54000100

#define FUNCT_BASE               41000000
#define FUNCT_MAX                    1000

#define HWC_BASE_PAPI_PRESET     42000000
#define HWC_BASE_PAPI_NATIVE     44000000
#define HWC_BASE_PAPI_UNCORE     46000000
#define HWC_BASE_PMAPI           48000000

#define HWC_DELTA_ABSOLUTE        1000000 /* Add this if using absolute values */
#define HWC_GROUP_ID             41999999 /* Identifier of the active hwc set */

/******************************************************************************
 *   User events to trace several MPI functions.
 *   MUST be between 50000001 - 50999999
 ******************************************************************************/
#define MPI_MIN_EV                   MPI_INIT_EV
#define MPI_MAX_EV                   50999999

#define MPI_INIT_EV                  50000001
#define MPI_BSEND_EV                 50000002
#define MPI_SSEND_EV                 50000003
#define MPI_BARRIER_EV               50000004
#define MPI_BCAST_EV                 50000005
#define MPI_SEND_EV                  50000018
#define MPI_SENDRECV_EV              50000017
#define MPI_SENDRECV_REPLACE_EV      50000081
#define MPI_RECV_EV                  50000019
#define MPI_IBSEND_EV                50000020
#define MPI_ISSEND_EV                50000021
#define MPI_ISEND_EV                 50000022
#define MPI_IRECV_EV                 50000023
#define MPI_IRCV_EV                  50000025
#define MPI_TEST_EV                  50000026
#define MPI_TESTALL_EV               50000082
#define MPI_TESTANY_EV               50000083
#define MPI_TESTSOME_EV              50000084
#define MPI_WAIT_EV                  50000027
#define MPI_CANCEL_EV                50000030
#define MPI_RSEND_EV                 50000031
#define MPI_IRSEND_EV                50000032
#define MPI_ALLTOALL_EV              50000033
#define MPI_ALLTOALLV_EV             50000034
#define MPI_ALLREDUCE_EV             50000035
#define MPI_REDUCE_EV                50000038
#define MPI_WAITALL_EV               50000039
#define MPI_WAITANY_EV               50000068
#define MPI_WAITSOME_EV              50000069
#define MPI_IRECVED_EV               50000040
#define MPI_GATHER_EV                50000041
#define MPI_GATHERV_EV               50000042
#define MPI_SCATTER_EV               50000043
#define MPI_SCATTERV_EV              50000044
#define MPI_FINALIZE_EV              50000045
#define MPI_COMM_RANK_EV             50000046
#define MPI_COMM_SIZE_EV             50000047
#define MPI_COMM_CREATE_EV           50000048
#define MPI_COMM_DUP_EV              50000049
#define MPI_COMM_DUP_WITH_INFO_EV    50000057
#define MPI_COMM_SPLIT_EV            50000050
#define MPI_COMM_SPLIT_TYPE_EV       50000056
#define MPI_COMM_SPAWN_EV            50000054
#define MPI_COMM_SPAWN_MULTIPLE_EV   50000055
#define MPI_RANK_CREACIO_COMM_EV     50000051      /* Used to define communicators */
#define MPI_ALIAS_COMM_CREATE_EV     50000061      /* Used to define communicators */
#define MPI_ALLGATHER_EV             50000052
#define MPI_ALLGATHERV_EV            50000053
#define MPI_CART_CREATE_EV           50000058
#define MPI_CART_SUB_EV              50000059
#define MPI_CART_COORDS_EV           50000060
#define MPI_REDUCESCAT_EV            50000062
#define MPI_SCAN_EV                  50000063
#define MPI_EXSCAN_EV                50000064
#define MPI_PROBE_EV                 50000065
#define MPI_IPROBE_EV                50000066
#define MPI_COMM_FREE_EV             50000067
#define MPI_COMM_CREATE_GROUP_EV     50000080
#define MPI_MPROBE_EV                50000087
#define MPI_IMPROBE_EV               50000088
#define MPI_MRECV_EV                 50000089
#define MPI_IMRECV_EV                50000090
#define MPI_REQUEST_CANCELLED_EV     50000091

#define MPI_PERSIST_REQ_EV           50000070
#define MPI_START_EV                 50000071
#define MPI_STARTALL_EV              50000072
#define MPI_REQUEST_FREE_EV          50000073
#define MPI_RECV_INIT_EV             50000074
#define MPI_SEND_INIT_EV             50000075
#define MPI_BSEND_INIT_EV            50000076
#define MPI_RSEND_INIT_EV            50000077
#define MPI_SSEND_INIT_EV            50000078
#define MPI_REQUEST_GET_STATUS_EV    50000079
#define MPI_INTERCOMM_CREATE_EV      50000085
#define MPI_INTERCOMM_MERGE_EV       50000086

#define MPI_GLOBAL_OP_SENDSIZE       (MPI_INIT_EV+100000)
#define MPI_GLOBAL_OP_RECVSIZE       (MPI_INIT_EV+100001)
#define MPI_GLOBAL_OP_ROOT           (MPI_INIT_EV+100002)
#define MPI_GLOBAL_OP_COMM           (MPI_INIT_EV+100003)

#define MPI_FILE_OPEN_EV                  50000100
#define MPI_FILE_CLOSE_EV                 50000101
#define MPI_FILE_READ_EV                  50000102
#define MPI_FILE_READ_ALL_EV              50000103
#define MPI_FILE_WRITE_EV                 50000104
#define MPI_FILE_WRITE_ALL_EV             50000105
#define MPI_FILE_READ_AT_EV               50000106
#define MPI_FILE_READ_AT_ALL_EV           50000107
#define MPI_FILE_WRITE_AT_EV              50000108
#define MPI_FILE_WRITE_AT_ALL_EV          50000109
#define MPI_IO_SIZE_EV                    50000110
#define MPI_FILE_WRITE_ALL_BEGIN_EV       50000111
#define MPI_FILE_WRITE_ALL_END_EV         50000112
#define MPI_FILE_READ_ALL_BEGIN_EV        50000113
#define MPI_FILE_READ_ALL_END_EV          50000114
#define MPI_FILE_WRITE_AT_ALL_BEGIN_EV    50000115
#define MPI_FILE_WRITE_AT_ALL_END_EV      50000116
#define MPI_FILE_READ_AT_ALL_BEGIN_EV     50000117
#define MPI_FILE_READ_AT_ALL_END_EV       50000118
#define MPI_FILE_READ_ORDERED_EV          50000119
#define MPI_FILE_READ_ORDERED_BEGIN_EV    50000120
#define MPI_FILE_READ_ORDERED_END_EV      50000121
#define MPI_FILE_READ_SHARED_EV           50000122
#define MPI_FILE_WRITE_ORDERED_EV         50000123
#define MPI_FILE_WRITE_ORDERED_BEGIN_EV   50000124
#define MPI_FILE_WRITE_ORDERED_END_EV     50000125
#define MPI_FILE_WRITE_SHARED_EV          50000126

#define MPI_GET_EV                   50000200
#define MPI_PUT_EV                   50000201
#define MPI_WIN_CREATE_EV            50000202
#define MPI_WIN_FENCE_EV             50000203
#define MPI_WIN_START_EV             50000204
#define MPI_WIN_FREE_EV              50000205
#define MPI_WIN_POST_EV              50000206
#define MPI_WIN_COMPLETE_EV          50000207
#define MPI_WIN_WAIT_EV              50000208
#define MPI_RMA_SIZE                 50001000
#define MPI_RMA_TARGET_RANK          50001001
#define MPI_RMA_ORIGIN_ADDR          50001002
#define MPI_RMA_TARGET_DISP          50001003

#define MPI_IREDUCE_EV               50000210
#define MPI_IALLREDUCE_EV            50000211
#define MPI_IBARRIER_EV              50000212
#define MPI_IBCAST_EV                50000213
#define MPI_IALLTOALL_EV             50000214
#define MPI_IALLTOALLV_EV            50000215
#define MPI_IALLGATHER_EV            50000216
#define MPI_IALLGATHERV_EV           50000217
#define MPI_IGATHER_EV               50000218
#define MPI_IGATHERV_EV              50000219
#define MPI_ISCATTER_EV              50000220
#define MPI_ISCATTERV_EV             50000221
#define MPI_IREDUCESCAT_EV           50000222
#define MPI_ISCAN_EV                 50000223
#define MPI_REDUCE_SCATTER_BLOCK_EV  50000224
#define MPI_IREDUCE_SCATTER_BLOCK_EV 50000225
#define MPI_ALLTOALLW_EV	     50000226
#define MPI_IALLTOALLW_EV	     50000227
#define MPI_WIN_LOCK_EV              50000228
#define MPI_WIN_UNLOCK_EV	     50000229
#define MPI_GET_ACCUMULATE_EV	     50000230

#define MPI_GRAPH_CREATE_EV          50000231
#define MPI_DIST_GRAPH_CREATE_EV     50000232
#define MPI_DIST_GRAPH_CREATE_ADJACENT_EV 50000249

#define MPI_NEIGHBOR_ALLGATHER_EV    50000233
#define MPI_INEIGHBOR_ALLGATHER_EV   50000234
#define MPI_NEIGHBOR_ALLGATHERV_EV   50000235
#define MPI_INEIGHBOR_ALLGATHERV_EV  50000236
#define MPI_NEIGHBOR_ALLTOALL_EV     50000237
#define MPI_INEIGHBOR_ALLTOALL_EV    50000238
#define MPI_NEIGHBOR_ALLTOALLV_EV    50000239
#define MPI_INEIGHBOR_ALLTOALLV_EV   50000240
#define MPI_NEIGHBOR_ALLTOALLW_EV    50000241
#define MPI_INEIGHBOR_ALLTOALLW_EV   50000242

#define MPI_FETCH_AND_OP_EV          50000243
#define MPI_COMPARE_AND_SWAP_EV      50000244
#define MPI_WIN_FLUSH_EV             50000245
#define MPI_WIN_FLUSH_ALL_EV         50000246
#define MPI_WIN_FLUSH_LOCAL_EV       50000247
#define MPI_WIN_FLUSH_LOCAL_ALL_EV   50000248
#define MPI_IEXSCAN_EV               50000250

// Software counters
#define MPI_IPROBE_COUNTER_EV             50000300
#define MPI_TIME_IN_IPROBE_EV             50000301
#define MPI_REQUEST_GET_STATUS_COUNTER_EV 50000302
#define MPI_TIME_IN_REQUEST_GET_STATUS_EV 50000303
#define MPI_TEST_COUNTER_EV               50000304
#define MPI_TIME_IN_TEST_EV               50000305
#define MPI_IMPROBE_COUNTER_EV            50000306
#define MPI_TIME_IN_IMPROBE_EV            50000307

/******************************************************************************
 *   User events for BG PERSONALITY
 ******************************************************************************/
#define BG_PERSONALITY_PROCESSOR_ID 6000

#define BG_PERSONALITY_TORUS_A      6001 /* For BG/Q */
#define BG_PERSONALITY_TORUS_B      6002 /* For BG/Q */
#define BG_PERSONALITY_TORUS_C      6003 /* For BG/Q */
#define BG_PERSONALITY_TORUS_D      6004 /* For BG/Q */
#define BG_PERSONALITY_TORUS_E      6005 /* For BG/Q */

#define BG_PERSONALITY_TORUS_X      6001 /* For BG/L & BG/P */
#define BG_PERSONALITY_TORUS_Y      6002 /* For BG/L & BG/P */
#define BG_PERSONALITY_TORUS_Z      6003 /* For BG/L & BG/P */


/******************************************************************************
 *   User events to trace MN topology (grodrigu)
 ******************************************************************************/
#define MN_LINEAR_HOST_EVENT         3000
#define MN_LINECARD_EVENT            3001
#define MN_HOST_EVENT                3002

/******************************************************************************
 *   User events to trace OMP parallel execution.
 ******************************************************************************/
#define PAR_EV                   60000001
#define WSH_EV                   60000002
#define BLOCK_EV                 60000003
#define WWORK_EV                 60000004
#define BARRIEROMP_EV            60000005
#define NAMEDCRIT_EV             60000006
#define UNNAMEDCRIT_EV           60000007
#define INTLOCK_EV               60000008
#define OMPLOCK_EV               60000009
#define OVHD_EV                  60000010
#define WORK_EV                  60000011
#define ENTERGATE_EV             60000012
#define EXITGATE_EV              60000013
#define ORDBEGIN_EV              60000014 /* Not used, actually replaced by ORDERED_EV */
#define ORDEND_EV                60000015 /* Not used, actually replaced by ORDERED_EV */
#define JOIN_EV                  60000016
#define DESCMARK_EV              60000017
#define OMPFUNC_EV               60000018
#define OMPFUNC_LINE_EV          60000118
#define USRFUNC_EV               60000019
#define USRFUNC_LINE_EV          60000119
#define USRFUNC_EV_BB            60000219
#define TASK_EV                  60000021
#define TASKWAIT_EV              60000022
#define TASKFUNC_EV              60000023
#define TASKFUNC_LINE_EV         60000123
#define TASKFUNC_INST_EV         60000024 /* Task func instantiation */
#define TASKFUNC_INST_LINE_EV    60000124 /* at #pragma omp task */
#define TASKGROUP_START_EV       60000025
#define TASKGROUP_END_EV         60000026
#define TASKGROUP_INGROUP_DEEP_EV 60000027
#define TASKID_EV                60000028
#define TASKLOOP_EV              60000029
#define TASKLOOPID_EV            60010029
#define OMPSETNUMTHREADS_EV      60000030
#define OMPGETNUMTHREADS_EV      60000031
#define NAMEDCRIT_NAME_EV        60000032 /* Critical address name */
#define ORDERED_EV               60000033 /* Ordered section in ordered or doacross loop */
#define TARGET_EV                60000034
#define OMPTASKYIELD_EV          60000035
#define OMPT_CRITICAL_EV         60000050
#define OMPT_ATOMIC_EV           60000051
#define OMPT_LOOP_EV             60000052
#define OMPT_WORKSHARE_EV        60000053
#define OMPT_SECTIONS_EV         60000054
#define OMPT_SINGLE_EV           60000055
#define OMPT_MASTER_EV           60000056
#define OMPT_TASKGROUP_IN_EV     60000057
#define OMPT_DEPENDENCE_EV       60000058
#define OMPT_TASKFUNC_EV         60000059
#define OMP_STATS_EV             60000060

/******************************************************************************
 *   User events to trace Pthread parallel execution.
 ******************************************************************************/
#define PTHREAD_BASE_EV            61000000
#define PTHREAD_EXIT_EV            61000001
#define PTHREAD_CREATE_EV          61000002
#define PTHREAD_JOIN_EV            61000003
#define PTHREAD_DETACH_EV          61000004
#define PTHREAD_RWLOCK_WR_EV       61000005
#define PTHREAD_RWLOCK_RD_EV       61000006
#define PTHREAD_RWLOCK_UNLOCK_EV   61000007
#define PTHREAD_MUTEX_LOCK_EV      61000008
#define PTHREAD_MUTEX_UNLOCK_EV    61000009
#define PTHREAD_COND_SIGNAL_EV     61000010
#define PTHREAD_COND_BROADCAST_EV  61000011
#define PTHREAD_COND_WAIT_EV       61000012
#define PTHREAD_BARRIER_WAIT_EV    61000013

#define PTHREAD_FUNC_EV          60000020
#define PTHREAD_FUNC_LINE_EV     60000120

#define CUDACALL_EV               63000000
enum {
	CUDALAUNCH_VAL                 =     1,
	CUDACONFIGCALL_VAL,
	CUDAMEMCPY_VAL,
	CUDATHREADBARRIER_VAL,
	CUDASTREAMBARRIER_VAL,
	CUDASTREAMCREATE_VAL,
	CUDAMEMCPYASYNC_VAL,
	CUDADEVICERESET_VAL,
	CUDATHREADEXIT_VAL,
	CUDASTREAMDESTROY_VAL,
	CUDAMALLOC_VAL,
	CUDAMALLOCPITCH_VAL,
	CUDAFREE_VAL,
	CUDAMALLOCARRAY_VAL,
	CUDAFREEARRAY_VAL,
	CUDAMALLOCHOST_VAL,
	CUDAFREEHOST_VAL,
	CUDAHOSTALLOC_VAL,
	CUDAMEMCPY2D_VAL,               /*TBD*/
	CUDAMEMCPYTOARRAY_VAL,          /*TBD*/
	CUDAMEMCPY2DTOARRAY_VAL,        /*TBD*/
	CUDAMEMCPYFROMARRAY_VAL,        /*TBD*/
	CUDAMEMCPY2DFROMARRAY_VAL,      /*TBD*/
	CUDAMEMCPYARRAYTOARRAY_VAL,     /*TBD*/
	CUDAMEMCPYTOSYMBOL_VAL,         /*TBD*/
	CUDAMEMCPYFROMSYMBOL_VAL,       /*TBD*/
	CUDAMEMCPYTOARRAYASYNC_VAL,     /*TBD*/
	CUDAMEMCPYFROMARRAYASYNC_VAL,   /*TBD*/
	CUDAMEMCPY2DASYNC_VAL,          /*TBD*/
	CUDAMEMCPY2DTOARRAYASYNC_VAL,   /*TBD*/
	CUDAMEMCPY2DFROMARRAYASYNC_VAL, /*TBD*/
	CUDAMEMCPYTOSYMBOLASYNC_VAL,    /*TBD*/
	CUDAMEMCPYFROMSYMBOLASYNC_VAL,  /*TBD*/
	CUDAMEMSET_VAL,
	CUDAEVENTRECORD_VAL,
	CUDAEVENTSYNCHRONIZE_VAL
};

#define CUDACALLGPU_EV       63000001
enum {
	CUDAKERNEL_GPU_VAL        = 1,
	CUDACONFIGKERNEL_GPU_VAL,
	CUDAMEMCPY_GPU_VAL,
	CUDAMEMCPYASYNC_GPU_VAL   = 7,
	CUDAEVENTRECORD_GPU_VAL = 35
};

#define CUDA_UNTRACKED_EV             63000003
#define CUDA_DYNAMIC_MEM_SIZE_EV      63000004
#define CUDA_DYNAMIC_MEM_PTR_EV       63000005
#define CUDA_KERNEL_INST_EV           63000006
#define CUDA_KERNEL_INST_LINE_EV      63000007
#define CUDASTREAMBARRIER_THID_EV     63000008  /* TID of the Paraver thid of the CUDA stream being synchronized */
#define CUDA_KERNEL_EXEC_EV           63000009
#define CUDA_KERNEL_EXEC_LINE_EV      63000010
#define CUDA_KERNEL_BLOCKS_PER_GRID   63000011
#define CUDA_KERNEL_THREADS_PER_BLOCK 63000012
#define CUDA_KERNEL_SHARED_MEM_BYTES  63000013
#define CUDA_MEMORY_TRANSFER          63000014

#define OPENCL_KERNEL_NAME_EV                         64200000
#define OPENCL_BASE_TYPE_EV                           64000000
#define OPENCL_BASE_TYPE_ACC_EV                       64100000
#define OPENCL_CLCREATEBUFFER_EV                      64000001
#define OPENCL_CLCREATECOMMANDQUEUE_EV                64000002
#define OPENCL_CLCREATECONTEXT_EV                     64000003
#define OPENCL_CLCREATECONTEXTFROMTYPE_EV             64000004
#define OPENCL_CLCREATESUBBUFFER_EV                   64000005
#define OPENCL_CLCREATEKERNEL_EV                      64000006
#define OPENCL_CLCREATEKERNELSINPROGRAM_EV            64000007
#define OPENCL_CLSETKERNELARG_EV                      64000008
#define OPENCL_CLCREATEPROGRAMWITHSOURCE_EV           64000009
#define OPENCL_CLCREATEPROGRAMWITHBINARY_EV           64000010
#define OPENCL_CLCREATEPROGRAMWITHBUILTINKERNELS_EV   64000011
#define OPENCL_CLENQUEUEFILLBUFFER_EV                 64000012
#define OPENCL_CLENQUEUECOPYBUFFER_EV                 64000013
#define OPENCL_CLENQUEUECOPYBUFFERRECT_EV             64000014
#define OPENCL_CLENQUEUENDRANGEKERNEL_EV              64000015
#define OPENCL_CLENQUEUETASK_EV                       64000016
#define OPENCL_CLENQUEUENATIVEKERNEL_EV               64000017
#define OPENCL_CLENQUEUEREADBUFFER_EV                 64000018
#define OPENCL_CLENQUEUEREADBUFFERRECT_EV             64000019
#define OPENCL_CLENQUEUEWRITEBUFFER_EV                64000020
#define OPENCL_CLENQUEUEWRITEBUFFERRECT_EV            64000021
#define OPENCL_CLBUILDPROGRAM_EV                      64000022
#define OPENCL_CLCOMPILEPROGRAM_EV                    64000023
#define OPENCL_CLLINKPROGRAM_EV                       64000024
#define OPENCL_CLFINISH_EV                            64000025
#define OPENCL_CLFLUSH_EV                             64000026
#define OPENCL_CLWAITFOREVENTS_EV                     64000027
#define OPENCL_CLENQUEUEMARKERWITHWAITLIST_EV         64000028
#define OPENCL_CLENQUEUEBARRIERWITHWAITLIST_EV        64000029
#define OPENCL_CLENQUEUEMAPBUFFER_EV                  64000030
#define OPENCL_CLENQUEUEUNMAPMEMOBJECT_EV             64000031
#define OPENCL_CLENQUEUEMIGRATEMEMOBJECTS_EV          64000032
#define OPENCL_CLENQUEUEMARKER_EV                     64000033
#define OPENCL_CLENQUEUEBARRIER_EV                    64000034
#define OPENCL_CLRETAINCOMMANDQUEUE_EV                64000035
#define OPENCL_CLRELEASECOMMANDQUEUE_EV               64000036
#define OPENCL_CLRETAINCONTEXT_EV                     64000037
#define OPENCL_CLRELEASECONTEXT_EV                    64000038
#define OPENCL_CLRETAINDEVICE_EV                      64000039
#define OPENCL_CLRELEASEDEVICE_EV                     64000040
#define OPENCL_CLRETAINEVENT_EV                       64000041
#define OPENCL_CLRELEASEEVENT_EV                      64000042
#define OPENCL_CLRETAINKERNEL_EV                      64000043
#define OPENCL_CLRELEASEKERNEL_EV                     64000044
#define OPENCL_CLRETAINMEMOBJECT_EV                   64000045
#define OPENCL_CLRELEASEMEMOBJECT_EV                  64000046
#define OPENCL_CLRETAINPROGRAM_EV                     64000047
#define OPENCL_CLRELEASEPROGRAM_EV                    64000048
/* Added to complement CUDA memcpyasync */
#define OPENCL_CLENQUEUEREADBUFFER_ASYNC_EV           64000049
#define OPENCL_CLENQUEUEREADBUFFERRECT_ASYNC_EV       64000050
#define OPENCL_CLENQUEUEWRITEBUFFER_ASYNC_EV          64000051
#define OPENCL_CLENQUEUEWRITEBUFFERRECT_ASYNC_EV      64000052
#define OPENCL_CLMEMOP_SIZE_EV                        64099999

/* OpenCL Accelerator side events */
#define OPENCL_CLENQUEUEFILLBUFFER_ACC_EV             64100012
#define OPENCL_CLENQUEUECOPYBUFFER_ACC_EV             64100013
#define OPENCL_CLENQUEUECOPYBUFFERRECT_ACC_EV         64100014
#define OPENCL_CLENQUEUENDRANGEKERNEL_ACC_EV          64100015
#define OPENCL_CLENQUEUETASK_ACC_EV                   64100016
#define OPENCL_CLENQUEUENATIVEKERNEL_ACC_EV           64100017
#define OPENCL_CLENQUEUEREADBUFFER_ACC_EV             64100018
#define OPENCL_CLENQUEUEREADBUFFERRECT_ACC_EV         64100019
#define OPENCL_CLENQUEUEWRITEBUFFER_ACC_EV            64100020
#define OPENCL_CLENQUEUEWRITEBUFFERRECT_ACC_EV        64100021
#define OPENCL_CLENQUEUEMARKERWITHWAITLIST_ACC_EV     64100028
#define OPENCL_CLENQUEUEBARRIERWITHWAITLIST_ACC_EV    64100029
#define OPENCL_CLENQUEUEMAPBUFFER_ACC_EV              64100030
#define OPENCL_CLENQUEUEUNMAPMEMOBJECT_ACC_EV         64100031
#define OPENCL_CLENQUEUEMIGRATEMEMOBJECTS_ACC_EV      64100032
#define OPENCL_CLENQUEUEMARKER_ACC_EV                 64100033
#define OPENCL_CLENQUEUEBARRIER_ACC_EV                64100034
/* Added to complement CUDA memcpyasync */
#define OPENCL_CLENQUEUEREADBUFFER_ASYNC_ACC_EV       64100049
#define OPENCL_CLENQUEUEREADBUFFERRECT_ASYNC_ACC_EV   64100050
#define OPENCL_CLENQUEUEWRITEBUFFER_ASYNC_ACC_EV      64100051
#define OPENCL_CLENQUEUEWRITEBUFFERRECT_ASYNC_ACC_EV  64100052
/* To associate command queue with Paraver thread */
#define OPENCL_CLFINISH_THID_EV                       64300000

#define OPENACC_EV                                    66000000
#define OPENACC_DATA_EV                               66000001
#define OPENACC_LAUNCH_EV                             66000002

enum
{
	// OPENACC DATA EVENTS
	OPENACC_END_VAL = 0,
	OPENACC_ENQUEUE_UPLOAD_VAL,
	OPENACC_ENQUEUE_DOWNLOAD_VAL,
	OPENACC_CREATE_VAL,
	OPENACC_DELETE_VAL,
	OPENACC_ALLOC_VAL,
	OPENACC_FREE_VAL,
	OPENACC_MAX_DATA_VAL = OPENACC_FREE_VAL,

	// OPENACC LAUNCH EVENTS
	OPENACC_ENQUEUE_LAUNCH_VAL,
	OPENACC_MAX_LAUNCH_VAL = OPENACC_ENQUEUE_LAUNCH_VAL,

	// OPENACC OTHER EVENTS
	OPENACC_INIT_VAL,
	OPENACC_SHUTDOWN_VAL,
	OPENACC_ENTER_DATA_VAL,
	OPENACC_EXIT_DATA_VAL,
	OPENACC_UPDATE_VAL,
	OPENACC_COMPUTE_VAL,
	OPENACC_WAIT_VAL,
	OPENACC_MAX_VAL = OPENACC_WAIT_VAL
};

/* GASPI-2 calls events */
#define GASPI_EV                69000000
#define GASPI_INIT_EV           69100000
enum {
	GASPI_TERM_VAL = 2,
	GASPI_CONNECT_VAL,
	GASPI_DISCONNECT_VAL,

	GASPI_GROUP_CREATE_VAL,
	GASPI_GROUP_ADD_VAL,
	GASPI_GROUP_COMMIT_VAL,
	GASPI_GROUP_DELETE_VAL,

	GASPI_SEGMENT_ALLOC_VAL,
	GASPI_SEGMENT_REGISTER_VAL,
	GASPI_SEGMENT_CREATE_VAL,
	GASPI_SEGMENT_BIND_VAL,
	GASPI_SEGMENT_USE_VAL,
	GASPI_SEGMENT_DELETE_VAL,

	GASPI_WRITE_VAL,
	GASPI_READ_VAL,
	GASPI_WAIT_VAL,
	GASPI_NOTIFY_VAL,
	GASPI_NOTIFY_WAITSOME_VAL,
	GASPI_NOTIFY_RESET_VAL,
	GASPI_WRITE_NOTIFY_VAL,
	GASPI_WRITE_LIST_VAL,
	GASPI_WRITE_LIST_NOTIFY_VAL,
	GASPI_READ_NOTIFY_VAL,
	GASPI_READ_LIST_VAL,
	GASPI_READ_LIST_NOTIFY_VAL,

	GASPI_PASSIVE_SEND_VAL,
	GASPI_PASSIVE_RECEIVE_VAL,

	GASPI_ATOMIC_FETCH_ADD_VAL,
	GASPI_ATOMIC_COMPARE_SWAP_VAL,

	GASPI_BARRIER_VAL,
	GASPI_ALLREDUCE_VAL,
	GASPI_ALLREDUCE_USER_VAL,

	GASPI_QUEUE_CREATE_VAL,
	GASPI_QUEUE_DELETE_VAL,

	GASPI_MAX_VAL = GASPI_QUEUE_DELETE_VAL
};

/* GASPI-2 parameters events*/
#define GASPI_SIZE_EV                69000001
#define GASPI_RANK_EV                69000002
#define GASPI_QUEUE_ID_EV            69000003
#define GASPI_NOTIFICATION_ID_EV     69000004

#define CALLER_EV                70000000
#define CALLER_LINE_EV           80000000

#define ONLINE_EV                50000
#define CLUSTER_ID_EV            90000001
#define CLUSTER_SUPPORT_EV       92000001
#define SPECTRAL_PERIOD_EV       91000001
#define GREMLIN_EV               93000001

/* 
 * Values.
 */

#define WORK_WSH_VAL             1
#define WORK_REG_VAL             2
#define WORK_DOSINGLE_VAL        3 /* The thread goes to do the single section */

/* 
 * Parallelism values.
 */
#define PAR_END_VAL              0 /* Close parallel (region and * worksharing constructs). */
#define PAR_WSH_VAL              1 /* Parallel worksharing constructs : * PARALLEL DO */
#define PAR_SEC_VAL              2 /* Parallel worksharing constructs : * PARALLEL SECTIONS */
#define PAR_REG_VAL              3 /* Parallel region construct : * PARALLEL. */

/* 
 * Worksharing construct values
 */
#define WSH_END_VAL              0 /* worsharing ending : DO, SINGLE * and SECTIONS */
#define WSH_DO_VAL               4 /* worksharing constructs : DO * and SECTIONS. */
#define WSH_SEC_VAL              5 /* worksharing constructs : DO * and SECTIONS. */
#define WSH_SINGLE_VAL           6 /* worksharing construct : SINGLE */ 
#define WSH_MASTER_VAL           7 /* worksharing construct : MASTER */

/* Workharing ending values */
#define JOIN_WAIT_VAL            1
#define JOIN_NOWAIT_VAL          2

/* 
 * Lock Values.
 */
#define UNLOCKED_VAL             0 /* Unlocked Status. Mutex is unlocked. */
#define LOCK_VAL                 3 /* Inside an acquire lock function. */
#define UNLOCK_VAL               5 /* Inside a release lock function. */
#define LOCKED_VAL               6 /* Locked Status. Mutex is locked. */

/* 
 * Ordered Values.
 */
#define OUTORDERED_VAL           0 /* Outside ordered section in ordered or doacross loop. */
#define WAITORDERED_VAL          3 /* Waiting to enter ordered section in ordered or doacross loop */
#define POSTORDERED_VAL          5 /* Signaling the exit from ordered section in ordered or doacross loop */
#define INORDERED_VAL            6 /* Inside ordered section in ordered or doacross loop. */

#if defined(DEAD_CODE)
/* 
 * Some Ordered Values.
 */
#define IT_MARK_VAL             2
#define WAIT_BEGIN_VAL          3
#define WAIT_END_VAL            4
#endif

#define STATE_ANY                -1
#define STATE_IDLE               0
#define STATE_RUNNING            1
#define STATE_STOPPED            2
#define STATE_WAITMESS           3
#define STATE_BLOCKED            9
#define STATE_SYNC               5
#define STATE_BARRIER            5
#define STATE_TWRECV             8
#define STATE_OVHD               7
#define STATE_PROBE              6
#define STATE_BSEND              4
#define STATE_SEND               4
#define STATE_RSEND              4
#define STATE_SSEND              4
#define STATE_IBSEND             10
#define STATE_ISEND              10
#define STATE_IRSEND             10
#define STATE_ISSEND             10
#define STATE_IWAITMESS          11
#define STATE_IRECV              11
#define STATE_IO                 12
#define STATE_FLUSH              12
#define STATE_BCAST              13
#define STATE_NOT_TRACING        14
#define STATE_INITFINI           15
#define STATE_OTHERS             15
#define STATE_MIXED              15
#define STATE_SENDRECVOP         16
#define STATE_MEMORY_XFER        17
#define STATE_PROFILING          18
#define STATE_ONLINE_ANALYSIS    19
/* Added for SHMEM */
#define STATE_REMOTE_MEM_ACCESS  20
#define STATE_ATOMIC_MEM_OP      21
#define STATE_MEM_ORDERING       22
#define STATE_LOCKING            23
/* Added for Dimemas */
#define STATE_OVERHEAD           24
#define STATE_1SIDED             25
#define STATE_STARTUP_LATENCY    26
#define STATE_WAIT_LINKS         27
#define STATE_DATA_COPY          28
#define STATE_RTT                29
/* Added for malloc calls */
#define STATE_ALLOCMEM           30
#define STATE_FREEMEM            31
/* Added for accelerators */
#define STATE_CONFACCEL          32




#if defined(DEAD_CODE)
/* ==========================================================================
   ==== MPI Dimemas Block Numbers
   ========================================================================== */

typedef enum
{
/* 000 */   BLOCK_ID_NULL,
/* 001 */   BLOCK_ID_MPI_Allgather,
/* 002 */   BLOCK_ID_MPI_Allgatherv,
/* 003 */   BLOCK_ID_MPI_Allreduce,
/* 004 */   BLOCK_ID_MPI_Alltoall,
/* 005 */   BLOCK_ID_MPI_Alltoallv,
/* 006 */   BLOCK_ID_MPI_Barrier,
/* 007 */   BLOCK_ID_MPI_Bcast,
/* 008 */   BLOCK_ID_MPI_Gather,
/* 009 */   BLOCK_ID_MPI_Gatherv,
/* 010 */   BLOCK_ID_MPI_Op_create,
/* 011 */   BLOCK_ID_MPI_Op_free,
/* 012 */   BLOCK_ID_MPI_Reduce_scatter,
/* 013 */   BLOCK_ID_MPI_Reduce,
/* 014 */   BLOCK_ID_MPI_Scan,
/* 015 */   BLOCK_ID_MPI_Scatter,
/* 016 */   BLOCK_ID_MPI_Scatterv,
/* 017 */   BLOCK_ID_MPI_Attr_delete,
/* 018 */   BLOCK_ID_MPI_Attr_get,
/* 019 */   BLOCK_ID_MPI_Attr_put,
  
/* 020 */   BLOCK_ID_MPI_Comm_create,
/* 021 */   BLOCK_ID_MPI_Comm_dup,
/* 022 */   BLOCK_ID_MPI_Comm_free,
/* 023 */   BLOCK_ID_MPI_Comm_group,
/* 024 */   BLOCK_ID_MPI_Comm_rank,
/* 025 */   BLOCK_ID_MPI_Comm_remote_group,
/* 026 */   BLOCK_ID_MPI_Comm_remote_size,
/* 027 */   BLOCK_ID_MPI_Comm_size,
/* 028 */   BLOCK_ID_MPI_Comm_split,
/* 029 */   BLOCK_ID_MPI_Comm_test_inter,
/* 030 */   BLOCK_ID_MPI_Comm_compare,
/* 031 */   BLOCK_ID_MPI_Group_difference,
/* 032 */   BLOCK_ID_MPI_Group_excl,
/* 033 */   BLOCK_ID_MPI_Group_free,
/* 034 */   BLOCK_ID_MPI_Group_incl,
/* 035 */   BLOCK_ID_MPI_Group_intersection,
/* 036 */   BLOCK_ID_MPI_Group_rank,
/* 037 */   BLOCK_ID_MPI_Group_range_excl,
/* 038 */   BLOCK_ID_MPI_Group_range_incl,
/* 039 */   BLOCK_ID_MPI_Group_size,
/* 040 */   BLOCK_ID_MPI_Group_translate_ranks,
/* 041 */   BLOCK_ID_MPI_Group_union,
/* 042 */   BLOCK_ID_MPI_Group_compare,
/* 043 */   BLOCK_ID_MPI_Intercomm_create,
/* 044 */   BLOCK_ID_MPI_Intercomm_merge,
/* 045 */   BLOCK_ID_MPI_Keyval_free,
/* 046 */   BLOCK_ID_MPI_Keyval_create,
/* 047 */   BLOCK_ID_MPI_Abort,
/* 048 */   BLOCK_ID_MPI_Error_class,
/* 049 */   BLOCK_ID_MPI_Errhandler_create,
/* 050 */   BLOCK_ID_MPI_Errhandler_free,
/* 051 */   BLOCK_ID_MPI_Errhandler_get,
/* 052 */   BLOCK_ID_MPI_Error_string,
/* 053 */   BLOCK_ID_MPI_Errhandler_set,
/* 054 */   BLOCK_ID_MPI_Finalize,
/* 055 */   BLOCK_ID_MPI_Get_processor_name,
/* 056 */   BLOCK_ID_MPI_Init,
/* 057 */   BLOCK_ID_MPI_Initialized,
/* 058 */   BLOCK_ID_MPI_Wtick,
/* 059 */   BLOCK_ID_MPI_Wtime,
/* 060 */   BLOCK_ID_MPI_Address,
/* 061 */   BLOCK_ID_MPI_Bsend,
/* 062 */   BLOCK_ID_MPI_Bsend_init,
/* 063 */   BLOCK_ID_MPI_Buffer_attach,
/* 064 */   BLOCK_ID_MPI_Buffer_detach,
/* 065 */   BLOCK_ID_MPI_Cancel,
/* 066 */   BLOCK_ID_MPI_Request_free,
/* 067 */   BLOCK_ID_MPI_Recv_init,
/* 068 */   BLOCK_ID_MPI_Send_init,
/* 069 */   BLOCK_ID_MPI_Get_count,
/* 070 */   BLOCK_ID_MPI_Get_elements,
/* 071 */   BLOCK_ID_MPI_Ibsend,
/* 072 */   BLOCK_ID_MPI_Iprobe,
/* 073 */   BLOCK_ID_MPI_Irecv,
/* 074 */   BLOCK_ID_MPI_Irsend,
/* 075 */   BLOCK_ID_MPI_Isend,
/* 076 */   BLOCK_ID_MPI_Issend,
/* 077 */   BLOCK_ID_MPI_Pack,
/* 078 */   BLOCK_ID_MPI_Pack_size,
/* 079 */   BLOCK_ID_MPI_Probe,
/* 080 */   BLOCK_ID_MPI_Recv,
/* 081 */   BLOCK_ID_MPI_Rsend,
/* 082 */   BLOCK_ID_MPI_Rsend_init,
/* 083 */   BLOCK_ID_MPI_Send,
/* 084 */   BLOCK_ID_MPI_Sendrecv,
/* 085 */   BLOCK_ID_MPI_Sendrecv_replace,
/* 086 */   BLOCK_ID_MPI_Ssend,
/* 087 */   BLOCK_ID_MPI_Ssend_init,
/* 088 */   BLOCK_ID_MPI_Start,
/* 089 */   BLOCK_ID_MPI_Startall,
/* 090 */   BLOCK_ID_MPI_Test,
/* 091 */   BLOCK_ID_MPI_Testall,
/* 092 */   BLOCK_ID_MPI_Testany,
/* 093 */   BLOCK_ID_MPI_Test_cancelled,
/* 094 */   BLOCK_ID_MPI_Test_some,
/* 095 */   BLOCK_ID_MPI_Type_commit,
/* 096 */   BLOCK_ID_MPI_Type_contiguous,
/* 097 */   BLOCK_ID_MPI_Type_extent,
/* 098 */   BLOCK_ID_MPI_Type_free,
/* 099 */   BLOCK_ID_MPI_Type_hindexed,
/* 100 */   BLOCK_ID_MPI_Type_hvector,
/* 101 */   BLOCK_ID_MPI_Type_indexed,
/* 102 */   BLOCK_ID_MPI_Type_lb,
/* 103 */   BLOCK_ID_MPI_Type_size,
/* 104 */   BLOCK_ID_MPI_Type_struct,
/* 105 */   BLOCK_ID_MPI_Type_ub,
/* 106 */   BLOCK_ID_MPI_Type_vector,
/* 107 */   BLOCK_ID_MPI_Unpack,
/* 108 */   BLOCK_ID_MPI_Wait,
/* 109 */   BLOCK_ID_MPI_Waitall,
/* 110 */   BLOCK_ID_MPI_Waitany,
/* 111 */   BLOCK_ID_MPI_Waitsome,
/* 112 */   BLOCK_ID_MPI_Cart_coords,
/* 113 */   BLOCK_ID_MPI_Cart_create,
/* 114 */   BLOCK_ID_MPI_Cart_get,
/* 115 */   BLOCK_ID_MPI_Cart_map,
/* 116 */   BLOCK_ID_MPI_Cart_rank,
/* 117 */   BLOCK_ID_MPI_Cart_shift,
/* 118 */   BLOCK_ID_MPI_Cart_sub,
/* 119 */   BLOCK_ID_MPI_Cartdim_get,
/* 120 */   BLOCK_ID_MPI_Dims_create,
/* 121 */   BLOCK_ID_MPI_Graph_get,
/* 122 */   BLOCK_ID_MPI_Graph_map,
/* 123 */   BLOCK_ID_MPI_Graph_create,
/* 124 */   BLOCK_ID_MPI_Graph_neighbors,
/* 125 */   BLOCK_ID_MPI_Graphdims_get,
/* 126 */   BLOCK_ID_MPI_Graph_neighbors_count,
/* 127 */   BLOCK_ID_MPI_Topo_test,

/* 128 */   BLOCK_ID_TRACE_ON,
/* 129 */   BLOCK_ID_IO_Read,
/* 130 */   BLOCK_ID_IO_Write,
/* 131 */   BLOCK_ID_IO,
  
/* 132 */   BLOCK_ID_MPI_Win_create,
/* 133 */   BLOCK_ID_MPI_Win_free,
/* 134 */   BLOCK_ID_MPI_Put,
/* 135 */   BLOCK_ID_MPI_Get,
/* 136 */   BLOCK_ID_MPI_Accumulate,
/* 137 */   BLOCK_ID_MPI_Win_fence,
/* 138 */   BLOCK_ID_MPI_Win_complete,
/* 139 */   BLOCK_ID_MPI_Win_start,
/* 140 */   BLOCK_ID_MPI_Win_post,
/* 141 */   BLOCK_ID_MPI_Win_wait,
/* 142 */   BLOCK_ID_MPI_Win_test,
/* 143 */   BLOCK_ID_MPI_Win_lock,
/* 144 */   BLOCK_ID_MPI_Win_unlock,

/* 145 */   BLOCK_ID_MPI_Init_thread,

/* 146 */   BLOCK_ID_LAPI_Init,
/* 147 */   BLOCK_ID_LAPI_Term,
/* 148 */   BLOCK_ID_LAPI_Put,
/* 149 */   BLOCK_ID_LAPI_Get,
/* 150 */   BLOCK_ID_LAPI_Fence,
/* 151 */   BLOCK_ID_LAPI_Gfence,
/* 152 */   BLOCK_ID_LAPI_Address_init,
/* 153 */   BLOCK_ID_LAPI_Amsend,
/* 154 */   BLOCK_ID_LAPI_Rmw,
/* 155 */   BLOCK_ID_LAPI_Waitcntr
/* 156 */   BLOCK_ID_MPI_Reduce_scatter_block,
/* 157 */   BLOCK_ID_MPI_Alltoallw,
/* 158 */   BLOCK_ID_MPI_Get_accumulate
  
} DimBlock;
#endif

/* ==========================================================================
   ==== MPI Dimemas Collective Communications Identifiers
   ========================================================================== */

typedef enum
{
  GLOP_ID_NULL               = -1,
  GLOP_ID_MPI_Barrier        = 0,
  GLOP_ID_MPI_Bcast          = 1,
  GLOP_ID_MPI_Gather         = 2,
  GLOP_ID_MPI_Gatherv        = 3,
  GLOP_ID_MPI_Scatter        = 4,
  GLOP_ID_MPI_Scatterv       = 5,
  GLOP_ID_MPI_Allgather      = 6,
  GLOP_ID_MPI_Allgatherv     = 7,
  GLOP_ID_MPI_Alltoall       = 8,
  GLOP_ID_MPI_Alltoallv      = 9,
  GLOP_ID_MPI_Reduce         = 10,
  GLOP_ID_MPI_Allreduce      = 11,
  GLOP_ID_MPI_Reduce_scatter = 12,
  GLOP_ID_MPI_Scan           = 13,
  GLOP_ID_MPI_Reduce_scatter_block = 14,
  GLOP_ID_MPI_Alltoallw		 = 15

} DimCollectiveOp;

typedef enum
{
	MPI_TYPE = 1,
	MPI_COMM_ALIAS_TYPE,
	MISC_TYPE,
	OPENMP_TYPE,
	PTHREAD_TYPE,
	CUDA_TYPE,
	OPENCL_TYPE,
	OPENSHMEM_TYPE,
	JAVA_TYPE,
	OPENACC_TYPE,
	GASPI_TYPE
} EventType_t;


/* File descriptor classifications */

typedef enum
{
	DESCRIPTOR_TYPE_UNKNOWN = 0, /* unknown */
	DESCRIPTOR_TYPE_REGULARFILE, /* regular file */
	DESCRIPTOR_TYPE_SOCKET,      /* socket */
	DESCRIPTOR_TYPE_FIFO_PIPE,   /* fifo or pipe */
	DESCRIPTOR_TYPE_ATTY         /* connected to the terminal? */
} ExtraeDescriptorType_t;

EventType_t getEventType (unsigned EvType, unsigned *Type);

#endif /* __EVENTS_H_INCLUDED__ */
