#  /bin/bash

if [ $# -eq 0 ]; then
  echo "Usage:"
  echo "    $0 <prefix>"
  echo
  echo "        prefix: wxparaver installation PREFIX"
  exit
fi

PREFIX=${1}
BUNDLE_LIBS="wxparaver.app/Contents/Frameworks"
BUNDLE_BIN="wxparaver.app/Contents/MacOS/wxparaver"
BUNDLE_RESOURCES="wxparaver.app/Contents/Resources"

# Create directories
mkdir -p ${BUNDLE_LIBS}
mkdir -p wxparaver.app/Contents/MacOS
mkdir -p ${BUNDLE_RESOURCES}/cfgs
mkdir -p ${BUNDLE_RESOURCES}/share/doc/wxparaver_help_contents/

# Copy Resource Files
cp mac/Info.plist wxparaver.app/Contents
cp ${PREFIX}/share/workspaces.xml ${BUNDLE_RESOURCES}/share/
cp -R ${PREFIX}/cfgs/* ${BUNDLE_RESOURCES}/cfgs/
rm -f ${BUNDLE_RESOURCES}/cfgs/.cfgs*.tar.gz
cp -R ${PREFIX}/share/doc/wxparaver_help_contents/* ${BUNDLE_RESOURCES}/share/doc/wxparaver_help_contents/

# Copy paraver binary and libraries
cp ${PREFIX}/bin/wxparaver.bin ${BUNDLE_BIN}
cp ${PREFIX}/lib/paraver-kernel/libparaver-api.0.dylib ${BUNDLE_LIBS}
cp ${PREFIX}/lib/paraver-kernel/libparaver-kernel.0.dylib ${BUNDLE_LIBS}

# Copy dependency libraries
WXWIDGETS_3_1_LIBPATH="/opt/local/Library/Frameworks/wxWidgets.framework/Versions/wxWidgets/3.1/lib"
WXWIDGETS_3_1_LIBS="
libwx_osx_cocoau_propgrid-3.1.dylib
libwx_osx_cocoau_aui-3.1.dylib
libwx_osx_cocoau_richtext-3.1.dylib
libwx_osx_cocoau_xrc-3.1.dylib
libwx_osx_cocoau_html-3.1.dylib
libwx_osx_cocoau_qa-3.1.dylib
libwx_osx_cocoau_core-3.1.dylib
libwx_baseu_xml-3.1.dylib
libwx_baseu_net-3.1.dylib
libwx_baseu-3.1.dylib"

for curlib in ${WXWIDGETS_3_1_LIBS}; do
  cp ${WXWIDGETS_3_1_LIBPATH}/${curlib} ${BUNDLE_LIBS}
done


SYS_LIBS="
/opt/local/libexec/boost/1.76/lib/libboost_serialization-mt.dylib
/opt/local/libexec/boost/1.76/lib/libboost_date_time-mt.dylib
/opt/local/libexec/boost/1.76/lib/libboost_system-mt.dylib
/opt/local/libexec/openssl3/lib/libssl.3.dylib
/opt/local/libexec/openssl3/lib/libcrypto.3.dylib
/opt/local/lib/libz.1.dylib
/opt/local/lib/libxml2.2.dylib
/opt/local/lib/liblzma.5.dylib
/opt/local/lib/libiconv.2.dylib
/opt/local/lib/libicui18n.67.dylib
/opt/local/lib/libicuuc.67.dylib
/opt/local/lib/libicudata.67.dylib
/opt/local/lib/libpng16.16.dylib
/opt/local/lib/libjpeg.8.dylib
/opt/local/lib/libtiff.5.dylib
/opt/local/lib/libzstd.1.dylib
/opt/local/lib/libexpat.1.dylib"

for curlib in ${SYS_LIBS}; do
  cp ${curlib} ${BUNDLE_LIBS}
done

chmod u+w ${BUNDLE_LIBS}/*

# Set libraries location path...

# ... for wxparaver binary
install_name_tool -change /opt/local/libexec/boost/1.76/lib/libboost_serialization-mt.dylib @executable_path/../Frameworks/libboost_serialization-mt.dylib ${BUNDLE_BIN}
install_name_tool -change /opt/local/libexec/boost/1.76/lib/libboost_date_time-mt.dylib @executable_path/../Frameworks/libboost_date_time-mt.dylib ${BUNDLE_BIN}
install_name_tool -change /opt/local/libexec/boost/1.76/lib/libboost_system-mt.dylib @executable_path/../Frameworks/libboost_system-mt.dylib ${BUNDLE_BIN}
install_name_tool -change /opt/local/libexec/openssl3/lib/libssl.3.dylib @executable_path/../Frameworks/libssl.3.dylib ${BUNDLE_BIN}
install_name_tool -change /opt/local/libexec/openssl3/lib/libcrypto.3.dylib @executable_path/../Frameworks/libcrypto.3.dylib ${BUNDLE_BIN}

for curlib in ${WXWIDGETS_3_1_LIBS}; do
  install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/${curlib} @executable_path/../Frameworks/${curlib} ${BUNDLE_BIN}
done
  
install_name_tool -change ${PREFIX}/lib/paraver-kernel/libparaver-kernel.0.dylib @executable_path/../Frameworks/libparaver-kernel.0.dylib ${BUNDLE_BIN}
install_name_tool -change ${PREFIX}/lib/paraver-kernel/libparaver-api.0.dylib @executable_path/../Frameworks/libparaver-api.0.dylib ${BUNDLE_BIN}

# ... for libparaver-kernel library
install_name_tool -change /opt/local/libexec/boost/1.76/lib/libboost_serialization-mt.dylib @executable_path/../Frameworks/libboost_serialization-mt.dylib ${BUNDLE_LIBS}/libparaver-kernel.0.dylib
install_name_tool -change /opt/local/libexec/boost/1.76/lib/libboost_date_time-mt.dylib @executable_path/../Frameworks/libboost_date_time-mt.dylib ${BUNDLE_LIBS}/libparaver-kernel.0.dylib
install_name_tool -change /opt/local/lib/libxml2.2.dylib @executable_path/../Frameworks/libxml2.2.dylib ${BUNDLE_LIBS}/libparaver-kernel.0.dylib
install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libparaver-kernel.0.dylib
install_name_tool -change /opt/local/lib/liblzma.5.dylib @executable_path/../Frameworks/liblzma.5.dylib ${BUNDLE_LIBS}/libparaver-kernel.0.dylib
install_name_tool -change /opt/local/lib/libiconv.2.dylib @executable_path/../Frameworks/libiconv.2.dylib ${BUNDLE_LIBS}/libparaver-kernel.0.dylib
install_name_tool -change /opt/local/lib/libicui18n.67.dylib @executable_path/../Frameworks/libicui18n.67.dylib ${BUNDLE_LIBS}/libparaver-kernel.0.dylib
install_name_tool -change /opt/local/lib/libicuuc.67.dylib @executable_path/../Frameworks/libicuuc.67.dylib ${BUNDLE_LIBS}/libparaver-kernel.0.dylib
install_name_tool -change /opt/local/lib/libicudata.67.dylib @executable_path/../Frameworks/libicudata.67.dylib ${BUNDLE_LIBS}/libparaver-kernel.0.dylib

# ... for libparaver-api library
install_name_tool -change /opt/local/libexec/boost/1.76/lib/libboost_serialization-mt.dylib @executable_path/../Frameworks/libboost_serialization-mt.dylib ${BUNDLE_LIBS}/libparaver-api.0.dylib
install_name_tool -change /opt/local/libexec/boost/1.76/lib/libboost_date_time-mt.dylib @executable_path/../Frameworks/libboost_date_time-mt.dylib ${BUNDLE_LIBS}/libparaver-api.0.dylib
install_name_tool -change /opt/local/lib/libxml2.2.dylib @executable_path/../Frameworks/libxml2.2.dylib ${BUNDLE_LIBS}/libparaver-api.0.dylib
install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libparaver-api.0.dylib
install_name_tool -change /opt/local/lib/liblzma.5.dylib @executable_path/../Frameworks/liblzma.5.dylib ${BUNDLE_LIBS}/libparaver-api.0.dylib
install_name_tool -change /opt/local/lib/libiconv.2.dylib @executable_path/../Frameworks/libiconv.2.dylib ${BUNDLE_LIBS}/libparaver-api.0.dylib
install_name_tool -change /opt/local/lib/libicui18n.67.dylib @executable_path/../Frameworks/libicui18n.67.dylib ${BUNDLE_LIBS}/libparaver-api.0.dylib
install_name_tool -change /opt/local/lib/libicuuc.67.dylib @executable_path/../Frameworks/libicuuc.67.dylib ${BUNDLE_LIBS}/libparaver-api.0.dylib
install_name_tool -change /opt/local/lib/libicudata.67.dylib @executable_path/../Frameworks/libicudata.67.dylib ${BUNDLE_LIBS}/libparaver-api.0.dylib

# ... for non-wxwidgets libraries
install_name_tool -change /opt/local/libexec/openssl3/lib/libcrypto.3.dylib @executable_path/../Frameworks/libcrypto.3.dylib ${BUNDLE_LIBS}/libssl.3.dylib
install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libssl.3.dylib

install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libcrypto.3.dylib

install_name_tool -change /opt/local/lib/libicui18n.67.dylib @executable_path/../Frameworks/libicui18n.67.dylib ${BUNDLE_LIBS}/libxml2.2.dylib
install_name_tool -change /opt/local/lib/libicuuc.67.dylib @executable_path/../Frameworks/libicuuc.67.dylib ${BUNDLE_LIBS}/libxml2.2.dylib
install_name_tool -change /opt/local/lib/libicudata.67.dylib @executable_path/../Frameworks/libicudata.67.dylib ${BUNDLE_LIBS}/libxml2.2.dylib
install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libxml2.2.dylib
install_name_tool -change /opt/local/lib/liblzma.5.dylib @executable_path/../Frameworks/liblzma.5.dylib ${BUNDLE_LIBS}/libxml2.2.dylib
install_name_tool -change /opt/local/lib/libiconv.2.dylib @executable_path/../Frameworks/libiconv.2.dylib ${BUNDLE_LIBS}/libxml2.2.dylib

install_name_tool -change /opt/local/lib/libicuuc.67.dylib @executable_path/../Frameworks/libicuuc.67.dylib ${BUNDLE_LIBS}/libicui18n.67.dylib
install_name_tool -change /opt/local/lib/libicudata.67.dylib @executable_path/../Frameworks/libicudata.67.dylib ${BUNDLE_LIBS}/libicui18n.67.dylib

install_name_tool -change /opt/local/lib/libicudata.67.dylib @executable_path/../Frameworks/libicudata.67.dylib ${BUNDLE_LIBS}/libicuuc.67.dylib

install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libpng16.16.dylib

install_name_tool -change /opt/local/lib/libzstd.1.dylib @executable_path/../Frameworks/libzstd.1.dylib ${BUNDLE_LIBS}/libtiff.5.dylib
install_name_tool -change /opt/local/lib/liblzma.5.dylib @executable_path/../Frameworks/liblzma.5.dylib ${BUNDLE_LIBS}/libtiff.5.dylib
install_name_tool -change /opt/local/lib/libjpeg.8.dylib @executable_path/../Frameworks/libjpeg.8.dylib ${BUNDLE_LIBS}/libtiff.5.dylib
install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libtiff.5.dylib

# ... for wxwidgets libraries
install_name_tool -change /opt/local/lib/libpng16.16.dylib @executable_path/../Frameworks/libpng16.16.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_propgrid-3.1.dylib
install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_propgrid-3.1.dylib
install_name_tool -change /opt/local/lib/libjpeg.8.dylib @executable_path/../Frameworks/libjpeg.8.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_propgrid-3.1.dylib
install_name_tool -change /opt/local/lib/libtiff.5.dylib @executable_path/../Frameworks/libtiff.5.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_propgrid-3.1.dylib
install_name_tool -change /opt/local/lib/liblzma.5.dylib @executable_path/../Frameworks/liblzma.5.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_propgrid-3.1.dylib
install_name_tool -change /opt/local/lib/libiconv.2.dylib @executable_path/../Frameworks/libiconv.2.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_propgrid-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_osx_cocoau_core-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_osx_cocoau_core-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_propgrid-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_baseu-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_baseu-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_propgrid-3.1.dylib

install_name_tool -change /opt/local/lib/libpng16.16.dylib @executable_path/../Frameworks/libpng16.16.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_aui-3.1.dylib
install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_aui-3.1.dylib
install_name_tool -change /opt/local/lib/libjpeg.8.dylib @executable_path/../Frameworks/libjpeg.8.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_aui-3.1.dylib
install_name_tool -change /opt/local/lib/libtiff.5.dylib @executable_path/../Frameworks/libtiff.5.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_aui-3.1.dylib
install_name_tool -change /opt/local/lib/liblzma.5.dylib @executable_path/../Frameworks/liblzma.5.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_aui-3.1.dylib
install_name_tool -change /opt/local/lib/libiconv.2.dylib @executable_path/../Frameworks/libiconv.2.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_aui-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_osx_cocoau_core-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_osx_cocoau_core-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_aui-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_baseu-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_baseu-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_aui-3.1.dylib

install_name_tool -change /opt/local/lib/libpng16.16.dylib @executable_path/../Frameworks/libpng16.16.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_richtext-3.1.dylib
install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_richtext-3.1.dylib
install_name_tool -change /opt/local/lib/libjpeg.8.dylib @executable_path/../Frameworks/libjpeg.8.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_richtext-3.1.dylib
install_name_tool -change /opt/local/lib/libtiff.5.dylib @executable_path/../Frameworks/libtiff.5.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_richtext-3.1.dylib
install_name_tool -change /opt/local/lib/liblzma.5.dylib @executable_path/../Frameworks/liblzma.5.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_richtext-3.1.dylib
install_name_tool -change /opt/local/lib/libiconv.2.dylib @executable_path/../Frameworks/libiconv.2.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_richtext-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_osx_cocoau_html-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_osx_cocoau_html-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_richtext-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_baseu_xml-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_baseu_xml-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_richtext-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_osx_cocoau_core-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_osx_cocoau_core-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_richtext-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_baseu-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_baseu-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_richtext-3.1.dylib

install_name_tool -change /opt/local/lib/libpng16.16.dylib @executable_path/../Frameworks/libpng16.16.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_xrc-3.1.dylib
install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_xrc-3.1.dylib
install_name_tool -change /opt/local/lib/libjpeg.8.dylib @executable_path/../Frameworks/libjpeg.8.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_xrc-3.1.dylib
install_name_tool -change /opt/local/lib/libtiff.5.dylib @executable_path/../Frameworks/libtiff.5.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_xrc-3.1.dylib
install_name_tool -change /opt/local/lib/liblzma.5.dylib @executable_path/../Frameworks/liblzma.5.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_xrc-3.1.dylib
install_name_tool -change /opt/local/lib/libiconv.2.dylib @executable_path/../Frameworks/libiconv.2.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_xrc-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_osx_cocoau_html-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_osx_cocoau_html-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_xrc-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_baseu_xml-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_baseu_xml-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_xrc-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_osx_cocoau_core-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_osx_cocoau_core-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_xrc-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_baseu-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_baseu-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_xrc-3.1.dylib

install_name_tool -change /opt/local/lib/libpng16.16.dylib @executable_path/../Frameworks/libpng16.16.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_html-3.1.dylib
install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_html-3.1.dylib
install_name_tool -change /opt/local/lib/libjpeg.8.dylib @executable_path/../Frameworks/libjpeg.8.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_html-3.1.dylib
install_name_tool -change /opt/local/lib/libtiff.5.dylib @executable_path/../Frameworks/libtiff.5.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_html-3.1.dylib
install_name_tool -change /opt/local/lib/liblzma.5.dylib @executable_path/../Frameworks/liblzma.5.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_html-3.1.dylib
install_name_tool -change /opt/local/lib/libiconv.2.dylib @executable_path/../Frameworks/libiconv.2.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_html-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_osx_cocoau_core-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_osx_cocoau_core-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_html-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_baseu-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_baseu-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_html-3.1.dylib

install_name_tool -change /opt/local/lib/libpng16.16.dylib @executable_path/../Frameworks/libpng16.16.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_qa-3.1.dylib
install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_qa-3.1.dylib
install_name_tool -change /opt/local/lib/libjpeg.8.dylib @executable_path/../Frameworks/libjpeg.8.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_qa-3.1.dylib
install_name_tool -change /opt/local/lib/libtiff.5.dylib @executable_path/../Frameworks/libtiff.5.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_qa-3.1.dylib
install_name_tool -change /opt/local/lib/liblzma.5.dylib @executable_path/../Frameworks/liblzma.5.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_qa-3.1.dylib
install_name_tool -change /opt/local/lib/libiconv.2.dylib @executable_path/../Frameworks/libiconv.2.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_qa-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_baseu_xml-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_baseu_xml-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_qa-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_osx_cocoau_core-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_osx_cocoau_core-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_qa-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_baseu-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_baseu-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_qa-3.1.dylib

install_name_tool -change /opt/local/lib/libpng16.16.dylib @executable_path/../Frameworks/libpng16.16.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_core-3.1.dylib
install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_core-3.1.dylib
install_name_tool -change /opt/local/lib/libjpeg.8.dylib @executable_path/../Frameworks/libjpeg.8.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_core-3.1.dylib
install_name_tool -change /opt/local/lib/libtiff.5.dylib @executable_path/../Frameworks/libtiff.5.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_core-3.1.dylib
install_name_tool -change /opt/local/lib/liblzma.5.dylib @executable_path/../Frameworks/liblzma.5.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_core-3.1.dylib
install_name_tool -change /opt/local/lib/libiconv.2.dylib @executable_path/../Frameworks/libiconv.2.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_core-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_baseu-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_baseu-3.1.dylib ${BUNDLE_LIBS}/libwx_osx_cocoau_core-3.1.dylib

install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libwx_baseu_xml-3.1.dylib
install_name_tool -change /opt/local/lib/liblzma.5.dylib @executable_path/../Frameworks/liblzma.5.dylib ${BUNDLE_LIBS}/libwx_baseu_xml-3.1.dylib
install_name_tool -change /opt/local/lib/libiconv.2.dylib @executable_path/../Frameworks/libiconv.2.dylib ${BUNDLE_LIBS}/libwx_baseu_xml-3.1.dylib
install_name_tool -change /opt/local/lib/libexpat.1.dylib @executable_path/../Frameworks/libexpat.1.dylib ${BUNDLE_LIBS}/libwx_baseu_xml-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_baseu-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_baseu-3.1.dylib ${BUNDLE_LIBS}/libwx_baseu_xml-3.1.dylib

install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libwx_baseu_net-3.1.dylib
install_name_tool -change /opt/local/lib/liblzma.5.dylib @executable_path/../Frameworks/liblzma.5.dylib ${BUNDLE_LIBS}/libwx_baseu_net-3.1.dylib
install_name_tool -change /opt/local/lib/libiconv.2.dylib @executable_path/../Frameworks/libiconv.2.dylib ${BUNDLE_LIBS}/libwx_baseu_net-3.1.dylib
install_name_tool -change ${WXWIDGETS_3_1_LIBPATH}/libwx_baseu-3.1.5.0.0.dylib @executable_path/../Frameworks/libwx_baseu-3.1.dylib ${BUNDLE_LIBS}/libwx_baseu_net-3.1.dylib

install_name_tool -change /opt/local/lib/libz.1.dylib @executable_path/../Frameworks/libz.1.dylib ${BUNDLE_LIBS}/libwx_baseu-3.1.dylib
install_name_tool -change /opt/local/lib/liblzma.5.dylib @executable_path/../Frameworks/liblzma.5.dylib ${BUNDLE_LIBS}/libwx_baseu-3.1.dylib
install_name_tool -change /opt/local/lib/libiconv.2.dylib @executable_path/../Frameworks/libiconv.2.dylib ${BUNDLE_LIBS}/libwx_baseu-3.1.dylib

