#!/usr/bin/env sh

if [ $# -ne 1 ]; then
  echo "Usage: ${0} "
  echo "  dist_path: Distribution source path"
  exit 1
fi

DIST_PATH=${1}
CFGS_DISTDIR=${DIST_PATH}/paraver-cfgs

mkdir -p ${CFGS_DISTDIR} 
echo "[paraver CFGs] Distribution directory: ${CFGS_DISTDIR}"

# Install
echo -n "[paraver CFGs] Copying new cfgs..."
cp -ap ./* ${CFGS_DISTDIR}/ &> /dev/null
echo "done."

# Clean
echo -n "[paraver CFGs] Cleaning..."
rm -rf ${CFGS_DISTDIR}/build-sources-wxparaver.sh
rm -rf ${CFGS_DISTDIR}/update-cfg.sh
rm -rf ${CFGS_DISTDIR}/update-relative-times.sh
find ${CFGS_DISTDIR} -type d -name ".svn" -exec rm -rf {} \; &> /dev/null
find ${CFGS_DISTDIR} -type f -name "svn-commit.*" -exec rm -rf {} \; &> /dev/null
find ${CFGS_DISTDIR} -type f -name "*~" -exec rm -rf {} \; &> /dev/null
echo "done."

echo "[paraver CFGs] Distribution copy finished."

