#!/usr/bin/env sh

#set -x

if [ $# -ne 1 ]; then
  echo "Usage: ${0} install_path"
  echo "  install_path: Destiny path; can contain user-defined cfgs."
  echo "                cfgs with same name are always rewritten with newer versions."
  echo "                Older installation is kept in a .cfgs.backup.tar.gz file"  
  exit 1
fi

INSTALL_PATH=${1}

# Append "./cfgs" if $INSTALL_PATH doesn't end with it
if [ `basename ${INSTALL_PATH}` = "cfgs" ]; then
  LOCAL_CFGS_DIR=${INSTALL_PATH}
else
  LOCAL_CFGS_DIR=${INSTALL_PATH}/cfgs
fi

mkdir -p ${LOCAL_CFGS_DIR} 
echo "[paraver CFGs] Installation directory: ${LOCAL_CFGS_DIR}"

# Install
echo -n "[paraver CFGs] Copying new cfgs..."
cp -ap ./* ${LOCAL_CFGS_DIR}/ &> /dev/null
echo "done."

# Remove crashing cfgs
echo -n "[paraver CFGs] Removing crashing cfgs..."
rm -f ${LOCAL_CFGS_DIR}/General/analysis/load_balance_for_specific_uf.cfg
rm -f ${LOCAL_CFGS_DIR}/mpi/analysis/other/Collective_LateArrivers.cfg
rm -f ${LOCAL_CFGS_DIR}/mpi/analysis/other/Collectives_balance.cfg
echo "done."

# Clean
echo -n "[paraver CFGs] Cleaning..."
rm -f  ${LOCAL_CFGS_DIR}/build-sources-wxparaver.sh
rm -rf ${LOCAL_CFGS_DIR}/build-cfgs-*
rm -f  ${LOCAL_CFGS_DIR}/install.sh
rm -f  ${LOCAL_CFGS_DIR}/install-dist.sh
find ${LOCAL_CFGS_DIR} -type f -name "*~"           -exec rm -rf {} \; > /dev/null 2>&1
echo "done."

echo "[paraver CFGs] Installation finished."

