/*****************************************************************************\
 *                        ANALYSIS PERFORMANCE TOOLS                         *
 *                               libparaver-api                              *
 *                       Paraver Main Computing Library                      *
 *****************************************************************************
 *     ___     This library is free software; you can redistribute it and/or *
 *    /  __         modify it under the terms of the GNU LGPL as published   *
 *   /  /  _____    by the Free Software Foundation; either version 2.1      *
 *  /  /  /     \   of the License, or (at your option) any later version.   *
 * (  (  ( B S C )                                                           *
 *  \  \  \_____/   This library is distributed in hope that it will be      *
 *   \  \__         useful but WITHOUT ANY WARRANTY; without even the        *
 *    \___          implied warranty of MERCHANTABILITY or FITNESS FOR A     *
 *                  PARTICULAR PURPOSE. See the GNU LGPL for more details.   *
 *                                                                           *
 * You should have received a copy of the GNU Lesser General Public License  *
 * along with this library; if not, write to the Free Software Foundation,   *
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA          *
 * The GNU LEsser General Public License is contained in the file COPYING.   *
 *                                 ---------                                 *
 *   Barcelona Supercomputing Center - Centro Nacional de Supercomputacion   *
\*****************************************************************************/



template <typename RecordType>
Index<RecordType>::Index( PRV_UINT32 step )
{
  indexStep = step;
  counter = 0;
}

template <typename RecordType>
Index<RecordType>::~Index()
{}

template <typename RecordType>
void Index<RecordType>::indexRecord( TRecordTime time, RecordType rec )
{
  ++counter;
  if ( counter == indexStep )
  {
    baseIndex[ time ] = rec;
    counter = 0;
  }
}

template <typename RecordType>
bool Index<RecordType>::findRecord( TRecordTime time, RecordType& record ) const
{
  typename TTraceIndex::const_iterator it = baseIndex.lower_bound( time );

  if ( it == baseIndex.end() )
    return false;

  record = it->second;

  return true;
}

