/*****************************************************************************\
 *                        ANALYSIS PERFORMANCE TOOLS                         *
 *                               libparaver-api                              *
 *                       Paraver Main Computing Library                      *
 *****************************************************************************
 *     ___     This library is free software; you can redistribute it and/or *
 *    /  __         modify it under the terms of the GNU LGPL as published   *
 *   /  /  _____    by the Free Software Foundation; either version 2.1      *
 *  /  /  /     \   of the License, or (at your option) any later version.   *
 * (  (  ( B S C )                                                           *
 *  \  \  \_____/   This library is distributed in hope that it will be      *
 *   \  \__         useful but WITHOUT ANY WARRANTY; without even the        *
 *    \___          implied warranty of MERCHANTABILITY or FITNESS FOR A     *
 *                  PARTICULAR PURPOSE. See the GNU LGPL for more details.   *
 *                                                                           *
 * You should have received a copy of the GNU Lesser General Public License  *
 * along with this library; if not, write to the Free Software Foundation,   *
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA          *
 * The GNU LEsser General Public License is contained in the file COPYING.   *
 *                                 ---------                                 *
 *   Barcelona Supercomputing Center - Centro Nacional de Supercomputacion   *
\*****************************************************************************/


#include "semanticcpufunctions.h"

using namespace std;

string ActiveThread::name = "Active Thd";
TSemanticValue ActiveThread::execute( const SemanticInfo *info )
{
  const SemanticHighInfo *myInfo = ( const SemanticHighInfo * ) info;
  return myInfo->values[ 0 ];
}


string ActiveThreadSign::name = "Active Thd Sign";
TSemanticValue ActiveThreadSign::execute( const SemanticInfo *info )
{
  const SemanticHighInfo *myInfo = ( const SemanticHighInfo * ) info;
  if ( myInfo->values[ 0 ] )
    return 1;
  return 0;
}


string ActiveThreadValues::name = "Active Thd Val";
TSemanticValue ActiveThreadValues::execute( const SemanticInfo *info )
{
  const SemanticHighInfo *myInfo = ( const SemanticHighInfo * ) info;

  for( PRV_UINT32 i = 0; i < parameters[ VALUES ].size(); i++ )
  {
    if( parameters[ VALUES ][ i ] == myInfo->values[ 0 ] )
      return myInfo->values[ 0 ];
  }
  return 0;
}


string ActiveThreadValuesSign::name = "Active Thd Val Sign";
TSemanticValue ActiveThreadValuesSign::execute( const SemanticInfo *info )
{
  const SemanticHighInfo *myInfo = ( const SemanticHighInfo * ) info;

  for( PRV_UINT32 i = 0; i < parameters[ VALUES ].size(); i++ )
  {
    if( parameters[ VALUES ][ i ] == myInfo->values[ 0 ] )
      return 1;
  }
  return 0;
}
