/*****************************************************************************\
 *                        ANALYSIS PERFORMANCE TOOLS                         *
 *                                  wxparaver                                *
 *              Paraver Trace Visualization and Analysis Tool                *
 *****************************************************************************
 *     ___     This library is free software; you can redistribute it and/or *
 *    /  __         modify it under the terms of the GNU LGPL as published   *
 *   /  /  _____    by the Free Software Foundation; either version 2.1      *
 *  /  /  /     \   of the License, or (at your option) any later version.   *
 * (  (  ( B S C )                                                           *
 *  \  \  \_____/   This library is distributed in hope that it will be      *
 *   \  \__         useful but WITHOUT ANY WARRANTY; without even the        *
 *    \___          implied warranty of MERCHANTABILITY or FITNESS FOR A     *
 *                  PARTICULAR PURPOSE. See the GNU LGPL for more details.   *
 *                                                                           *
 * You should have received a copy of the GNU Lesser General Public License  *
 * along with this library; if not, write to the Free Software Foundation,   *
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA          *
 * The GNU LEsser General Public License is contained in the file COPYING.   *
 *                                 ---------                                 *
 *   Barcelona Supercomputing Center - Centro Nacional de Supercomputacion   *
\*****************************************************************************/

#pragma once

#include "copypaste.h"
#include "customalgorithms.h"
#include "rowsselectiondialog.h"

#include <map>
#include <variant>
#include <wx/choicdlg.h>
#include <wx/generic/propdlg.h>
#include <wx/menu.h>
#include <wx/propdlg.h>

#define ID_MENU_COPY                                       30000
#define ID_MENU_PASTE_TIME                                 30001
#define ID_MENU_PASTE_OBJECTS                              30002
#define ID_MENU_PASTE_SIZE                                 30003
#define ID_MENU_PASTE_DURATION                             30004
#define ID_MENU_PASTE_SEMANTIC_SCALE                       30005
#define ID_MENU_PASTE_FILTER_ALL                           30006
#define ID_MENU_PASTE_FILTER_COMMS                         30007
#define ID_MENU_PASTE_FILTER_EVENTS                        30008
#define ID_MENU_PASTE_SPECIAL                              30009
#define ID_MENU_CLONE                                      30010
#define ID_MENU_UNDO_ZOOM                                  30011
#define ID_MENU_REDO_ZOOM                                  30012
#define ID_MENU_FIT_TIME                                   30013
#define ID_MENU_FIT_SEMANTIC_MIN                           30014
#define ID_MENU_FIT_SEMANTIC_MAX                           30015
#define ID_MENU_FIT_SEMANTIC_BOTH                          30016
#define ID_MENU_FIT_OBJECTS                                30017
#define ID_MENU_VIEW_COMMUNICATION_LINES                   30018
#define ID_MENU_VIEW_EVENT_FLAGS                           30019
#define ID_MENU_CODE_COLOR                                 30020
#define ID_MENU_GRADIENT_COLOR                             30021
#define ID_MENU_NOT_NULL_GRADIENT_COLOR                    30022
#define ID_MENU_DRAWMODE_TIME_LAST                         30023
#define ID_MENU_DRAWMODE_TIME_MAXIMUM                      30024
#define ID_MENU_DRAWMODE_TIME_MINIMUM_NOT_ZERO             30025
#define ID_MENU_DRAWMODE_TIME_RANDOM                       30026
#define ID_MENU_DRAWMODE_TIME_RANDOM_NOT_ZERO              30027
#define ID_MENU_DRAWMODE_TIME_AVERAGE                      30028
#define ID_MENU_DRAWMODE_OBJECTS_LAST                      30029
#define ID_MENU_DRAWMODE_OBJECTS_MAXIMUM                   30030
#define ID_MENU_DRAWMODE_OBJECTS_MINIMUM_NOT_ZERO          30031
#define ID_MENU_DRAWMODE_OBJECTS_RANDOM                    30032
#define ID_MENU_DRAWMODE_OBJECTS_RANDOM_NOT_ZERO           30033
#define ID_MENU_DRAWMODE_OBJECTS_AVERAGE                   30034
#define ID_MENU_DRAWMODE_BOTH_LAST                         30035
#define ID_MENU_DRAWMODE_BOTH_MAXIMUM                      30036
#define ID_MENU_DRAWMODE_BOTH_MINIMUM_NOT_ZERO             30037
#define ID_MENU_DRAWMODE_BOTH_RANDOM                       30038
#define ID_MENU_DRAWMODE_BOTH_RANDOM_NOT_ZERO              30039
#define ID_MENU_DRAWMODE_BOTH_AVERAGE                      30040
#define ID_MENU_PIXEL_SIZE_x1                              30041
#define ID_MENU_PIXEL_SIZE_x2                              30042
#define ID_MENU_PIXEL_SIZE_x4                              30043
#define ID_MENU_PIXEL_SIZE_x8                              30044
#define ID_MENU_ROW_SELECTION                              30045
#define ID_MENU_SAVE_IMAGE                                 30046
#define ID_MENU_INFO_PANEL                                 30047
#define ID_MENU_AUTO_CONTROL_SCALE                         30048
#define ID_MENU_AUTO_3D_SCALE                              30049
#define ID_MENU_AUTO_DATA_GRADIENT                         30050
#define ID_MENU_GRADIENT_FUNCTION_LINEAR                   30051
#define ID_MENU_GRADIENT_FUNCTION_STEPS                    30052
#define ID_MENU_GRADIENT_FUNCTION_LOGARITHMIC              30053
#define ID_MENU_GRADIENT_FUNCTION_EXPONENTIAL              30054
#define ID_MENU_PASTE_CONTROL_SCALE                        30055
#define ID_MENU_PASTE_3D_SCALE                             30056
#define ID_MENU_SAVE_TIMELINE_AS_TEXT                      30057
#define ID_MENU_SAVE_CURRENT_PLANE_AS_TEXT                 30058
#define ID_MENU_SAVE_ALL_PLANES_AS_TEXT                    30059
#define ID_MENU_NEWGROUP                                   30060
#define ID_MENU_REMOVE_GROUP                               30061
#define ID_MENU_VIEW_FUNCTION_LINE                         30062
#define ID_MENU_PASTE_DEFAULT_SPECIAL                      30063
#define ID_MENU_CODE_COLOR_2D                              30064
#define ID_MENU_GRADIENT_COLOR_2D                          30065
#define ID_MENU_LABELS_ALL                                 30066
#define ID_MENU_LABELS_SPACED                              30067
#define ID_MENU_LABELS_POWER2                              30068
#define ID_MENU_DRAWMODE_TIME_AVERAGE_NOT_ZERO             30069
#define ID_MENU_DRAWMODE_OBJECTS_AVERAGE_NOT_ZERO          30070
#define ID_MENU_DRAWMODE_BOTH_AVERAGE_NOT_ZERO             30071
#define ID_MENU_CLUSTERING                                 30072
#define ID_MENU_CUTTER                                     30073
#define ID_MENU_DIMEMAS                                    30074
#define ID_MENU_FOLDING                                    30075
#define ID_MENU_OBJECT_AXIS_CURRENT                        30076
#define ID_MENU_OBJECT_AXIS_ALL                            30077
#define ID_MENU_OBJECT_AXIS_ZERO                           30078
#define ID_MENU_OBJECT_AXIS_FIVE                           30079
#define ID_MENU_OBJECT_AXIS_TEN                            30080
#define ID_MENU_OBJECT_AXIS_TWENTYFIVE                     30081
#define ID_MENU_SAVE_TIMELINE_AS_CFG                       30082
#define ID_MENU_SAVE_HISTOGRAM_AS_CFG                      30083
#define ID_MENU_SAVE_IMAGE_LEGEND                          30084
#define ID_MENU_DRAWMODE_TIME_MODE                         30085
#define ID_MENU_DRAWMODE_OBJECTS_MODE                      30086
#define ID_MENU_DRAWMODE_BOTH_MODE                         30087
#define ID_MENU_PASTE_CONTROL_DIMENSIONS                   30089
#define ID_MENU_PUNCTUAL                                   30090
#define ID_MENU_PUNCTUAL_WINDOW                            30091
#define ID_MENU_TIMING                                     30092
#define ID_MENU_VIEW_FUSED_LINES                           30093
#define ID_MENU_DRAWMODE_TIME_ABSOLUTE_MAXIMUM             30094
#define ID_MENU_DRAWMODE_TIME_ABSOLUTE_MINIMUM_NOT_ZERO    30095
#define ID_MENU_DRAWMODE_OBJECTS_ABSOLUTE_MAXIMUM          30096
#define ID_MENU_DRAWMODE_OBJECTS_ABSOLUTE_MINIMUM_NOT_ZERO 30097
#define ID_MENU_DRAWMODE_BOTH_ABSOLUTE_MAXIMUM             30098
#define ID_MENU_DRAWMODE_BOTH_ABSOLUTE_MINIMUM_NOT_ZERO    30099
#define ID_MENU_NOT_NULL_GRADIENT_COLOR_2D                 30100
#define ID_MENU_RENAME                                     30101
#define ID_MENU_AUTO_CONTROL_SCALE_ZERO                    30102
#define ID_MENU_SEMANTIC_SCALE_MIN_AT_ZERO                 30103
#define ID_MENU_SYNC_REMOVE_ALL_GROUPS                     30104
#define ID_MENU_USER_COMMAND                               30105
#define ID_MENU_PASTE_CUSTOM_PALETTE                       30106
#define ID_MENU_PASTE_SEMANTIC_SORT                        30107
#define ID_MENU_MESS                                       30108
#define ID_MENU_ALTERNATIVE_GRADIENT_COLOR                 30109
#define ID_MENU_ALTERNATIVE_GRADIENT_COLOR_2D              30110
#define ID_MENU_SYNC_PROP                                  30111
#define ID_SHOW_SELECTED_WINDOWS                           30112
#define ID_SHOW_ONLY_SELECTED_WINDOWS                      30113
#define ID_HIDE_SELECTED_WINDOWS                           30114
#define ID_SHOW_SELECTED_WINDOWS_TRACE                     30115
#define ID_HIDE_SELECTED_WINDOWS_TRACE                     30116

#define ID_MENU_SYNC_GROUP_BASE        31000
#define ID_MENU_SYNC_REMOVE_GROUP_BASE 32000
#define ID_MENU_SYNC_PROPERTIES_GROUP_BASE 31500

enum class PopUpMenuType
{
  POPUP_MENU_INI = 0,
  POPUP_MENU_TYPE_MIXED,
  POPUP_MENU_TYPE_HISTOGRAM_SINGLE,
  POPUP_MENU_TYPE_HISTOGRAM_MULTIPLE,
  POPUP_MENU_TYPE_TIMELINE_SINGLE,
  POPUP_MENU_TYPE_TIMELINE_MULTIPLE
};

using gWindowGenericItem = std::variant< gHistogram *, gTimeline * >;


class gPopUpMenu : public wxMenu
{
  public:
    gPopUpMenu() = delete;

    gPopUpMenu( std::vector< gWindowGenericItem > );

    gPopUpMenu( gHistogram *wichHistogramDerivedList );
    gPopUpMenu( gTimeline *wichTimelineDerivedList );
    virtual ~gPopUpMenu() = default;

    void initializePopUpMenu();

    void enablePopUpMenu();

    void enableItemByTag( const std::string tag, bool enable );
    void enableItemByTag( const std::string tag );

    void disableItemByTag( const std::string tag );

    bool isSelectObjectsAvailable();

    bool isShowTraceWindowsAvailable();

    void createRowSelectionDialog();

    void openSyncSelection( const TGroupId &groupId );

    bool ZoomAwareTransferData( RowsSelectionDialog *myDialog );

    void transferDataSelectionToObjects( RowsSelectionDialog *myDialog,
                                         bool isProcessModel,
                                         SelectionManagement< TObjectOrder, TTraceLevel > *intersectionSelectedRows,
                                         bool applyZoom );


    // Static functions
    static wxMultiChoiceDialog *createPasteSpecialDialog( wxArrayString &choices, gHistogram *whichWindow );
    static wxMultiChoiceDialog *createPasteSpecialDialog( wxArrayString &choices, gTimeline *whichWindow );

    static RowsSelectionDialog *createRowSelectionDialog( gHistogram *whichWindow );
    static RowsSelectionDialog *createRowSelectionDialog( gTimeline *whichWindow );

    static std::string getOption( wxArrayString &choices, int position );

  private:
    std::vector< gWindowGenericItem > windowGenericList;

    PopUpMenuType typeDataPopup = PopUpMenuType::POPUP_MENU_INI;

    wxMenu *popUpMenuView;
    wxMenu *popUpMenuColor;
    wxMenu *popUpMenuPaste;
    wxMenu *popUpMenuPasteFilter;
    wxMenu *popUpMenuFitSemantic;
    wxMenu *popUpMenuShowWindows;
    wxMenu *popUpMenuDrawMode;
    wxMenu *popUpMenuDrawModeTime;
    wxMenu *popUpMenuDrawModeObjects;
    wxMenu *popUpMenuDrawModeBoth;
    wxMenu *popUpMenuPixelSize;
    wxMenu *popUpMenuGradientFunction;
    wxMenu *popUpMenuSaveAsText;
    wxMenu *popUpMenuColor2D;
    wxMenu *popUpMenuLabels;
    wxMenu *popUpMenuObjectAxis;
    wxMenu *popUpMenuSave;
    wxMenu *popUpMenuRun;
    wxMenu *popUpMenuSync;
    wxMenu *popUpMenuSyncRemove;
    wxMenu *popUpMenuSyncPropertiesType;


    bool checkAllowedProperties( const char *property );

    bool allWindowsHas( std::vector< gTimeline * > timelineWindows, std::function< bool( gTimeline * ) > function );
    bool allWindowsHas( std::vector< gHistogram * > histogramWindows, std::function< bool( gHistogram * ) > function );

    template< typename... Funcs >
    bool allWindowHas( Funcs &&...funcs );


    // builder methods


    wxMenuItem *buildItem( wxMenu *baseMenuContainer,
                           const wxString &titleMenuItem,
                           const wxItemKind &typeMenuItem,
                           void ( gPopUpMenu::*callbackFunctionMenuItem )( wxCommandEvent & ),
                           const wxWindowID &windowId,
                           bool isChecked = false );

    void buildPopUpMenuZoom();
    void buildPopUpMenuView();
    void buildPopUpMenuPaste();
    void buildPopUpMenuColor();
    void buildPopUpMenuDimensionsConfiguration();
    void buildPopUpMenuFitSemantic();
    void buildPopUpMenuShowWindows();
    void buildPopUpMenuFitObjects();
    void buildPopUpMenuDrawMode();
    void buildPopUpMenuPixelSize();
    void buildPopUpMenuGradientFunction();
    void buildPopUpMenuObjectAxis();
    void buildPopUpMenuSave();
    void buildPopUpMenuRun();
    void buildPopUpMenuLabels();
    void buildPopUpMenuSync();
    void buildPopUpExtraPanel();
    void buildPopUpRunApp();


    struct BuildMenuItem
    {
        wxMenu *menuBaseItem;
        const wxString &labelStringItem;
        wxItemKind kindItem;
        void ( gPopUpMenu::*functionHandler )( wxCommandEvent & );
        int idItem;
        bool customConditionItem = true;
        bool itemHasSeparator    = false;
    };

    void buildListOfItems( std::vector< BuildMenuItem > &itemList );


    // Pop Up Menu Methods
  private:
    // MIX
    void OnPopUpCopy( wxCommandEvent &event );
    void OnPopUpPasteDefaultSpecial( wxCommandEvent &event );
    void OnPopUpPasteSpecial( wxCommandEvent &event );
    void OnPopUpPasteTime( wxCommandEvent &event );
    void OnPopUpPasteObjects( wxCommandEvent &event );
    void OnPopUpPasteSize( wxCommandEvent &event );
    void OnPopUpPasteDuration( wxCommandEvent &event );
    void OnPopUpPasteSemanticScale( wxCommandEvent &event );
    void OnPopUpPasteSemanticSort( wxCommandEvent &event );

    // TIMELINE
    void OnPopUpPasteCustomPalette( wxCommandEvent &event );
    void OnPopUpPasteFilterAll( wxCommandEvent &event );
    void OnPopUpPasteFilterCommunications( wxCommandEvent &event );
    void OnPopUpPasteFilterEvents( wxCommandEvent &event );

    // HISGORAM
    void OnPopUpPasteControlScale( wxCommandEvent &event );
    void OnPopUpPaste3DScale( wxCommandEvent &event );
    void OnPopUpPasteControlDimensions( wxCommandEvent &event );

    // MIX
    void OnPopUpClone( wxCommandEvent &event );
    void OnPopUpRename( wxCommandEvent &event );
    void OnPopUpFitTimeScale( wxCommandEvent &event );
    void OnPopUpFitObjects( wxCommandEvent &event );

    // TIMELINE
    void OnPopUpFitSemanticScaleMin( wxCommandEvent &event );
    void OnPopUpFitSemanticScaleMax( wxCommandEvent &event );
    void OnPopUpFitSemanticScale( wxCommandEvent &event );
    void OnPopUpViewCommunicationLines( wxCommandEvent &event );
    void OnPopUpViewEventFlags( wxCommandEvent &event );
    void OnPopUpFunctionLineColor( wxCommandEvent &event );
    void OnPopUpFusedLinesColor( wxCommandEvent &event );
    void OnPopUpPunctualColor( wxCommandEvent &event );
    void OnPopUpPunctualColorWindow( wxCommandEvent &event );
    void OnPopUpCodeColor( wxCommandEvent &event );
    void OnPopUpGradientColor( wxCommandEvent &event );
    void OnPopUpNotNullGradientColor( wxCommandEvent &event );
    void OnPopUpAlternativeGradientColor( wxCommandEvent &event );
    void OnPopUpSemanticScaleMinAtZero( wxCommandEvent &event );
    void OnPopUpRowSelection( wxCommandEvent &event );

    // HISTOGRAM
    void OnPopUpAutoControlScale( wxCommandEvent &event );
    void OnPopUpAutoControlScaleZero( wxCommandEvent &event );
    void OnPopUpAuto3DScale( wxCommandEvent &event );
    void OnPopUpAutoDataGradient( wxCommandEvent &event );
    void OnPopUpColor2D( wxCommandEvent &event );

    // MIX
    void OnPopUpGradientFunction( wxCommandEvent &event );
    void OnPopUpUndoZoom( wxCommandEvent &event );
    void OnPopUpRedoZoom( wxCommandEvent &event );

    // MIX
    void OnPopUpDrawModeTimeLast( wxCommandEvent &event );
    void OnPopUpDrawModeTimeRandom( wxCommandEvent &event );
    void OnPopUpDrawModeTimeRandomNotZero( wxCommandEvent &event );
    void OnPopUpDrawModeTimeMaximum( wxCommandEvent &event );
    void OnPopUpDrawModeTimeMinimumNotZero( wxCommandEvent &event );
    void OnPopUpDrawModeTimeAbsoluteMaximum( wxCommandEvent &event );
    void OnPopUpDrawModeTimeAbsoluteMinimumNotZero( wxCommandEvent &event );
    void OnPopUpDrawModeTimeAverage( wxCommandEvent &event );
    void OnPopUpDrawModeTimeAverageNotZero( wxCommandEvent &event );
    void OnPopUpDrawModeTimeMode( wxCommandEvent &event );


    // MIX
    void OnPopUpDrawModeObjectsLast( wxCommandEvent &event );
    void OnPopUpDrawModeObjectsRandom( wxCommandEvent &event );
    void OnPopUpDrawModeObjectsRandomNotZero( wxCommandEvent &event );
    void OnPopUpDrawModeObjectsMaximum( wxCommandEvent &event );
    void OnPopUpDrawModeObjectsMinimumNotZero( wxCommandEvent &event );
    void OnPopUpDrawModeObjectsAbsoluteMaximum( wxCommandEvent &event );
    void OnPopUpDrawModeObjectsAbsoluteMinimumNotZero( wxCommandEvent &event );
    void OnPopUpDrawModeObjectsAverage( wxCommandEvent &event );
    void OnPopUpDrawModeObjectsAverageNotZero( wxCommandEvent &event );
    void OnPopUpDrawModeObjectsMode( wxCommandEvent &event );

    void OnPopUpDrawModeBothLast( wxCommandEvent &event );
    void OnPopUpDrawModeBothRandom( wxCommandEvent &event );
    void OnPopUpDrawModeBothRandomNotZero( wxCommandEvent &event );
    void OnPopUpDrawModeBothMaximum( wxCommandEvent &event );
    void OnPopUpDrawModeBothMinimumNotZero( wxCommandEvent &event );
    void OnPopUpDrawModeBothAbsoluteMaximum( wxCommandEvent &event );
    void OnPopUpDrawModeBothAbsoluteMinimumNotZero( wxCommandEvent &event );
    void OnPopUpDrawModeBothAverage( wxCommandEvent &event );
    void OnPopUpDrawModeBothAverageNotZero( wxCommandEvent &event );
    void OnPopUpDrawModeBothMode( wxCommandEvent &event );

    void OnPopUpPixelSize( wxCommandEvent &event );
    void OnPopUpSynchronize( wxCommandEvent &event );
    void OnPopUpSynchronizeProperties( wxCommandEvent &event );
    void OnPopUpRemoveGroup( wxCommandEvent &event );
    void OnPopUpRemoveAllGroups( wxCommandEvent &event );

    void OnPopUpShowSelectedWindows( wxCommandEvent &event );
    void OnPopUpShowOnlySelectedWindows( wxCommandEvent &event );

    void OnPopUpHideSelectedWindows( wxCommandEvent &event );

    void OnPopUpShowSelectedWindowsTrace( wxCommandEvent &event );
    void OnPopUpHideSelectedWindowsTrace( wxCommandEvent &event );

    // Timeline
    void OnPopUpLabels( wxCommandEvent &event );
    void OnPopUpObjectAxis( wxCommandEvent &event );
    void OnPopUpRunApp( wxCommandEvent &event );

    void OnPopUpTiming( wxCommandEvent &event );
    void OnPopUpInfoPanel( wxCommandEvent &event );

    // MIX
    void OnPopUpSaveCFG( wxCommandEvent &event );
    void OnPopUpSaveImageDialog( wxCommandEvent &event );

    // Timeline
    void OnPopUpSaveText( wxCommandEvent &event );


    template< typename... Funcs >
    void onAllWindowsCall( Funcs &&...funcs );
};
